/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.scheme;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.apache.http.HttpHost;
import org.apache.http.conn.scheme.Scheme;

@ThreadSafe
public final class SchemeRegistry {
    @GuardedBy(value="this")
    private final Map<String, Scheme> registeredSchemes = new LinkedHashMap<String, Scheme>();

    public final synchronized Scheme getScheme(String string) {
        Scheme scheme = this.get(string);
        if (scheme == null) {
            throw new IllegalStateException("Scheme '" + string + "' not registered.");
        }
        return scheme;
    }

    public final synchronized Scheme getScheme(HttpHost httpHost) {
        if (httpHost == null) {
            throw new IllegalArgumentException("Host must not be null.");
        }
        return this.getScheme(httpHost.getSchemeName());
    }

    public final synchronized Scheme get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        Scheme scheme = this.registeredSchemes.get(string);
        return scheme;
    }

    public final synchronized Scheme register(Scheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme must not be null.");
        }
        Scheme scheme2 = this.registeredSchemes.put(scheme.getName(), scheme);
        return scheme2;
    }

    public final synchronized Scheme unregister(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        Scheme scheme = this.registeredSchemes.remove(string);
        return scheme;
    }

    public final synchronized List<String> getSchemeNames() {
        return new ArrayList<String>(this.registeredSchemes.keySet());
    }

    public synchronized void setItems(Map<String, Scheme> map) {
        if (map == null) {
            return;
        }
        this.registeredSchemes.clear();
        this.registeredSchemes.putAll(map);
    }
}

