/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import net.jcip.annotations.NotThreadSafe;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public abstract class AuthSchemeBase
implements AuthScheme {
    private boolean proxy;

    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        int n;
        CharArrayBuffer charArrayBuffer;
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        String string = header.getName();
        if (string.equalsIgnoreCase("WWW-Authenticate")) {
            this.proxy = false;
        } else if (string.equalsIgnoreCase("Proxy-Authenticate")) {
            this.proxy = true;
        } else {
            throw new MalformedChallengeException("Unexpected header name: " + string);
        }
        if (header instanceof FormattedHeader) {
            charArrayBuffer = ((FormattedHeader)header).getBuffer();
            n = ((FormattedHeader)header).getValuePos();
        } else {
            String string2 = header.getValue();
            if (string2 == null) {
                throw new MalformedChallengeException("Header value is null");
            }
            charArrayBuffer = new CharArrayBuffer(string2.length());
            charArrayBuffer.append(string2);
            n = 0;
        }
        while (n < charArrayBuffer.length() && HTTP.isWhitespace((char)charArrayBuffer.charAt(n))) {
            ++n;
        }
        int n2 = n;
        while (n < charArrayBuffer.length() && !HTTP.isWhitespace((char)charArrayBuffer.charAt(n))) {
            ++n;
        }
        int n3 = n;
        String string3 = charArrayBuffer.substring(n2, n3);
        if (!string3.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid scheme identifier: " + string3);
        }
        this.parseChallenge(charArrayBuffer, n, charArrayBuffer.length());
    }

    protected abstract void parseChallenge(CharArrayBuffer var1, int var2, int var3) throws MalformedChallengeException;

    public boolean isProxy() {
        return this.proxy;
    }

    public String toString() {
        return this.getSchemeName();
    }
}

