/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.RedirectException;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.RequestDirector;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.BasicManagedEntity;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.routing.BasicRouteDirector;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.impl.client.HttpRedirect;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.client.RoutedRequest;
import org.apache.http.impl.client.TunnelRefusedException;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;

@NotThreadSafe
public class DefaultRequestDirector
implements RequestDirector {
    private final Log log = LogFactory.getLog(this.getClass());
    protected final ClientConnectionManager connManager;
    protected final HttpRoutePlanner routePlanner;
    protected final ConnectionReuseStrategy reuseStrategy;
    protected final ConnectionKeepAliveStrategy keepAliveStrategy;
    protected final HttpRequestExecutor requestExec;
    protected final HttpProcessor httpProcessor;
    protected final HttpRequestRetryHandler retryHandler;
    protected final RedirectHandler redirectHandler;
    protected final AuthenticationHandler targetAuthHandler;
    protected final AuthenticationHandler proxyAuthHandler;
    protected final UserTokenHandler userTokenHandler;
    protected final HttpParams params;
    protected ManagedClientConnection managedConn;
    protected final AuthState targetAuthState;
    protected final AuthState proxyAuthState;
    private int redirectCount;
    private int maxRedirects;
    private HttpHost virtualHost;

    public DefaultRequestDirector(HttpRequestExecutor httpRequestExecutor, ClientConnectionManager clientConnectionManager, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy, HttpRoutePlanner httpRoutePlanner, HttpProcessor httpProcessor, HttpRequestRetryHandler httpRequestRetryHandler, RedirectHandler redirectHandler, AuthenticationHandler authenticationHandler, AuthenticationHandler authenticationHandler2, UserTokenHandler userTokenHandler, HttpParams httpParams) {
        if (httpRequestExecutor == null) {
            throw new IllegalArgumentException("Request executor may not be null.");
        }
        if (clientConnectionManager == null) {
            throw new IllegalArgumentException("Client connection manager may not be null.");
        }
        if (connectionReuseStrategy == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null.");
        }
        if (connectionKeepAliveStrategy == null) {
            throw new IllegalArgumentException("Connection keep alive strategy may not be null.");
        }
        if (httpRoutePlanner == null) {
            throw new IllegalArgumentException("Route planner may not be null.");
        }
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP protocol processor may not be null.");
        }
        if (httpRequestRetryHandler == null) {
            throw new IllegalArgumentException("HTTP request retry handler may not be null.");
        }
        if (redirectHandler == null) {
            throw new IllegalArgumentException("Redirect handler may not be null.");
        }
        if (authenticationHandler == null) {
            throw new IllegalArgumentException("Target authentication handler may not be null.");
        }
        if (authenticationHandler2 == null) {
            throw new IllegalArgumentException("Proxy authentication handler may not be null.");
        }
        if (userTokenHandler == null) {
            throw new IllegalArgumentException("User token handler may not be null.");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.requestExec = httpRequestExecutor;
        this.connManager = clientConnectionManager;
        this.reuseStrategy = connectionReuseStrategy;
        this.keepAliveStrategy = connectionKeepAliveStrategy;
        this.routePlanner = httpRoutePlanner;
        this.httpProcessor = httpProcessor;
        this.retryHandler = httpRequestRetryHandler;
        this.redirectHandler = redirectHandler;
        this.targetAuthHandler = authenticationHandler;
        this.proxyAuthHandler = authenticationHandler2;
        this.userTokenHandler = userTokenHandler;
        this.params = httpParams;
        this.managedConn = null;
        this.redirectCount = 0;
        this.maxRedirects = this.params.getIntParameter("http.protocol.max-redirects", 100);
        this.targetAuthState = new AuthState();
        this.proxyAuthState = new AuthState();
    }

    private RequestWrapper wrapRequest(HttpRequest httpRequest) throws ProtocolException {
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            return new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)httpRequest);
        }
        return new RequestWrapper(httpRequest);
    }

    protected void rewriteRequestURI(RequestWrapper requestWrapper, HttpRoute httpRoute) throws ProtocolException {
        try {
            URI uRI = requestWrapper.getURI();
            if (httpRoute.getProxyHost() != null && !httpRoute.isTunnelled()) {
                if (!uRI.isAbsolute()) {
                    HttpHost httpHost = httpRoute.getTargetHost();
                    uRI = URIUtils.rewriteURI(uRI, httpHost);
                    requestWrapper.setURI(uRI);
                }
            } else if (uRI.isAbsolute()) {
                uRI = URIUtils.rewriteURI(uRI, null);
                requestWrapper.setURI(uRI);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid URI: " + requestWrapper.getRequestLine().getUri(), (Throwable)uRISyntaxException);
        }
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        HttpRequest httpRequest2 = httpRequest;
        RequestWrapper requestWrapper = this.wrapRequest(httpRequest2);
        requestWrapper.setParams(this.params);
        HttpRoute httpRoute = this.determineRoute(httpHost, requestWrapper, httpContext);
        this.virtualHost = (HttpHost)httpRequest2.getParams().getParameter("http.virtual-host");
        RoutedRequest routedRequest = new RoutedRequest(requestWrapper, httpRoute);
        long l = ConnManagerParams.getTimeout(this.params);
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            Object object;
            HttpResponse httpResponse = null;
            while (!bl2) {
                RoutedRequest routedRequest2;
                IOException iOException;
                ClientConnectionRequest clientConnectionRequest;
                object = routedRequest.getRequest();
                HttpRoute httpRoute2 = routedRequest.getRoute();
                httpResponse = null;
                Object object2 = httpContext.getAttribute("http.user-token");
                if (this.managedConn == null) {
                    clientConnectionRequest = this.connManager.requestConnection(httpRoute2, object2);
                    if (httpRequest2 instanceof AbortableHttpRequest) {
                        ((AbortableHttpRequest)httpRequest2).setConnectionRequest(clientConnectionRequest);
                    }
                    try {
                        this.managedConn = clientConnectionRequest.getConnection(l, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        iOException = new InterruptedIOException();
                        iOException.initCause(interruptedException);
                        throw iOException;
                    }
                    if (HttpConnectionParams.isStaleCheckingEnabled((HttpParams)this.params) && this.managedConn.isOpen()) {
                        this.log.debug((Object)"Stale connection check");
                        if (this.managedConn.isStale()) {
                            this.log.debug((Object)"Stale connection detected");
                            this.managedConn.close();
                        }
                    }
                }
                if (httpRequest2 instanceof AbortableHttpRequest) {
                    ((AbortableHttpRequest)httpRequest2).setReleaseTrigger(this.managedConn);
                }
                if (!this.managedConn.isOpen()) {
                    this.managedConn.open(httpRoute2, httpContext, this.params);
                }
                try {
                    this.establishRoute(httpRoute2, httpContext);
                }
                catch (TunnelRefusedException tunnelRefusedException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)tunnelRefusedException.getMessage());
                    }
                    httpResponse = tunnelRefusedException.getResponse();
                    break;
                }
                ((RequestWrapper)object).resetHeaders();
                this.rewriteRequestURI((RequestWrapper)object, httpRoute2);
                httpHost = this.virtualHost;
                if (httpHost == null) {
                    httpHost = httpRoute2.getTargetHost();
                }
                clientConnectionRequest = httpRoute2.getProxyHost();
                httpContext.setAttribute("http.target_host", (Object)httpHost);
                httpContext.setAttribute("http.proxy_host", (Object)clientConnectionRequest);
                httpContext.setAttribute("http.connection", (Object)this.managedConn);
                httpContext.setAttribute("http.auth.target-scope", (Object)this.targetAuthState);
                httpContext.setAttribute("http.auth.proxy-scope", (Object)this.proxyAuthState);
                this.requestExec.preProcess((HttpRequest)object, this.httpProcessor, httpContext);
                boolean bl3 = true;
                iOException = null;
                while (bl3) {
                    ++n;
                    ((RequestWrapper)object).incrementExecCount();
                    if (((RequestWrapper)object).getExecCount() > 1 && !((RequestWrapper)object).isRepeatable()) {
                        this.log.debug((Object)"Cannot retry non-repeatable request");
                        if (iOException != null) {
                            throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.  The cause lists the reason the original request failed.", iOException);
                        }
                        throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.");
                    }
                    try {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Attempt " + n + " to execute request"));
                        }
                        httpResponse = this.requestExec.execute((HttpRequest)object, (HttpClientConnection)this.managedConn, httpContext);
                        bl3 = false;
                    }
                    catch (IOException iOException2) {
                        this.log.debug((Object)"Closing the connection.");
                        this.managedConn.close();
                        if (this.retryHandler.retryRequest(iOException2, n, httpContext)) {
                            if (this.log.isInfoEnabled()) {
                                this.log.info((Object)("I/O exception (" + iOException2.getClass().getName() + ") caught when processing request: " + iOException2.getMessage()));
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)iOException2.getMessage(), (Throwable)iOException2);
                            }
                        } else {
                            throw iOException2;
                        }
                        this.log.info((Object)"Retrying request");
                        iOException = iOException2;
                        if (!httpRoute2.isTunnelled()) {
                            this.log.debug((Object)"Reopening the direct connection.");
                            this.managedConn.open(httpRoute2, httpContext, this.params);
                            continue;
                        }
                        this.log.debug((Object)"Proxied connection. Need to start over.");
                        bl3 = false;
                    }
                }
                if (httpResponse == null) continue;
                httpResponse.setParams(this.params);
                this.requestExec.postProcess(httpResponse, this.httpProcessor, httpContext);
                bl = this.reuseStrategy.keepAlive(httpResponse, httpContext);
                if (bl) {
                    long l2 = this.keepAliveStrategy.getKeepAliveDuration(httpResponse, httpContext);
                    this.managedConn.setIdleDuration(l2, TimeUnit.MILLISECONDS);
                    if (this.log.isDebugEnabled()) {
                        if (l2 >= 0L) {
                            this.log.debug((Object)("Connection can be kept alive for " + l2 + " ms"));
                        } else {
                            this.log.debug((Object)"Connection can be kept alive indefinitely");
                        }
                    }
                }
                if ((routedRequest2 = this.handleResponse(routedRequest, httpResponse, httpContext)) == null) {
                    bl2 = true;
                } else {
                    if (bl) {
                        HttpEntity httpEntity = httpResponse.getEntity();
                        if (httpEntity != null) {
                            httpEntity.consumeContent();
                        }
                        this.managedConn.markReusable();
                    } else {
                        this.managedConn.close();
                    }
                    if (!routedRequest2.getRoute().equals(routedRequest.getRoute())) {
                        this.releaseConnection();
                    }
                    routedRequest = routedRequest2;
                }
                if (this.managedConn == null || object2 != null) continue;
                object2 = this.userTokenHandler.getUserToken(httpContext);
                httpContext.setAttribute("http.user-token", object2);
                if (object2 == null) continue;
                this.managedConn.setState(object2);
            }
            if (httpResponse == null || httpResponse.getEntity() == null || !httpResponse.getEntity().isStreaming()) {
                if (bl) {
                    this.managedConn.markReusable();
                }
                this.releaseConnection();
            } else {
                object = httpResponse.getEntity();
                object = new BasicManagedEntity((HttpEntity)object, this.managedConn, bl);
                httpResponse.setEntity((HttpEntity)object);
            }
            return httpResponse;
        }
        catch (HttpException httpException) {
            this.abortConnection();
            throw httpException;
        }
        catch (IOException iOException) {
            this.abortConnection();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortConnection();
            throw runtimeException;
        }
    }

    protected void releaseConnection() {
        try {
            this.managedConn.releaseConnection();
        }
        catch (IOException iOException) {
            this.log.debug((Object)"IOException releasing connection", (Throwable)iOException);
        }
        this.managedConn = null;
    }

    protected HttpRoute determineRoute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        if (httpHost == null) {
            httpHost = (HttpHost)httpRequest.getParams().getParameter("http.default-host");
        }
        if (httpHost == null) {
            throw new IllegalStateException("Target host must not be null, or set in parameters.");
        }
        return this.routePlanner.determineRoute(httpHost, httpRequest, httpContext);
    }

    protected void establishRoute(HttpRoute httpRoute, HttpContext httpContext) throws HttpException, IOException {
        int n;
        BasicRouteDirector basicRouteDirector = new BasicRouteDirector();
        do {
            HttpRoute httpRoute2 = this.managedConn.getRoute();
            n = basicRouteDirector.nextStep(httpRoute, httpRoute2);
            switch (n) {
                case 1: 
                case 2: {
                    this.managedConn.open(httpRoute, httpContext, this.params);
                    break;
                }
                case 3: {
                    int n2 = this.createTunnelToTarget(httpRoute, httpContext);
                    this.log.debug((Object)"Tunnel to target created.");
                    this.managedConn.tunnelTarget(n2 != 0, this.params);
                    break;
                }
                case 4: {
                    int n2 = httpRoute2.getHopCount() - 1;
                    boolean bl = this.createTunnelToProxy(httpRoute, n2, httpContext);
                    this.log.debug((Object)"Tunnel to proxy created.");
                    this.managedConn.tunnelProxy(httpRoute.getHopTarget(n2), bl, this.params);
                    break;
                }
                case 5: {
                    this.managedConn.layerProtocol(httpContext, this.params);
                    break;
                }
                case -1: {
                    throw new IllegalStateException("Unable to establish route.\nplanned = " + httpRoute + "\ncurrent = " + httpRoute2);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown step indicator " + n + " from RouteDirector.");
                }
            }
        } while (n > 0);
    }

    protected boolean createTunnelToTarget(HttpRoute httpRoute, HttpContext httpContext) throws HttpException, IOException {
        int n;
        HttpHost httpHost = httpRoute.getProxyHost();
        HttpHost httpHost2 = httpRoute.getTargetHost();
        HttpResponse httpResponse = null;
        boolean bl = false;
        while (!bl) {
            bl = true;
            if (!this.managedConn.isOpen()) {
                this.managedConn.open(httpRoute, httpContext, this.params);
            }
            HttpRequest httpRequest = this.createConnectRequest(httpRoute, httpContext);
            httpRequest.setParams(this.params);
            httpContext.setAttribute("http.target_host", (Object)httpHost2);
            httpContext.setAttribute("http.proxy_host", (Object)httpHost);
            httpContext.setAttribute("http.connection", (Object)this.managedConn);
            httpContext.setAttribute("http.auth.target-scope", (Object)this.targetAuthState);
            httpContext.setAttribute("http.auth.proxy-scope", (Object)this.proxyAuthState);
            httpContext.setAttribute("http.request", (Object)httpRequest);
            this.requestExec.preProcess(httpRequest, this.httpProcessor, httpContext);
            httpResponse = this.requestExec.execute(httpRequest, (HttpClientConnection)this.managedConn, httpContext);
            httpResponse.setParams(this.params);
            this.requestExec.postProcess(httpResponse, this.httpProcessor, httpContext);
            int n2 = httpResponse.getStatusLine().getStatusCode();
            if (n2 < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + httpResponse.getStatusLine());
            }
            CredentialsProvider credentialsProvider = (CredentialsProvider)httpContext.getAttribute("http.auth.credentials-provider");
            if (credentialsProvider == null || !HttpClientParams.isAuthenticating(this.params)) continue;
            if (this.proxyAuthHandler.isAuthenticationRequested(httpResponse, httpContext)) {
                block9: {
                    this.log.debug((Object)"Proxy requested authentication");
                    Map<String, Header> map = this.proxyAuthHandler.getChallenges(httpResponse, httpContext);
                    try {
                        this.processChallenges(map, this.proxyAuthState, this.proxyAuthHandler, httpResponse, httpContext);
                    }
                    catch (AuthenticationException authenticationException) {
                        if (!this.log.isWarnEnabled()) break block9;
                        this.log.warn((Object)("Authentication error: " + authenticationException.getMessage()));
                        break;
                    }
                }
                this.updateAuthState(this.proxyAuthState, httpHost, credentialsProvider);
                if (this.proxyAuthState.getCredentials() == null) continue;
                bl = false;
                if (this.reuseStrategy.keepAlive(httpResponse, httpContext)) {
                    this.log.debug((Object)"Connection kept alive");
                    HttpEntity httpEntity = httpResponse.getEntity();
                    if (httpEntity == null) continue;
                    httpEntity.consumeContent();
                    continue;
                }
                this.managedConn.close();
                continue;
            }
            this.proxyAuthState.setAuthScope(null);
        }
        if ((n = httpResponse.getStatusLine().getStatusCode()) > 299) {
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                httpResponse.setEntity((HttpEntity)new BufferedHttpEntity(httpEntity));
            }
            this.managedConn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + httpResponse.getStatusLine(), httpResponse);
        }
        this.managedConn.markReusable();
        return false;
    }

    protected boolean createTunnelToProxy(HttpRoute httpRoute, int n, HttpContext httpContext) throws HttpException, IOException {
        throw new UnsupportedOperationException("Proxy chains are not supported.");
    }

    protected HttpRequest createConnectRequest(HttpRoute httpRoute, HttpContext httpContext) {
        Object object;
        HttpHost httpHost = httpRoute.getTargetHost();
        String string = httpHost.getHostName();
        int n = httpHost.getPort();
        if (n < 0) {
            object = this.connManager.getSchemeRegistry().getScheme(httpHost.getSchemeName());
            n = ((Scheme)object).getDefaultPort();
        }
        object = new StringBuilder(string.length() + 6);
        ((StringBuilder)object).append(string);
        ((StringBuilder)object).append(':');
        ((StringBuilder)object).append(Integer.toString(n));
        String string2 = ((StringBuilder)object).toString();
        ProtocolVersion protocolVersion = HttpProtocolParams.getVersion((HttpParams)this.params);
        BasicHttpRequest basicHttpRequest = new BasicHttpRequest("CONNECT", string2, protocolVersion);
        return basicHttpRequest;
    }

    protected RoutedRequest handleResponse(RoutedRequest routedRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        HttpRoute httpRoute = routedRequest.getRoute();
        RequestWrapper requestWrapper = routedRequest.getRequest();
        HttpParams httpParams = requestWrapper.getParams();
        if (HttpClientParams.isRedirecting(httpParams) && this.redirectHandler.isRedirectRequested(httpResponse, httpContext)) {
            Object object;
            if (this.redirectCount >= this.maxRedirects) {
                throw new RedirectException("Maximum redirects (" + this.maxRedirects + ") exceeded");
            }
            ++this.redirectCount;
            this.virtualHost = null;
            URI uRI = this.redirectHandler.getLocationURI(httpResponse, httpContext);
            HttpHost httpHost = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
            if (!httpRoute.getTargetHost().equals((Object)httpHost)) {
                this.targetAuthState.invalidate();
                object = this.proxyAuthState.getAuthScheme();
                if (object != null && object.isConnectionBased()) {
                    this.proxyAuthState.invalidate();
                }
            }
            object = new HttpRedirect(requestWrapper.getMethod(), uRI);
            HttpRequest httpRequest = requestWrapper.getOriginal();
            object.setHeaders(httpRequest.getAllHeaders());
            RequestWrapper requestWrapper2 = new RequestWrapper((HttpRequest)object);
            requestWrapper2.setParams(httpParams);
            HttpRoute httpRoute2 = this.determineRoute(httpHost, requestWrapper2, httpContext);
            RoutedRequest routedRequest2 = new RoutedRequest(requestWrapper2, httpRoute2);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Redirecting to '" + uRI + "' via " + httpRoute2));
            }
            return routedRequest2;
        }
        CredentialsProvider credentialsProvider = (CredentialsProvider)httpContext.getAttribute("http.auth.credentials-provider");
        if (credentialsProvider != null && HttpClientParams.isAuthenticating(httpParams)) {
            if (this.targetAuthHandler.isAuthenticationRequested(httpResponse, httpContext)) {
                HttpHost httpHost;
                block15: {
                    httpHost = (HttpHost)httpContext.getAttribute("http.target_host");
                    if (httpHost == null) {
                        httpHost = httpRoute.getTargetHost();
                    }
                    this.log.debug((Object)"Target requested authentication");
                    Map<String, Header> map = this.targetAuthHandler.getChallenges(httpResponse, httpContext);
                    try {
                        this.processChallenges(map, this.targetAuthState, this.targetAuthHandler, httpResponse, httpContext);
                    }
                    catch (AuthenticationException authenticationException) {
                        if (!this.log.isWarnEnabled()) break block15;
                        this.log.warn((Object)("Authentication error: " + authenticationException.getMessage()));
                        return null;
                    }
                }
                this.updateAuthState(this.targetAuthState, httpHost, credentialsProvider);
                if (this.targetAuthState.getCredentials() != null) {
                    return routedRequest;
                }
                return null;
            }
            this.targetAuthState.setAuthScope(null);
            if (this.proxyAuthHandler.isAuthenticationRequested(httpResponse, httpContext)) {
                HttpHost httpHost;
                block16: {
                    httpHost = httpRoute.getProxyHost();
                    this.log.debug((Object)"Proxy requested authentication");
                    Map<String, Header> map = this.proxyAuthHandler.getChallenges(httpResponse, httpContext);
                    try {
                        this.processChallenges(map, this.proxyAuthState, this.proxyAuthHandler, httpResponse, httpContext);
                    }
                    catch (AuthenticationException authenticationException) {
                        if (!this.log.isWarnEnabled()) break block16;
                        this.log.warn((Object)("Authentication error: " + authenticationException.getMessage()));
                        return null;
                    }
                }
                this.updateAuthState(this.proxyAuthState, httpHost, credentialsProvider);
                if (this.proxyAuthState.getCredentials() != null) {
                    return routedRequest;
                }
                return null;
            }
            this.proxyAuthState.setAuthScope(null);
        }
        return null;
    }

    private void abortConnection() {
        ManagedClientConnection managedClientConnection = this.managedConn;
        if (managedClientConnection != null) {
            block5: {
                this.managedConn = null;
                try {
                    managedClientConnection.abortConnection();
                }
                catch (IOException iOException) {
                    if (!this.log.isDebugEnabled()) break block5;
                    this.log.debug((Object)iOException.getMessage(), (Throwable)iOException);
                }
            }
            try {
                managedClientConnection.releaseConnection();
            }
            catch (IOException iOException) {
                this.log.debug((Object)"Error releasing connection", (Throwable)iOException);
            }
        }
    }

    private void processChallenges(Map<String, Header> map, AuthState authState, AuthenticationHandler authenticationHandler, HttpResponse httpResponse, HttpContext httpContext) throws MalformedChallengeException, AuthenticationException {
        String string;
        Header header;
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme == null) {
            authScheme = authenticationHandler.selectScheme(map, httpResponse, httpContext);
            authState.setAuthScheme(authScheme);
        }
        if ((header = map.get((string = authScheme.getSchemeName()).toLowerCase(Locale.ENGLISH))) == null) {
            throw new AuthenticationException(string + " authorization challenge expected, but not found");
        }
        authScheme.processChallenge(header);
        this.log.debug((Object)"Authorization challenge processed");
    }

    private void updateAuthState(AuthState authState, HttpHost httpHost, CredentialsProvider credentialsProvider) {
        Credentials credentials;
        Object object;
        if (!authState.isValid()) {
            return;
        }
        String string = httpHost.getHostName();
        int n = httpHost.getPort();
        if (n < 0) {
            object = this.connManager.getSchemeRegistry().getScheme(httpHost);
            n = ((Scheme)object).getDefaultPort();
        }
        object = authState.getAuthScheme();
        AuthScope authScope = new AuthScope(string, n, object.getRealm(), object.getSchemeName());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authentication scope: " + authScope));
        }
        if ((credentials = authState.getCredentials()) == null) {
            credentials = credentialsProvider.getCredentials(authScope);
            if (this.log.isDebugEnabled()) {
                if (credentials != null) {
                    this.log.debug((Object)"Found credentials");
                } else {
                    this.log.debug((Object)"Credentials not found");
                }
            }
        } else if (object.isComplete()) {
            this.log.debug((Object)"Authentication failed");
            credentials = null;
        }
        authState.setAuthScope(authScope);
        authState.setCredentials(credentials);
    }
}

