/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.AbstractClientConnAdapter;
import org.apache.http.impl.conn.AbstractPoolEntry;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public abstract class AbstractPooledConnAdapter
extends AbstractClientConnAdapter {
    protected volatile AbstractPoolEntry poolEntry;

    protected AbstractPooledConnAdapter(ClientConnectionManager clientConnectionManager, AbstractPoolEntry abstractPoolEntry) {
        super(clientConnectionManager, abstractPoolEntry.connection);
        this.poolEntry = abstractPoolEntry;
    }

    protected final void assertAttached() {
        if (this.poolEntry == null) {
            throw new IllegalStateException("Adapter is detached.");
        }
    }

    @Override
    protected void detach() {
        super.detach();
        this.poolEntry = null;
    }

    @Override
    public HttpRoute getRoute() {
        this.assertAttached();
        return this.poolEntry.tracker == null ? null : this.poolEntry.tracker.toRoute();
    }

    @Override
    public void open(HttpRoute httpRoute, HttpContext httpContext, HttpParams httpParams) throws IOException {
        this.assertAttached();
        this.poolEntry.open(httpRoute, httpContext, httpParams);
    }

    @Override
    public void tunnelTarget(boolean bl, HttpParams httpParams) throws IOException {
        this.assertAttached();
        this.poolEntry.tunnelTarget(bl, httpParams);
    }

    @Override
    public void tunnelProxy(HttpHost httpHost, boolean bl, HttpParams httpParams) throws IOException {
        this.assertAttached();
        this.poolEntry.tunnelProxy(httpHost, bl, httpParams);
    }

    @Override
    public void layerProtocol(HttpContext httpContext, HttpParams httpParams) throws IOException {
        this.assertAttached();
        this.poolEntry.layerProtocol(httpContext, httpParams);
    }

    public void close() throws IOException {
        OperatedClientConnection operatedClientConnection;
        if (this.poolEntry != null) {
            this.poolEntry.shutdownEntry();
        }
        if ((operatedClientConnection = this.getWrappedConnection()) != null) {
            operatedClientConnection.close();
        }
    }

    public void shutdown() throws IOException {
        OperatedClientConnection operatedClientConnection;
        if (this.poolEntry != null) {
            this.poolEntry.shutdownEntry();
        }
        if ((operatedClientConnection = this.getWrappedConnection()) != null) {
            operatedClientConnection.shutdown();
        }
    }

    @Override
    public Object getState() {
        this.assertAttached();
        return this.poolEntry.getState();
    }

    @Override
    public void setState(Object object) {
        this.assertAttached();
        this.poolEntry.setState(object);
    }
}

