/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public abstract class StopwordAnalyzerBase
extends ReusableAnalyzerBase {
    protected final CharArraySet stopwords;
    protected final Version matchVersion;

    public Set<?> getStopwordSet() {
        return this.stopwords;
    }

    protected StopwordAnalyzerBase(Version version, Set<?> set) {
        this.matchVersion = version;
        this.stopwords = set == null ? CharArraySet.EMPTY_SET : CharArraySet.unmodifiableSet(CharArraySet.copy(version, set));
    }

    protected StopwordAnalyzerBase(Version version) {
        this(version, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CharArraySet loadStopwordSet(boolean bl, Class<? extends ReusableAnalyzerBase> clazz, String string, String string2) throws IOException {
        CharArraySet charArraySet;
        Reader reader = null;
        try {
            reader = IOUtils.getDecodingReader(clazz.getResourceAsStream(string), IOUtils.CHARSET_UTF_8);
            charArraySet = WordlistLoader.getWordSet(reader, string2, new CharArraySet(Version.LUCENE_31, 16, bl));
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
        return charArraySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CharArraySet loadStopwordSet(File file, Version version) throws IOException {
        CharArraySet charArraySet;
        Reader reader = null;
        try {
            reader = IOUtils.getDecodingReader(file, IOUtils.CHARSET_UTF_8);
            charArraySet = WordlistLoader.getWordSet(reader, version);
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
        return charArraySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CharArraySet loadStopwordSet(Reader reader, Version version) throws IOException {
        CharArraySet charArraySet;
        try {
            charArraySet = WordlistLoader.getWordSet(reader, version);
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
        return charArraySet;
    }
}

