/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeSource;

public final class TeeSinkTokenFilter
extends TokenFilter {
    private final List<WeakReference<SinkTokenStream>> sinks = new LinkedList<WeakReference<SinkTokenStream>>();
    private static final SinkFilter ACCEPT_ALL_FILTER = new SinkFilter(){

        @Override
        public boolean accept(AttributeSource attributeSource) {
            return true;
        }
    };

    public TeeSinkTokenFilter(TokenStream tokenStream) {
        super(tokenStream);
    }

    public SinkTokenStream newSinkTokenStream() {
        return this.newSinkTokenStream(ACCEPT_ALL_FILTER);
    }

    public SinkTokenStream newSinkTokenStream(SinkFilter sinkFilter) {
        SinkTokenStream sinkTokenStream = new SinkTokenStream(this.cloneAttributes(), sinkFilter);
        this.sinks.add(new WeakReference<SinkTokenStream>(sinkTokenStream));
        return sinkTokenStream;
    }

    public void addSinkTokenStream(SinkTokenStream sinkTokenStream) {
        if (!this.getAttributeFactory().equals(sinkTokenStream.getAttributeFactory())) {
            throw new IllegalArgumentException("The supplied sink is not compatible to this tee");
        }
        Iterator<AttributeImpl> iterator = this.cloneAttributes().getAttributeImplsIterator();
        while (iterator.hasNext()) {
            sinkTokenStream.addAttributeImpl(iterator.next());
        }
        this.sinks.add(new WeakReference<SinkTokenStream>(sinkTokenStream));
    }

    public void consumeAllTokens() throws IOException {
        while (this.incrementToken()) {
        }
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            AttributeSource.State state = null;
            for (WeakReference<SinkTokenStream> weakReference : this.sinks) {
                SinkTokenStream sinkTokenStream = (SinkTokenStream)weakReference.get();
                if (sinkTokenStream == null || !sinkTokenStream.accept(this)) continue;
                if (state == null) {
                    state = this.captureState();
                }
                sinkTokenStream.addState(state);
            }
            return true;
        }
        return false;
    }

    @Override
    public final void end() throws IOException {
        super.end();
        AttributeSource.State state = this.captureState();
        for (WeakReference<SinkTokenStream> weakReference : this.sinks) {
            SinkTokenStream sinkTokenStream = (SinkTokenStream)weakReference.get();
            if (sinkTokenStream == null) continue;
            sinkTokenStream.setFinalState(state);
        }
    }

    public static final class SinkTokenStream
    extends TokenStream {
        private final List<AttributeSource.State> cachedStates = new LinkedList<AttributeSource.State>();
        private AttributeSource.State finalState;
        private Iterator<AttributeSource.State> it = null;
        private SinkFilter filter;

        private SinkTokenStream(AttributeSource attributeSource, SinkFilter sinkFilter) {
            super(attributeSource);
            this.filter = sinkFilter;
        }

        private boolean accept(AttributeSource attributeSource) {
            return this.filter.accept(attributeSource);
        }

        private void addState(AttributeSource.State state) {
            if (this.it != null) {
                throw new IllegalStateException("The tee must be consumed before sinks are consumed.");
            }
            this.cachedStates.add(state);
        }

        private void setFinalState(AttributeSource.State state) {
            this.finalState = state;
        }

        @Override
        public final boolean incrementToken() throws IOException {
            if (this.it == null) {
                this.it = this.cachedStates.iterator();
            }
            if (!this.it.hasNext()) {
                return false;
            }
            AttributeSource.State state = this.it.next();
            this.restoreState(state);
            return true;
        }

        @Override
        public final void end() throws IOException {
            if (this.finalState != null) {
                this.restoreState(this.finalState);
            }
        }

        @Override
        public final void reset() {
            this.it = this.cachedStates.iterator();
        }
    }

    public static abstract class SinkFilter {
        public abstract boolean accept(AttributeSource var1);

        public void reset() throws IOException {
        }
    }
}

