/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.CharReader;
import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.AttributeSource;

public abstract class Tokenizer
extends TokenStream {
    protected Reader input;

    protected Tokenizer() {
    }

    protected Tokenizer(Reader reader) {
        this.input = CharReader.get(reader);
    }

    protected Tokenizer(AttributeSource.AttributeFactory attributeFactory) {
        super(attributeFactory);
    }

    protected Tokenizer(AttributeSource.AttributeFactory attributeFactory, Reader reader) {
        super(attributeFactory);
        this.input = CharReader.get(reader);
    }

    protected Tokenizer(AttributeSource attributeSource) {
        super(attributeSource);
    }

    protected Tokenizer(AttributeSource attributeSource, Reader reader) {
        super(attributeSource);
        this.input = CharReader.get(reader);
    }

    @Override
    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
    }

    protected final int correctOffset(int n) {
        return this.input instanceof CharStream ? ((CharStream)this.input).correctOffset(n) : n;
    }

    public void reset(Reader reader) throws IOException {
        this.input = reader;
    }
}

