/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.ByteArrayOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.lucene.util.UnicodeUtil;

public class CompressionTools {
    private CompressionTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] byArray, int n, int n2, int n3) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        Deflater deflater = new Deflater();
        try {
            deflater.setLevel(n3);
            deflater.setInput(byArray, n, n2);
            deflater.finish();
            byte[] byArray2 = new byte[1024];
            while (!deflater.finished()) {
                int n4 = deflater.deflate(byArray2);
                byteArrayOutputStream.write(byArray2, 0, n4);
            }
        }
        finally {
            deflater.end();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] compress(byte[] byArray, int n, int n2) {
        return CompressionTools.compress(byArray, n, n2, 9);
    }

    public static byte[] compress(byte[] byArray) {
        return CompressionTools.compress(byArray, 0, byArray.length, 9);
    }

    public static byte[] compressString(String string) {
        return CompressionTools.compressString(string, 9);
    }

    public static byte[] compressString(String string, int n) {
        UnicodeUtil.UTF8Result uTF8Result = new UnicodeUtil.UTF8Result();
        UnicodeUtil.UTF16toUTF8(string, 0, string.length(), uTF8Result);
        return CompressionTools.compress(uTF8Result.result, 0, uTF8Result.length, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] byArray) throws DataFormatException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        Inflater inflater = new Inflater();
        try {
            inflater.setInput(byArray);
            byte[] byArray2 = new byte[1024];
            while (!inflater.finished()) {
                int n = inflater.inflate(byArray2);
                byteArrayOutputStream.write(byArray2, 0, n);
            }
        }
        finally {
            inflater.end();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String decompressString(byte[] byArray) throws DataFormatException {
        UnicodeUtil.UTF16Result uTF16Result = new UnicodeUtil.UTF16Result();
        byte[] byArray2 = CompressionTools.decompress(byArray);
        UnicodeUtil.UTF8toUTF16(byArray2, 0, byArray2.length, uTF16Result);
        return new String(uTF16Result.result, 0, uTF16Result.length);
    }
}

