/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTools {
    static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final ThreadLocal<Calendar> TL_CAL = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance(GMT, Locale.US);
        }
    };
    private static final ThreadLocal<SimpleDateFormat[]> TL_FORMATS = new ThreadLocal<SimpleDateFormat[]>(){

        @Override
        protected SimpleDateFormat[] initialValue() {
            SimpleDateFormat[] simpleDateFormatArray = new SimpleDateFormat[Resolution.MILLISECOND.formatLen + 1];
            for (Resolution resolution : Resolution.values()) {
                simpleDateFormatArray[resolution.formatLen] = (SimpleDateFormat)resolution.format.clone();
            }
            return simpleDateFormatArray;
        }
    };

    private DateTools() {
    }

    public static String dateToString(Date date, Resolution resolution) {
        return DateTools.timeToString(date.getTime(), resolution);
    }

    public static String timeToString(long l, Resolution resolution) {
        Date date = new Date(DateTools.round(l, resolution));
        return TL_FORMATS.get()[resolution.formatLen].format(date);
    }

    public static long stringToTime(String string) throws ParseException {
        return DateTools.stringToDate(string).getTime();
    }

    public static Date stringToDate(String string) throws ParseException {
        try {
            return TL_FORMATS.get()[string.length()].parse(string);
        }
        catch (Exception exception) {
            throw new ParseException("Input is not a valid date string: " + string, 0);
        }
    }

    public static Date round(Date date, Resolution resolution) {
        return new Date(DateTools.round(date.getTime(), resolution));
    }

    public static long round(long l, Resolution resolution) {
        Calendar calendar = TL_CAL.get();
        calendar.setTimeInMillis(l);
        switch (resolution) {
            case YEAR: {
                calendar.set(2, 0);
            }
            case MONTH: {
                calendar.set(5, 1);
            }
            case DAY: {
                calendar.set(11, 0);
            }
            case HOUR: {
                calendar.set(12, 0);
            }
            case MINUTE: {
                calendar.set(13, 0);
            }
            case SECOND: {
                calendar.set(14, 0);
            }
            case MILLISECOND: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown resolution " + (Object)((Object)resolution));
            }
        }
        return calendar.getTimeInMillis();
    }

    public static enum Resolution {
        YEAR(4),
        MONTH(6),
        DAY(8),
        HOUR(10),
        MINUTE(12),
        SECOND(14),
        MILLISECOND(17);

        final int formatLen;
        final SimpleDateFormat format;

        private Resolution(int n2) {
            this.formatLen = n2;
            this.format = new SimpleDateFormat("yyyyMMddHHmmssSSS".substring(0, n2), Locale.US);
            this.format.setTimeZone(GMT);
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

