/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.RamUsageEstimator;

class BufferedDeletes {
    static final int BYTES_PER_DEL_TERM = 8 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 40 + 24;
    static final int BYTES_PER_DEL_DOCID = 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 8 + 4;
    static final int BYTES_PER_DEL_QUERY = 5 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 16 + 8 + 24;
    final AtomicInteger numTermDeletes = new AtomicInteger();
    final Map<Term, Integer> terms = new HashMap<Term, Integer>();
    final Map<Query, Integer> queries = new HashMap<Query, Integer>();
    final List<Integer> docIDs = new ArrayList<Integer>();
    public static final Integer MAX_INT = Integer.MAX_VALUE;
    final AtomicLong bytesUsed = new AtomicLong();
    private static final boolean VERBOSE_DELETES = false;
    long gen;

    BufferedDeletes() {
    }

    public String toString() {
        String string = "gen=" + this.gen;
        if (this.numTermDeletes.get() != 0) {
            string = string + " " + this.numTermDeletes.get() + " deleted terms (unique count=" + this.terms.size() + ")";
        }
        if (this.queries.size() != 0) {
            string = string + " " + this.queries.size() + " deleted queries";
        }
        if (this.docIDs.size() != 0) {
            string = string + " " + this.docIDs.size() + " deleted docIDs";
        }
        if (this.bytesUsed.get() != 0L) {
            string = string + " bytesUsed=" + this.bytesUsed.get();
        }
        return string;
    }

    public void addQuery(Query query, int n) {
        Integer n2 = this.queries.put(query, n);
        if (n2 == null) {
            this.bytesUsed.addAndGet(BYTES_PER_DEL_QUERY);
        }
    }

    public void addDocID(int n) {
        this.docIDs.add(n);
        this.bytesUsed.addAndGet(BYTES_PER_DEL_DOCID);
    }

    public void addTerm(Term term, int n) {
        Integer n2 = this.terms.get(term);
        if (n2 != null && n < n2) {
            return;
        }
        this.terms.put(term, n);
        this.numTermDeletes.incrementAndGet();
        if (n2 == null) {
            this.bytesUsed.addAndGet(BYTES_PER_DEL_TERM + term.text.length() * 2);
        }
    }

    void clear() {
        this.terms.clear();
        this.queries.clear();
        this.docIDs.clear();
        this.numTermDeletes.set(0);
        this.bytesUsed.set(0L);
    }

    void clearDocIDs() {
        this.bytesUsed.addAndGet(-this.docIDs.size() * BYTES_PER_DEL_DOCID);
        this.docIDs.clear();
    }

    boolean any() {
        return this.terms.size() > 0 || this.docIDs.size() > 0 || this.queries.size() > 0;
    }
}

