/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.ThreadInterruptedException;

public class ConcurrentMergeScheduler
extends MergeScheduler {
    private int mergeThreadPriority = -1;
    protected List<MergeThread> mergeThreads = new ArrayList<MergeThread>();
    private int maxThreadCount = Math.max(1, Math.min(3, Runtime.getRuntime().availableProcessors() / 2));
    private int maxMergeCount = this.maxThreadCount + 2;
    protected Directory dir;
    private volatile boolean closed;
    protected IndexWriter writer;
    protected int mergeThreadCount;
    protected static final Comparator<MergeThread> compareByMergeDocCount = new Comparator<MergeThread>(){

        @Override
        public int compare(MergeThread mergeThread, MergeThread mergeThread2) {
            MergePolicy.OneMerge oneMerge = mergeThread.getCurrentMerge();
            MergePolicy.OneMerge oneMerge2 = mergeThread2.getCurrentMerge();
            int n = oneMerge == null ? Integer.MAX_VALUE : oneMerge.totalDocCount;
            int n2 = oneMerge2 == null ? Integer.MAX_VALUE : oneMerge2.totalDocCount;
            return n2 - n;
        }
    };
    static boolean anyExceptions = false;
    private boolean suppressExceptions;
    private static List<ConcurrentMergeScheduler> allInstances;

    public ConcurrentMergeScheduler() {
        if (allInstances != null) {
            this.addMyself();
        }
    }

    public void setMaxThreadCount(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("count should be at least 1");
        }
        if (n > this.maxMergeCount) {
            throw new IllegalArgumentException("count should be <= maxMergeCount (= " + this.maxMergeCount + ")");
        }
        this.maxThreadCount = n;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void setMaxMergeCount(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("count should be at least 1");
        }
        if (n < this.maxThreadCount) {
            throw new IllegalArgumentException("count should be >= maxThreadCount (= " + this.maxThreadCount + ")");
        }
        this.maxMergeCount = n;
    }

    public int getMaxMergeCount() {
        return this.maxMergeCount;
    }

    public synchronized int getMergeThreadPriority() {
        this.initMergeThreadPriority();
        return this.mergeThreadPriority;
    }

    public synchronized void setMergeThreadPriority(int n) {
        if (n > 10 || n < 1) {
            throw new IllegalArgumentException("priority must be in range 1 .. 10 inclusive");
        }
        this.mergeThreadPriority = n;
        this.updateMergeThreads();
    }

    protected synchronized void updateMergeThreads() {
        ArrayList<MergeThread> arrayList = new ArrayList<MergeThread>();
        int n = 0;
        while (n < this.mergeThreads.size()) {
            MergeThread mergeThread = this.mergeThreads.get(n);
            if (!mergeThread.isAlive()) {
                this.mergeThreads.remove(n);
                continue;
            }
            if (mergeThread.getCurrentMerge() != null) {
                arrayList.add(mergeThread);
            }
            ++n;
        }
        CollectionUtil.mergeSort(arrayList, compareByMergeDocCount);
        int n2 = this.mergeThreadPriority;
        int n3 = arrayList.size();
        for (n = 0; n < n3; ++n) {
            boolean bl;
            MergeThread mergeThread = (MergeThread)arrayList.get(n);
            MergePolicy.OneMerge oneMerge = mergeThread.getCurrentMerge();
            if (oneMerge == null) continue;
            boolean bl2 = bl = n < n3 - this.maxThreadCount;
            if (this.verbose() && bl != oneMerge.getPause()) {
                if (bl) {
                    this.message("pause thread " + mergeThread.getName());
                } else {
                    this.message("unpause thread " + mergeThread.getName());
                }
            }
            if (bl != oneMerge.getPause()) {
                oneMerge.setPause(bl);
            }
            if (bl) continue;
            if (this.verbose()) {
                this.message("set priority of merge thread " + mergeThread.getName() + " to " + n2);
            }
            mergeThread.setThreadPriority(n2);
            n2 = Math.min(10, 1 + n2);
        }
    }

    protected boolean verbose() {
        return this.writer != null && this.writer.verbose();
    }

    protected void message(String string) {
        this.writer.message("CMS: " + string);
    }

    private synchronized void initMergeThreadPriority() {
        if (this.mergeThreadPriority == -1) {
            this.mergeThreadPriority = 1 + Thread.currentThread().getPriority();
            if (this.mergeThreadPriority > 10) {
                this.mergeThreadPriority = 10;
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        while (true) {
            Thread thread = null;
            ConcurrentMergeScheduler concurrentMergeScheduler = this;
            synchronized (concurrentMergeScheduler) {
                for (MergeThread mergeThread : this.mergeThreads) {
                    if (!mergeThread.isAlive()) continue;
                    thread = mergeThread;
                    break;
                }
            }
            if (thread == null) break;
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                throw new ThreadInterruptedException(interruptedException);
            }
        }
    }

    protected synchronized int mergeThreadCount() {
        int n = 0;
        for (MergeThread mergeThread : this.mergeThreads) {
            if (!mergeThread.isAlive() || mergeThread.getCurrentMerge() == null) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(IndexWriter indexWriter) throws IOException {
        assert (!Thread.holdsLock(indexWriter));
        this.writer = indexWriter;
        this.initMergeThreadPriority();
        this.dir = indexWriter.getDirectory();
        if (this.verbose()) {
            this.message("now merge");
            this.message("  index: " + indexWriter.segString());
        }
        while (true) {
            Object object = this;
            synchronized (object) {
                long l = 0L;
                while (this.mergeThreadCount() >= 1 + this.maxMergeCount) {
                    l = System.currentTimeMillis();
                    if (this.verbose()) {
                        this.message("    too many merges; stalling...");
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new ThreadInterruptedException(interruptedException);
                    }
                }
                if (this.verbose() && l != 0L) {
                    this.message("  stalled for " + (System.currentTimeMillis() - l) + " msec");
                }
            }
            object = indexWriter.getNextMerge();
            if (object == null) {
                if (this.verbose()) {
                    this.message("  no more merges pending; now return");
                }
                return;
            }
            indexWriter.mergeInit((MergePolicy.OneMerge)object);
            boolean bl = false;
            try {
                ConcurrentMergeScheduler concurrentMergeScheduler = this;
                synchronized (concurrentMergeScheduler) {
                    this.message("  consider merge " + ((MergePolicy.OneMerge)object).segString(this.dir));
                    MergeThread mergeThread = this.getMergeThread(indexWriter, (MergePolicy.OneMerge)object);
                    this.mergeThreads.add(mergeThread);
                    if (this.verbose()) {
                        this.message("    launch new thread [" + mergeThread.getName() + "]");
                    }
                    mergeThread.start();
                    this.updateMergeThreads();
                    bl = true;
                    continue;
                }
            }
            finally {
                if (bl) continue;
                indexWriter.mergeFinish((MergePolicy.OneMerge)object);
                continue;
            }
            break;
        }
    }

    protected void doMerge(MergePolicy.OneMerge oneMerge) throws IOException {
        this.writer.merge(oneMerge);
    }

    protected synchronized MergeThread getMergeThread(IndexWriter indexWriter, MergePolicy.OneMerge oneMerge) throws IOException {
        MergeThread mergeThread = new MergeThread(indexWriter, oneMerge);
        mergeThread.setThreadPriority(this.mergeThreadPriority);
        mergeThread.setDaemon(true);
        mergeThread.setName("Lucene Merge Thread #" + this.mergeThreadCount++);
        return mergeThread;
    }

    protected void handleMergeException(Throwable throwable) {
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException(interruptedException);
        }
        throw new MergePolicy.MergeException(throwable, this.dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean anyUnhandledExceptions() {
        if (allInstances == null) {
            throw new RuntimeException("setTestMode() was not called; often this is because your test case's setUp method fails to call super.setUp in LuceneTestCase");
        }
        List<ConcurrentMergeScheduler> list = allInstances;
        synchronized (list) {
            int n;
            int n2 = allInstances.size();
            for (n = 0; n < n2; n += 1) {
                allInstances.get(n).sync();
            }
            n = anyExceptions ? 1 : 0;
            anyExceptions = false;
            return n != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearUnhandledExceptions() {
        List<ConcurrentMergeScheduler> list = allInstances;
        synchronized (list) {
            anyExceptions = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMyself() {
        List<ConcurrentMergeScheduler> list = allInstances;
        synchronized (list) {
            int n = allInstances.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                ConcurrentMergeScheduler concurrentMergeScheduler = allInstances.get(i);
                if (concurrentMergeScheduler.closed && 0 == concurrentMergeScheduler.mergeThreadCount()) continue;
                allInstances.set(n2++, concurrentMergeScheduler);
            }
            allInstances.subList(n2, allInstances.size()).clear();
            allInstances.add(this);
        }
    }

    void setSuppressExceptions() {
        this.suppressExceptions = true;
    }

    void clearSuppressExceptions() {
        this.suppressExceptions = false;
    }

    @Deprecated
    public static void setTestMode() {
        allInstances = new ArrayList<ConcurrentMergeScheduler>();
    }

    protected class MergeThread
    extends Thread {
        IndexWriter tWriter;
        MergePolicy.OneMerge startMerge;
        MergePolicy.OneMerge runningMerge;
        private volatile boolean done;

        public MergeThread(IndexWriter indexWriter, MergePolicy.OneMerge oneMerge) throws IOException {
            this.tWriter = indexWriter;
            this.startMerge = oneMerge;
        }

        public synchronized void setRunningMerge(MergePolicy.OneMerge oneMerge) {
            this.runningMerge = oneMerge;
        }

        public synchronized MergePolicy.OneMerge getRunningMerge() {
            return this.runningMerge;
        }

        public synchronized MergePolicy.OneMerge getCurrentMerge() {
            if (this.done) {
                return null;
            }
            if (this.runningMerge != null) {
                return this.runningMerge;
            }
            return this.startMerge;
        }

        public void setThreadPriority(int n) {
            try {
                this.setPriority(n);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MergePolicy.OneMerge oneMerge = this.startMerge;
            try {
                if (ConcurrentMergeScheduler.this.verbose()) {
                    ConcurrentMergeScheduler.this.message("  merge thread: start");
                }
                while (true) {
                    this.setRunningMerge(oneMerge);
                    ConcurrentMergeScheduler.this.doMerge(oneMerge);
                    oneMerge = this.tWriter.getNextMerge();
                    if (oneMerge == null) break;
                    this.tWriter.mergeInit(oneMerge);
                    ConcurrentMergeScheduler.this.updateMergeThreads();
                    if (!ConcurrentMergeScheduler.this.verbose()) continue;
                    ConcurrentMergeScheduler.this.message("  merge thread: do another merge " + oneMerge.segString(ConcurrentMergeScheduler.this.dir));
                }
                if (ConcurrentMergeScheduler.this.verbose()) {
                    ConcurrentMergeScheduler.this.message("  merge thread: done");
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof MergePolicy.MergeAbortedException) && !ConcurrentMergeScheduler.this.suppressExceptions) {
                    anyExceptions = true;
                    ConcurrentMergeScheduler.this.handleMergeException(throwable);
                }
            }
            finally {
                this.done = true;
                ConcurrentMergeScheduler concurrentMergeScheduler = ConcurrentMergeScheduler.this;
                synchronized (concurrentMergeScheduler) {
                    ConcurrentMergeScheduler.this.updateMergeThreads();
                    ConcurrentMergeScheduler.this.notifyAll();
                }
            }
        }

        @Override
        public String toString() {
            MergePolicy.OneMerge oneMerge = this.getRunningMerge();
            if (oneMerge == null) {
                oneMerge = this.startMerge;
            }
            return "merge thread: " + oneMerge.segString(ConcurrentMergeScheduler.this.dir);
        }
    }
}

