/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.IOUtils;

final class FieldsWriter {
    static final int FIELD_IS_TOKENIZED = 1;
    static final int FIELD_IS_BINARY = 2;
    @Deprecated
    static final int FIELD_IS_COMPRESSED = 4;
    private static final int _NUMERIC_BIT_SHIFT = 3;
    static final int FIELD_IS_NUMERIC_MASK = 56;
    static final int FIELD_IS_NUMERIC_INT = 8;
    static final int FIELD_IS_NUMERIC_LONG = 16;
    static final int FIELD_IS_NUMERIC_FLOAT = 24;
    static final int FIELD_IS_NUMERIC_DOUBLE = 32;
    static final int FORMAT = 0;
    static final int FORMAT_VERSION_UTF8_LENGTH_IN_BYTES = 1;
    static final int FORMAT_LUCENE_3_0_NO_COMPRESSED_FIELDS = 2;
    static final int FORMAT_LUCENE_3_2_NUMERIC_FIELDS = 3;
    static final int FORMAT_CURRENT = 3;
    private FieldInfos fieldInfos;
    private Directory directory;
    private String segment;
    private IndexOutput fieldsStream;
    private IndexOutput indexStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldsWriter(Directory directory, String string, FieldInfos fieldInfos) throws IOException {
        this.directory = directory;
        this.segment = string;
        this.fieldInfos = fieldInfos;
        boolean bl = false;
        try {
            this.fieldsStream = directory.createOutput(IndexFileNames.segmentFileName(string, "fdt"));
            this.indexStream = directory.createOutput(IndexFileNames.segmentFileName(string, "fdx"));
            this.fieldsStream.writeInt(3);
            this.indexStream.writeInt(3);
            bl = true;
        }
        finally {
            if (!bl) {
                this.abort();
            }
        }
    }

    FieldsWriter(IndexOutput indexOutput, IndexOutput indexOutput2, FieldInfos fieldInfos) {
        this.directory = null;
        this.segment = null;
        this.fieldInfos = fieldInfos;
        this.fieldsStream = indexOutput2;
        this.indexStream = indexOutput;
    }

    void setFieldsStream(IndexOutput indexOutput) {
        this.fieldsStream = indexOutput;
    }

    void flushDocument(int n, RAMOutputStream rAMOutputStream) throws IOException {
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        this.fieldsStream.writeVInt(n);
        rAMOutputStream.writeTo(this.fieldsStream);
    }

    void skipDocument() throws IOException {
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        this.fieldsStream.writeVInt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        if (this.directory != null) {
            try {
                IOUtils.close(this.fieldsStream, this.indexStream);
            }
            finally {
                this.indexStream = null;
                this.fieldsStream = null;
            }
        }
    }

    void abort() {
        if (this.directory != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.directory.deleteFile(IndexFileNames.segmentFileName(this.segment, "fdt"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.directory.deleteFile(IndexFileNames.segmentFileName(this.segment, "fdx"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    final void writeField(FieldInfo fieldInfo, Fieldable fieldable) throws IOException {
        this.fieldsStream.writeVInt(fieldInfo.number);
        int n = 0;
        if (fieldable.isTokenized()) {
            n |= 1;
        }
        if (fieldable.isBinary()) {
            n |= 2;
        }
        if (fieldable instanceof NumericField) {
            switch (((NumericField)fieldable).getDataType()) {
                case INT: {
                    n |= 8;
                    break;
                }
                case LONG: {
                    n |= 0x10;
                    break;
                }
                case FLOAT: {
                    n |= 0x18;
                    break;
                }
                case DOUBLE: {
                    n |= 0x20;
                    break;
                }
                default: {
                    assert (false) : "Should never get here";
                    break;
                }
            }
        }
        this.fieldsStream.writeByte((byte)n);
        if (fieldable.isBinary()) {
            byte[] byArray = fieldable.getBinaryValue();
            int n2 = fieldable.getBinaryLength();
            int n3 = fieldable.getBinaryOffset();
            this.fieldsStream.writeVInt(n2);
            this.fieldsStream.writeBytes(byArray, n3, n2);
        } else if (fieldable instanceof NumericField) {
            NumericField numericField = (NumericField)fieldable;
            Number number = numericField.getNumericValue();
            switch (numericField.getDataType()) {
                case INT: {
                    this.fieldsStream.writeInt(number.intValue());
                    break;
                }
                case LONG: {
                    this.fieldsStream.writeLong(number.longValue());
                    break;
                }
                case FLOAT: {
                    this.fieldsStream.writeInt(Float.floatToIntBits(number.floatValue()));
                    break;
                }
                case DOUBLE: {
                    this.fieldsStream.writeLong(Double.doubleToLongBits(number.doubleValue()));
                    break;
                }
                default: {
                    assert (false) : "Should never get here";
                    {
                        break;
                    }
                }
            }
        } else {
            this.fieldsStream.writeString(fieldable.stringValue());
        }
    }

    final void addRawDocuments(IndexInput indexInput, int[] nArray, int n) throws IOException {
        long l;
        long l2 = l = this.fieldsStream.getFilePointer();
        for (int i = 0; i < n; ++i) {
            this.indexStream.writeLong(l);
            l += (long)nArray[i];
        }
        this.fieldsStream.copyBytes(indexInput, l - l2);
        assert (this.fieldsStream.getFilePointer() == l);
    }

    final void addDocument(Document document) throws IOException {
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        int n = 0;
        List<Fieldable> list = document.getFields();
        for (Fieldable fieldable : list) {
            if (!fieldable.isStored()) continue;
            ++n;
        }
        this.fieldsStream.writeVInt(n);
        for (Fieldable fieldable : list) {
            if (!fieldable.isStored()) continue;
            this.writeField(this.fieldInfos.fieldInfo(fieldable.name()), fieldable);
        }
    }
}

