/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FormatPostingsDocsWriter;
import org.apache.lucene.index.FormatPostingsPositionsConsumer;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

final class FormatPostingsPositionsWriter
extends FormatPostingsPositionsConsumer
implements Closeable {
    final FormatPostingsDocsWriter parent;
    final IndexOutput out;
    boolean omitTermFreqAndPositions;
    boolean storePayloads;
    int lastPayloadLength = -1;
    int lastPosition;

    FormatPostingsPositionsWriter(SegmentWriteState segmentWriteState, FormatPostingsDocsWriter formatPostingsDocsWriter) throws IOException {
        this.parent = formatPostingsDocsWriter;
        this.omitTermFreqAndPositions = formatPostingsDocsWriter.omitTermFreqAndPositions;
        if (formatPostingsDocsWriter.parent.parent.fieldInfos.hasProx()) {
            this.out = formatPostingsDocsWriter.parent.parent.dir.createOutput(IndexFileNames.segmentFileName(formatPostingsDocsWriter.parent.parent.segment, "prx"));
            formatPostingsDocsWriter.skipListWriter.setProxOutput(this.out);
        } else {
            this.out = null;
        }
    }

    @Override
    void addPosition(int n, byte[] byArray, int n2, int n3) throws IOException {
        assert (!this.omitTermFreqAndPositions) : "omitTermFreqAndPositions is true";
        assert (this.out != null);
        int n4 = n - this.lastPosition;
        this.lastPosition = n;
        if (this.storePayloads) {
            if (n3 != this.lastPayloadLength) {
                this.lastPayloadLength = n3;
                this.out.writeVInt(n4 << 1 | 1);
                this.out.writeVInt(n3);
            } else {
                this.out.writeVInt(n4 << 1);
            }
            if (n3 > 0) {
                this.out.writeBytes(byArray, n3);
            }
        } else {
            this.out.writeVInt(n4);
        }
    }

    void setField(FieldInfo fieldInfo) {
        this.omitTermFreqAndPositions = fieldInfo.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY;
        this.storePayloads = this.omitTermFreqAndPositions ? false : fieldInfo.storePayloads;
    }

    @Override
    void finish() {
        this.lastPosition = 0;
        this.lastPayloadLength = -1;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.out);
    }
}

