/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.StaleReaderException;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.VirtualMethod;

public abstract class IndexReader
implements Cloneable,
Closeable {
    protected volatile Collection<ReaderFinishedListener> readerFinishedListeners;
    private volatile boolean closed;
    protected boolean hasChanges;
    private final AtomicInteger refCount = new AtomicInteger();
    static int DEFAULT_TERMS_INDEX_DIVISOR = 1;
    @Deprecated
    private static final VirtualMethod<IndexReader> reopenMethod1 = new VirtualMethod<IndexReader>(IndexReader.class, "reopen", new Class[0]);
    @Deprecated
    private static final VirtualMethod<IndexReader> doOpenIfChangedMethod1 = new VirtualMethod<IndexReader>(IndexReader.class, "doOpenIfChanged", new Class[0]);
    @Deprecated
    private final boolean hasNewReopenAPI1 = VirtualMethod.compareImplementationDistance(this.getClass(), doOpenIfChangedMethod1, reopenMethod1) >= 0;
    @Deprecated
    private static final VirtualMethod<IndexReader> reopenMethod2 = new VirtualMethod<IndexReader>(IndexReader.class, "reopen", Boolean.TYPE);
    @Deprecated
    private static final VirtualMethod<IndexReader> doOpenIfChangedMethod2 = new VirtualMethod<IndexReader>(IndexReader.class, "doOpenIfChanged", Boolean.TYPE);
    @Deprecated
    private final boolean hasNewReopenAPI2 = VirtualMethod.compareImplementationDistance(this.getClass(), doOpenIfChangedMethod2, reopenMethod2) >= 0;
    @Deprecated
    private static final VirtualMethod<IndexReader> reopenMethod3 = new VirtualMethod<IndexReader>(IndexReader.class, "reopen", IndexCommit.class);
    @Deprecated
    private static final VirtualMethod<IndexReader> doOpenIfChangedMethod3 = new VirtualMethod<IndexReader>(IndexReader.class, "doOpenIfChanged", IndexCommit.class);
    @Deprecated
    private final boolean hasNewReopenAPI3 = VirtualMethod.compareImplementationDistance(this.getClass(), doOpenIfChangedMethod3, reopenMethod3) >= 0;
    @Deprecated
    private static final VirtualMethod<IndexReader> reopenMethod4 = new VirtualMethod<IndexReader>(IndexReader.class, "reopen", IndexWriter.class, Boolean.TYPE);
    @Deprecated
    private static final VirtualMethod<IndexReader> doOpenIfChangedMethod4 = new VirtualMethod<IndexReader>(IndexReader.class, "doOpenIfChanged", IndexWriter.class, Boolean.TYPE);
    @Deprecated
    private final boolean hasNewReopenAPI4 = VirtualMethod.compareImplementationDistance(this.getClass(), doOpenIfChangedMethod4, reopenMethod4) >= 0;

    public void addReaderFinishedListener(ReaderFinishedListener readerFinishedListener) {
        this.ensureOpen();
        this.readerFinishedListeners.add(readerFinishedListener);
    }

    public void removeReaderFinishedListener(ReaderFinishedListener readerFinishedListener) {
        this.ensureOpen();
        this.readerFinishedListeners.remove(readerFinishedListener);
    }

    protected void notifyReaderFinishedListeners() {
        if (this.readerFinishedListeners != null) {
            for (ReaderFinishedListener readerFinishedListener : this.readerFinishedListeners) {
                readerFinishedListener.finished(this);
            }
        }
    }

    protected void readerFinished() {
        this.notifyReaderFinishedListeners();
    }

    public int getRefCount() {
        return this.refCount.get();
    }

    public void incRef() {
        this.ensureOpen();
        this.refCount.incrementAndGet();
    }

    public boolean tryIncRef() {
        int n;
        while ((n = this.refCount.get()) > 0) {
            if (!this.refCount.compareAndSet(n, n + 1)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasChanges) {
            stringBuilder.append('*');
        }
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('(');
        IndexReader[] indexReaderArray = this.getSequentialSubReaders();
        if (indexReaderArray != null && indexReaderArray.length > 0) {
            stringBuilder.append(indexReaderArray[0]);
            for (int i = 1; i < indexReaderArray.length; ++i) {
                stringBuilder.append(" ").append(indexReaderArray[i]);
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decRef() throws IOException {
        this.ensureOpen();
        int n = this.refCount.getAndDecrement();
        if (n == 1) {
            boolean bl = false;
            try {
                this.commit();
                this.doClose();
                bl = true;
            }
            finally {
                if (!bl) {
                    this.refCount.incrementAndGet();
                }
            }
            this.readerFinished();
        } else if (n <= 0) {
            throw new IllegalStateException("too many decRef calls: refCount was " + n + " before decrement");
        }
    }

    protected IndexReader() {
        this.refCount.set(1);
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.refCount.get() <= 0) {
            throw new AlreadyClosedException("this IndexReader is closed");
        }
    }

    public static IndexReader open(Directory directory) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, null, null, true, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(Directory directory, boolean bl) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, null, null, bl, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(IndexWriter indexWriter, boolean bl) throws CorruptIndexException, IOException {
        return indexWriter.getReader(bl);
    }

    public static IndexReader open(IndexCommit indexCommit, boolean bl) throws CorruptIndexException, IOException {
        return IndexReader.open(indexCommit.getDirectory(), null, indexCommit, bl, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(Directory directory, IndexDeletionPolicy indexDeletionPolicy, boolean bl) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, indexDeletionPolicy, null, bl, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(Directory directory, IndexDeletionPolicy indexDeletionPolicy, boolean bl, int n) throws CorruptIndexException, IOException {
        return IndexReader.open(directory, indexDeletionPolicy, null, bl, n);
    }

    public static IndexReader open(IndexCommit indexCommit, IndexDeletionPolicy indexDeletionPolicy, boolean bl) throws CorruptIndexException, IOException {
        return IndexReader.open(indexCommit.getDirectory(), indexDeletionPolicy, indexCommit, bl, DEFAULT_TERMS_INDEX_DIVISOR);
    }

    public static IndexReader open(IndexCommit indexCommit, IndexDeletionPolicy indexDeletionPolicy, boolean bl, int n) throws CorruptIndexException, IOException {
        return IndexReader.open(indexCommit.getDirectory(), indexDeletionPolicy, indexCommit, bl, n);
    }

    private static IndexReader open(Directory directory, IndexDeletionPolicy indexDeletionPolicy, IndexCommit indexCommit, boolean bl, int n) throws CorruptIndexException, IOException {
        return DirectoryReader.open(directory, indexDeletionPolicy, indexCommit, bl, n);
    }

    public static IndexReader openIfChanged(IndexReader indexReader) throws IOException {
        if (indexReader.hasNewReopenAPI1) {
            IndexReader indexReader2 = indexReader.doOpenIfChanged();
            assert (indexReader2 != indexReader);
            return indexReader2;
        }
        IndexReader indexReader3 = indexReader.reopen();
        if (indexReader3 == indexReader) {
            return null;
        }
        return indexReader3;
    }

    public static IndexReader openIfChanged(IndexReader indexReader, boolean bl) throws IOException {
        if (indexReader.hasNewReopenAPI2) {
            IndexReader indexReader2 = indexReader.doOpenIfChanged(bl);
            assert (indexReader2 != indexReader);
            return indexReader2;
        }
        IndexReader indexReader3 = indexReader.reopen(bl);
        if (indexReader3 == indexReader) {
            return null;
        }
        return indexReader3;
    }

    public static IndexReader openIfChanged(IndexReader indexReader, IndexCommit indexCommit) throws IOException {
        if (indexReader.hasNewReopenAPI3) {
            IndexReader indexReader2 = indexReader.doOpenIfChanged(indexCommit);
            assert (indexReader2 != indexReader);
            return indexReader2;
        }
        IndexReader indexReader3 = indexReader.reopen(indexCommit);
        if (indexReader3 == indexReader) {
            return null;
        }
        return indexReader3;
    }

    public static IndexReader openIfChanged(IndexReader indexReader, IndexWriter indexWriter, boolean bl) throws IOException {
        if (indexReader.hasNewReopenAPI4) {
            IndexReader indexReader2 = indexReader.doOpenIfChanged(indexWriter, bl);
            assert (indexReader2 != indexReader);
            return indexReader2;
        }
        IndexReader indexReader3 = indexReader.reopen(indexWriter, bl);
        if (indexReader3 == indexReader) {
            return null;
        }
        return indexReader3;
    }

    @Deprecated
    public IndexReader reopen() throws CorruptIndexException, IOException {
        IndexReader indexReader = IndexReader.openIfChanged(this);
        if (indexReader == null) {
            return this;
        }
        return indexReader;
    }

    @Deprecated
    public IndexReader reopen(boolean bl) throws CorruptIndexException, IOException {
        IndexReader indexReader = IndexReader.openIfChanged(this, bl);
        if (indexReader == null) {
            return this;
        }
        return indexReader;
    }

    @Deprecated
    public IndexReader reopen(IndexCommit indexCommit) throws CorruptIndexException, IOException {
        IndexReader indexReader = IndexReader.openIfChanged(this, indexCommit);
        if (indexReader == null) {
            return this;
        }
        return indexReader;
    }

    @Deprecated
    public IndexReader reopen(IndexWriter indexWriter, boolean bl) throws CorruptIndexException, IOException {
        IndexReader indexReader = IndexReader.openIfChanged(this, indexWriter, bl);
        if (indexReader == null) {
            return this;
        }
        return indexReader;
    }

    protected IndexReader doOpenIfChanged() throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support reopen().");
    }

    protected IndexReader doOpenIfChanged(boolean bl) throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support reopen().");
    }

    protected IndexReader doOpenIfChanged(IndexCommit indexCommit) throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support reopen(IndexCommit).");
    }

    protected IndexReader doOpenIfChanged(IndexWriter indexWriter, boolean bl) throws CorruptIndexException, IOException {
        return indexWriter.getReader(bl);
    }

    public synchronized Object clone() {
        throw new UnsupportedOperationException("This reader does not implement clone()");
    }

    public synchronized IndexReader clone(boolean bl) throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not implement clone()");
    }

    public Directory directory() {
        this.ensureOpen();
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public static long lastModified(final Directory directory) throws CorruptIndexException, IOException {
        return (Long)new SegmentInfos.FindSegmentsFile(directory){

            @Override
            public Object doBody(String string) throws IOException {
                return directory.fileModified(string);
            }
        }.run();
    }

    public static long getCurrentVersion(Directory directory) throws CorruptIndexException, IOException {
        return SegmentInfos.readCurrentVersion(directory);
    }

    public static Map<String, String> getCommitUserData(Directory directory) throws CorruptIndexException, IOException {
        return SegmentInfos.readCurrentUserData(directory);
    }

    public long getVersion() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public Map<String, String> getCommitUserData() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public boolean isCurrent() throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    @Deprecated
    public boolean isOptimized() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public abstract TermFreqVector[] getTermFreqVectors(int var1) throws IOException;

    public abstract TermFreqVector getTermFreqVector(int var1, String var2) throws IOException;

    public abstract void getTermFreqVector(int var1, String var2, TermVectorMapper var3) throws IOException;

    public abstract void getTermFreqVector(int var1, TermVectorMapper var2) throws IOException;

    public static boolean indexExists(Directory directory) throws IOException {
        try {
            new SegmentInfos().read(directory);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public abstract int numDocs();

    public abstract int maxDoc();

    public int numDeletedDocs() {
        return this.maxDoc() - this.numDocs();
    }

    public Document document(int n) throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (n < 0 || n >= this.maxDoc()) {
            throw new IllegalArgumentException("docID must be >= 0 and < maxDoc=" + this.maxDoc() + " (got docID=" + n + ")");
        }
        return this.document(n, null);
    }

    public abstract Document document(int var1, FieldSelector var2) throws CorruptIndexException, IOException;

    public abstract boolean isDeleted(int var1);

    public abstract boolean hasDeletions();

    public boolean hasNorms(String string) throws IOException {
        this.ensureOpen();
        return this.norms(string) != null;
    }

    public abstract byte[] norms(String var1) throws IOException;

    public abstract void norms(String var1, byte[] var2, int var3) throws IOException;

    public synchronized void setNorm(int n, String string, byte by) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.acquireWriteLock();
        this.hasChanges = true;
        this.doSetNorm(n, string, by);
    }

    protected abstract void doSetNorm(int var1, String var2, byte var3) throws CorruptIndexException, IOException;

    @Deprecated
    public void setNorm(int n, String string, float f) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.setNorm(n, string, Similarity.getDefault().encodeNormValue(f));
    }

    public abstract TermEnum terms() throws IOException;

    public abstract TermEnum terms(Term var1) throws IOException;

    public abstract int docFreq(Term var1) throws IOException;

    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        TermDocs termDocs = this.termDocs();
        termDocs.seek(term);
        return termDocs;
    }

    public abstract TermDocs termDocs() throws IOException;

    public TermPositions termPositions(Term term) throws IOException {
        this.ensureOpen();
        TermPositions termPositions = this.termPositions();
        termPositions.seek(term);
        return termPositions;
    }

    public abstract TermPositions termPositions() throws IOException;

    public synchronized void deleteDocument(int n) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.acquireWriteLock();
        this.hasChanges = true;
        this.doDelete(n);
    }

    protected abstract void doDelete(int var1) throws CorruptIndexException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteDocuments(Term term) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        TermDocs termDocs = this.termDocs(term);
        if (termDocs == null) {
            return 0;
        }
        int n = 0;
        try {
            while (termDocs.next()) {
                this.deleteDocument(termDocs.doc());
                ++n;
            }
        }
        finally {
            termDocs.close();
        }
        return n;
    }

    public synchronized void undeleteAll() throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        this.ensureOpen();
        this.acquireWriteLock();
        this.hasChanges = true;
        this.doUndeleteAll();
    }

    protected abstract void doUndeleteAll() throws CorruptIndexException, IOException;

    protected synchronized void acquireWriteLock() throws IOException {
    }

    public final synchronized void flush() throws IOException {
        this.ensureOpen();
        this.commit();
    }

    public final synchronized void flush(Map<String, String> map) throws IOException {
        this.ensureOpen();
        this.commit(map);
    }

    protected final synchronized void commit() throws IOException {
        this.commit(null);
    }

    public final synchronized void commit(Map<String, String> map) throws IOException {
        this.doCommit(map);
        this.hasChanges = false;
    }

    protected abstract void doCommit(Map<String, String> var1) throws IOException;

    @Override
    public final synchronized void close() throws IOException {
        if (!this.closed) {
            this.decRef();
            this.closed = true;
        }
    }

    protected abstract void doClose() throws IOException;

    public abstract Collection<String> getFieldNames(FieldOption var1);

    public IndexCommit getIndexCommit() throws IOException {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string = null;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-extract")) {
                bl = true;
                continue;
            }
            if (string != null) continue;
            string = stringArray[i];
        }
        if (string == null) {
            System.out.println("Usage: org.apache.lucene.index.IndexReader [-extract] <cfsfile>");
            return;
        }
        Directory directory = null;
        CompoundFileReader compoundFileReader = null;
        try {
            File file = new File(string);
            String string2 = file.getAbsoluteFile().getParent();
            string = file.getName();
            directory = FSDirectory.open(new File(string2));
            compoundFileReader = new CompoundFileReader(directory, string);
            String[] stringArray2 = compoundFileReader.listAll();
            ArrayUtil.mergeSort((Comparable[])stringArray2);
            for (int i = 0; i < stringArray2.length; ++i) {
                long l;
                if (bl) {
                    int n;
                    System.out.println("extract " + stringArray2[i] + " with " + l + " bytes to local directory...");
                    IndexInput indexInput = compoundFileReader.openInput(stringArray2[i]);
                    FileOutputStream fileOutputStream = new FileOutputStream(stringArray2[i]);
                    byte[] byArray = new byte[1024];
                    int n2 = byArray.length;
                    for (l = compoundFileReader.fileLength(stringArray2[i]); l > 0L; l -= (long)n) {
                        n = (int)Math.min((long)n2, l);
                        indexInput.readBytes(byArray, 0, n);
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.close();
                    indexInput.close();
                    continue;
                }
                System.out.println(stringArray2[i] + ": " + l + " bytes");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (directory != null) {
                    directory.close();
                }
                if (compoundFileReader != null) {
                    compoundFileReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static Collection<IndexCommit> listCommits(Directory directory) throws IOException {
        return DirectoryReader.listCommits(directory);
    }

    public IndexReader[] getSequentialSubReaders() {
        this.ensureOpen();
        return null;
    }

    public Object getCoreCacheKey() {
        return this;
    }

    public Object getDeletesCacheKey() {
        return this;
    }

    public long getUniqueTermCount() throws IOException {
        throw new UnsupportedOperationException("this reader does not implement getUniqueTermCount()");
    }

    public int getTermInfosIndexDivisor() {
        throw new UnsupportedOperationException("This reader does not support this method.");
    }

    public static enum FieldOption {
        ALL,
        INDEXED,
        STORES_PAYLOADS,
        OMIT_TERM_FREQ_AND_POSITIONS,
        OMIT_POSITIONS,
        UNINDEXED,
        INDEXED_WITH_TERMVECTOR,
        INDEXED_NO_TERMVECTOR,
        TERMVECTOR,
        TERMVECTOR_WITH_POSITION,
        TERMVECTOR_WITH_OFFSET,
        TERMVECTOR_WITH_POSITION_OFFSET;

    }

    public static interface ReaderFinishedListener {
        public void finished(IndexReader var1);
    }
}

