/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.BufferedDeletesStream;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.PayloadProcessorProvider;
import org.apache.lucene.index.ReadOnlyDirectoryReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.MapBackedSet;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.ThreadInterruptedException;
import org.apache.lucene.util.TwoPhaseCommit;
import org.apache.lucene.util.Version;

public class IndexWriter
implements Closeable,
TwoPhaseCommit {
    @Deprecated
    public static long WRITE_LOCK_TIMEOUT = IndexWriterConfig.WRITE_LOCK_TIMEOUT;
    private long writeLockTimeout;
    public static final String WRITE_LOCK_NAME = "write.lock";
    @Deprecated
    public static final int DISABLE_AUTO_FLUSH = -1;
    @Deprecated
    public static final int DEFAULT_MAX_BUFFERED_DOCS = -1;
    @Deprecated
    public static final double DEFAULT_RAM_BUFFER_SIZE_MB = 16.0;
    @Deprecated
    public static final int DEFAULT_MAX_BUFFERED_DELETE_TERMS = -1;
    @Deprecated
    public static final int DEFAULT_MAX_FIELD_LENGTH = MaxFieldLength.UNLIMITED.getLimit();
    @Deprecated
    public static final int DEFAULT_TERM_INDEX_INTERVAL = 128;
    public static final int MAX_TERM_LENGTH = 16383;
    private static final int MERGE_READ_BUFFER_SIZE = 4096;
    private static final AtomicInteger MESSAGE_ID = new AtomicInteger();
    private int messageID = MESSAGE_ID.getAndIncrement();
    private volatile boolean hitOOM;
    private final Directory directory;
    private final Analyzer analyzer;
    private Similarity similarity = Similarity.getDefault();
    private volatile long changeCount;
    private long lastCommitChangeCount;
    private List<SegmentInfo> rollbackSegments;
    volatile SegmentInfos pendingCommit;
    volatile long pendingCommitChangeCount;
    final SegmentInfos segmentInfos = new SegmentInfos();
    private DocumentsWriter docWriter;
    private IndexFileDeleter deleter;
    private Map<SegmentInfo, Boolean> segmentsToMerge = new HashMap<SegmentInfo, Boolean>();
    private int mergeMaxNumSegments;
    private Lock writeLock;
    private volatile boolean closed;
    private volatile boolean closing;
    private HashSet<SegmentInfo> mergingSegments = new HashSet();
    private MergePolicy mergePolicy;
    private MergeScheduler mergeScheduler;
    private LinkedList<MergePolicy.OneMerge> pendingMerges = new LinkedList();
    private Set<MergePolicy.OneMerge> runningMerges = new HashSet<MergePolicy.OneMerge>();
    private List<MergePolicy.OneMerge> mergeExceptions = new ArrayList<MergePolicy.OneMerge>();
    private long mergeGen;
    private boolean stopMerges;
    private final AtomicInteger flushCount = new AtomicInteger();
    private final AtomicInteger flushDeletesCount = new AtomicInteger();
    final ReaderPool readerPool = new ReaderPool();
    final BufferedDeletesStream bufferedDeletesStream;
    private volatile boolean poolReaders;
    private final IndexWriterConfig config;
    private PayloadProcessorProvider payloadProcessorProvider;
    boolean anyNonBulkMerges;
    private final Collection<IndexReader.ReaderFinishedListener> readerFinishedListeners = new MapBackedSet(new ConcurrentHashMap());
    @Deprecated
    private int maxFieldLength = DEFAULT_MAX_FIELD_LENGTH;
    private PrintStream infoStream;
    private static PrintStream defaultInfoStream;
    private final Object commitLock = new Object();
    private boolean keepFullyDeletedSegments;
    final FlushControl flushControl = new FlushControl();

    @Deprecated
    public IndexReader getReader() throws IOException {
        return this.getReader(this.config.getReaderTermsIndexDivisor(), true);
    }

    IndexReader getReader(boolean bl) throws IOException {
        return this.getReader(this.config.getReaderTermsIndexDivisor(), bl);
    }

    @Deprecated
    public IndexReader getReader(int n) throws IOException {
        return this.getReader(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexReader getReader(int n, boolean bl) throws IOException {
        ReadOnlyDirectoryReader readOnlyDirectoryReader;
        this.ensureOpen();
        long l = System.currentTimeMillis();
        if (this.infoStream != null) {
            this.message("flush at getReader");
        }
        this.poolReaders = true;
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.flush(false, bl);
            readOnlyDirectoryReader = new ReadOnlyDirectoryReader(this, this.segmentInfos, n, bl);
            if (this.infoStream != null) {
                this.message("return reader version=" + ((IndexReader)readOnlyDirectoryReader).getVersion() + " reader=" + readOnlyDirectoryReader);
            }
        }
        this.maybeMerge();
        if (this.infoStream != null) {
            this.message("getReader took " + (System.currentTimeMillis() - l) + " msec");
        }
        return readOnlyDirectoryReader;
    }

    Collection<IndexReader.ReaderFinishedListener> getReaderFinishedListeners() throws IOException {
        return this.readerFinishedListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numDeletedDocs(SegmentInfo segmentInfo) throws IOException {
        this.ensureOpen(false);
        SegmentReader segmentReader = this.readerPool.getIfExists(segmentInfo);
        try {
            if (segmentReader != null) {
                int n = segmentReader.numDeletedDocs();
                return n;
            }
            int n = segmentInfo.getDelCount();
            return n;
        }
        finally {
            if (segmentReader != null) {
                this.readerPool.release(segmentReader);
            }
        }
    }

    protected final void ensureOpen(boolean bl) throws AlreadyClosedException {
        if (this.closed || bl && this.closing) {
            throw new AlreadyClosedException("this IndexWriter is closed");
        }
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        this.ensureOpen(true);
    }

    public void message(String string) {
        if (this.infoStream != null) {
            this.infoStream.println("IW " + this.messageID + " [" + new Date() + "; " + Thread.currentThread().getName() + "]: " + string);
        }
    }

    private LogMergePolicy getLogMergePolicy() {
        if (this.mergePolicy instanceof LogMergePolicy) {
            return (LogMergePolicy)this.mergePolicy;
        }
        throw new IllegalArgumentException("this method can only be called when the merge policy is the default LogMergePolicy");
    }

    @Deprecated
    public boolean getUseCompoundFile() {
        return this.getLogMergePolicy().getUseCompoundFile();
    }

    @Deprecated
    public void setUseCompoundFile(boolean bl) {
        this.getLogMergePolicy().setUseCompoundFile(bl);
    }

    @Deprecated
    public void setSimilarity(Similarity similarity) {
        this.ensureOpen();
        this.similarity = similarity;
        this.docWriter.setSimilarity(similarity);
        this.config.setSimilarity(similarity);
    }

    @Deprecated
    public Similarity getSimilarity() {
        this.ensureOpen();
        return this.similarity;
    }

    @Deprecated
    public void setTermIndexInterval(int n) {
        this.ensureOpen();
        this.config.setTermIndexInterval(n);
    }

    @Deprecated
    public int getTermIndexInterval() {
        this.ensureOpen(false);
        return this.config.getTermIndexInterval();
    }

    @Deprecated
    public IndexWriter(Directory directory, Analyzer analyzer, boolean bl, MaxFieldLength maxFieldLength) throws CorruptIndexException, LockObtainFailedException, IOException {
        this(directory, new IndexWriterConfig(Version.LUCENE_31, analyzer).setOpenMode(bl ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND));
        this.setMaxFieldLength(maxFieldLength.getLimit());
    }

    @Deprecated
    public IndexWriter(Directory directory, Analyzer analyzer, MaxFieldLength maxFieldLength) throws CorruptIndexException, LockObtainFailedException, IOException {
        this(directory, new IndexWriterConfig(Version.LUCENE_31, analyzer));
        this.setMaxFieldLength(maxFieldLength.getLimit());
    }

    @Deprecated
    public IndexWriter(Directory directory, Analyzer analyzer, IndexDeletionPolicy indexDeletionPolicy, MaxFieldLength maxFieldLength) throws CorruptIndexException, LockObtainFailedException, IOException {
        this(directory, new IndexWriterConfig(Version.LUCENE_31, analyzer).setIndexDeletionPolicy(indexDeletionPolicy));
        this.setMaxFieldLength(maxFieldLength.getLimit());
    }

    @Deprecated
    public IndexWriter(Directory directory, Analyzer analyzer, boolean bl, IndexDeletionPolicy indexDeletionPolicy, MaxFieldLength maxFieldLength) throws CorruptIndexException, LockObtainFailedException, IOException {
        this(directory, new IndexWriterConfig(Version.LUCENE_31, analyzer).setOpenMode(bl ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND).setIndexDeletionPolicy(indexDeletionPolicy));
        this.setMaxFieldLength(maxFieldLength.getLimit());
    }

    @Deprecated
    public IndexWriter(Directory directory, Analyzer analyzer, IndexDeletionPolicy indexDeletionPolicy, MaxFieldLength maxFieldLength, IndexCommit indexCommit) throws CorruptIndexException, LockObtainFailedException, IOException {
        this(directory, new IndexWriterConfig(Version.LUCENE_31, analyzer).setOpenMode(IndexWriterConfig.OpenMode.APPEND).setIndexDeletionPolicy(indexDeletionPolicy).setIndexCommit(indexCommit));
        this.setMaxFieldLength(maxFieldLength.getLimit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter(Directory directory, IndexWriterConfig indexWriterConfig) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.config = (IndexWriterConfig)indexWriterConfig.clone();
        this.directory = directory;
        this.analyzer = indexWriterConfig.getAnalyzer();
        this.infoStream = defaultInfoStream;
        this.writeLockTimeout = indexWriterConfig.getWriteLockTimeout();
        this.similarity = indexWriterConfig.getSimilarity();
        this.mergePolicy = indexWriterConfig.getMergePolicy();
        this.mergePolicy.setIndexWriter(this);
        this.mergeScheduler = indexWriterConfig.getMergeScheduler();
        this.bufferedDeletesStream = new BufferedDeletesStream(this.messageID);
        this.bufferedDeletesStream.setInfoStream(this.infoStream);
        this.poolReaders = indexWriterConfig.getReaderPooling();
        this.writeLock = this.directory.makeLock(WRITE_LOCK_NAME);
        if (!this.writeLock.obtain(this.writeLockTimeout)) {
            throw new LockObtainFailedException("Index locked for write: " + this.writeLock);
        }
        IndexWriterConfig.OpenMode openMode = indexWriterConfig.getOpenMode();
        boolean bl = openMode == IndexWriterConfig.OpenMode.CREATE ? true : (openMode == IndexWriterConfig.OpenMode.APPEND ? false : !IndexReader.indexExists(this.directory));
        boolean bl2 = false;
        try {
            Object object;
            if (bl) {
                try {
                    this.segmentInfos.read(this.directory);
                    this.segmentInfos.clear();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++this.changeCount;
                this.segmentInfos.changed();
            } else {
                this.segmentInfos.read(this.directory);
                object = indexWriterConfig.getIndexCommit();
                if (object != null) {
                    if (((IndexCommit)object).getDirectory() != this.directory) {
                        throw new IllegalArgumentException("IndexCommit's directory doesn't match my directory");
                    }
                    SegmentInfos segmentInfos = new SegmentInfos();
                    segmentInfos.read(this.directory, ((IndexCommit)object).getSegmentsFileName());
                    this.segmentInfos.replace(segmentInfos);
                    ++this.changeCount;
                    this.segmentInfos.changed();
                    if (this.infoStream != null) {
                        this.message("init: loaded commit \"" + ((IndexCommit)object).getSegmentsFileName() + "\"");
                    }
                }
            }
            this.rollbackSegments = this.segmentInfos.createBackupSegmentInfos(true);
            this.docWriter = new DocumentsWriter(this.config, this.directory, this, this.getCurrentFieldInfos(), this.bufferedDeletesStream);
            this.docWriter.setInfoStream(this.infoStream);
            this.docWriter.setMaxFieldLength(this.maxFieldLength);
            object = this;
            synchronized (object) {
                this.deleter = new IndexFileDeleter(this.directory, indexWriterConfig.getIndexDeletionPolicy(), this.segmentInfos, this.infoStream, this);
            }
            if (this.deleter.startingCommitDeleted) {
                ++this.changeCount;
                this.segmentInfos.changed();
            }
            if (this.infoStream != null) {
                this.messageState();
            }
            bl2 = true;
        }
        finally {
            if (!bl2) {
                if (this.infoStream != null) {
                    this.message("init: hit exception on init; releasing write lock");
                }
                try {
                    this.writeLock.release();
                }
                catch (Throwable throwable) {}
                this.writeLock = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldInfos getFieldInfos(SegmentInfo segmentInfo) throws IOException {
        Directory directory = null;
        try {
            directory = segmentInfo.getUseCompoundFile() ? new CompoundFileReader(this.directory, IndexFileNames.segmentFileName(segmentInfo.name, "cfs")) : this.directory;
            FieldInfos fieldInfos = new FieldInfos(directory, IndexFileNames.segmentFileName(segmentInfo.name, "fnm"));
            return fieldInfos;
        }
        finally {
            if (segmentInfo.getUseCompoundFile() && directory != null) {
                directory.close();
            }
        }
    }

    private FieldInfos getCurrentFieldInfos() throws IOException {
        FieldInfos fieldInfos;
        if (this.segmentInfos.size() > 0) {
            if (this.segmentInfos.getFormat() > -9) {
                fieldInfos = new FieldInfos();
                for (SegmentInfo segmentInfo : this.segmentInfos) {
                    FieldInfos fieldInfos2 = this.getFieldInfos(segmentInfo);
                    int n = fieldInfos2.size();
                    for (int i = 0; i < n; ++i) {
                        fieldInfos.add(fieldInfos2.fieldInfo(i));
                    }
                }
            } else {
                fieldInfos = this.getFieldInfos(this.segmentInfos.info(this.segmentInfos.size() - 1));
            }
        } else {
            fieldInfos = new FieldInfos();
        }
        return fieldInfos;
    }

    public IndexWriterConfig getConfig() {
        this.ensureOpen(false);
        return this.config;
    }

    @Deprecated
    public void setMergePolicy(MergePolicy mergePolicy) {
        this.ensureOpen();
        if (mergePolicy == null) {
            throw new NullPointerException("MergePolicy must be non-null");
        }
        if (this.mergePolicy != mergePolicy) {
            this.mergePolicy.close();
        }
        this.mergePolicy = mergePolicy;
        this.mergePolicy.setIndexWriter(this);
        this.pushMaxBufferedDocs();
        if (this.infoStream != null) {
            this.message("setMergePolicy " + mergePolicy);
        }
        this.config.setMergePolicy(mergePolicy);
    }

    @Deprecated
    public MergePolicy getMergePolicy() {
        this.ensureOpen();
        return this.mergePolicy;
    }

    @Deprecated
    public synchronized void setMergeScheduler(MergeScheduler mergeScheduler) throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (mergeScheduler == null) {
            throw new NullPointerException("MergeScheduler must be non-null");
        }
        if (this.mergeScheduler != mergeScheduler) {
            this.finishMerges(true);
            this.mergeScheduler.close();
        }
        this.mergeScheduler = mergeScheduler;
        if (this.infoStream != null) {
            this.message("setMergeScheduler " + mergeScheduler);
        }
        this.config.setMergeScheduler(mergeScheduler);
    }

    @Deprecated
    public MergeScheduler getMergeScheduler() {
        this.ensureOpen();
        return this.mergeScheduler;
    }

    @Deprecated
    public void setMaxMergeDocs(int n) {
        this.getLogMergePolicy().setMaxMergeDocs(n);
    }

    @Deprecated
    public int getMaxMergeDocs() {
        return this.getLogMergePolicy().getMaxMergeDocs();
    }

    @Deprecated
    public void setMaxFieldLength(int n) {
        this.ensureOpen();
        this.maxFieldLength = n;
        this.docWriter.setMaxFieldLength(n);
        if (this.infoStream != null) {
            this.message("setMaxFieldLength " + n);
        }
    }

    @Deprecated
    public int getMaxFieldLength() {
        this.ensureOpen();
        return this.maxFieldLength;
    }

    @Deprecated
    public void setReaderTermsIndexDivisor(int n) {
        this.ensureOpen();
        this.config.setReaderTermsIndexDivisor(n);
        if (this.infoStream != null) {
            this.message("setReaderTermsIndexDivisor " + n);
        }
    }

    @Deprecated
    public int getReaderTermsIndexDivisor() {
        this.ensureOpen();
        return this.config.getReaderTermsIndexDivisor();
    }

    @Deprecated
    public void setMaxBufferedDocs(int n) {
        this.ensureOpen();
        this.pushMaxBufferedDocs();
        if (this.infoStream != null) {
            this.message("setMaxBufferedDocs " + n);
        }
        this.config.setMaxBufferedDocs(n);
    }

    private void pushMaxBufferedDocs() {
        MergePolicy mergePolicy;
        if (this.config.getMaxBufferedDocs() != -1 && (mergePolicy = this.mergePolicy) instanceof LogDocMergePolicy) {
            LogDocMergePolicy logDocMergePolicy = (LogDocMergePolicy)mergePolicy;
            int n = this.config.getMaxBufferedDocs();
            if (logDocMergePolicy.getMinMergeDocs() != n) {
                if (this.infoStream != null) {
                    this.message("now push maxBufferedDocs " + n + " to LogDocMergePolicy");
                }
                logDocMergePolicy.setMinMergeDocs(n);
            }
        }
    }

    @Deprecated
    public int getMaxBufferedDocs() {
        this.ensureOpen();
        return this.config.getMaxBufferedDocs();
    }

    @Deprecated
    public void setRAMBufferSizeMB(double d) {
        if (this.infoStream != null) {
            this.message("setRAMBufferSizeMB " + d);
        }
        this.config.setRAMBufferSizeMB(d);
    }

    @Deprecated
    public double getRAMBufferSizeMB() {
        return this.config.getRAMBufferSizeMB();
    }

    @Deprecated
    public void setMaxBufferedDeleteTerms(int n) {
        this.ensureOpen();
        if (this.infoStream != null) {
            this.message("setMaxBufferedDeleteTerms " + n);
        }
        this.config.setMaxBufferedDeleteTerms(n);
    }

    @Deprecated
    public int getMaxBufferedDeleteTerms() {
        this.ensureOpen();
        return this.config.getMaxBufferedDeleteTerms();
    }

    @Deprecated
    public void setMergeFactor(int n) {
        this.getLogMergePolicy().setMergeFactor(n);
    }

    @Deprecated
    public int getMergeFactor() {
        return this.getLogMergePolicy().getMergeFactor();
    }

    public static void setDefaultInfoStream(PrintStream printStream) {
        defaultInfoStream = printStream;
    }

    public static PrintStream getDefaultInfoStream() {
        return defaultInfoStream;
    }

    public void setInfoStream(PrintStream printStream) throws IOException {
        this.ensureOpen();
        this.infoStream = printStream;
        this.docWriter.setInfoStream(printStream);
        this.deleter.setInfoStream(printStream);
        this.bufferedDeletesStream.setInfoStream(printStream);
        if (printStream != null) {
            this.messageState();
        }
    }

    private void messageState() throws IOException {
        this.message("\ndir=" + this.directory + "\n" + "index=" + this.segString() + "\n" + "version=" + Constants.LUCENE_VERSION + "\n" + this.config.toString());
    }

    public PrintStream getInfoStream() {
        this.ensureOpen();
        return this.infoStream;
    }

    public boolean verbose() {
        return this.infoStream != null;
    }

    @Deprecated
    public void setWriteLockTimeout(long l) {
        this.ensureOpen();
        this.writeLockTimeout = l;
        this.config.setWriteLockTimeout(l);
    }

    @Deprecated
    public long getWriteLockTimeout() {
        this.ensureOpen();
        return this.writeLockTimeout;
    }

    @Deprecated
    public static void setDefaultWriteLockTimeout(long l) {
        IndexWriterConfig.setDefaultWriteLockTimeout(l);
    }

    @Deprecated
    public static long getDefaultWriteLockTimeout() {
        return IndexWriterConfig.getDefaultWriteLockTimeout();
    }

    @Override
    public void close() throws CorruptIndexException, IOException {
        this.close(true);
    }

    public void close(boolean bl) throws CorruptIndexException, IOException {
        if (this.shouldClose()) {
            if (this.hitOOM) {
                this.rollbackInternal();
            } else {
                this.closeInternal(bl);
            }
        }
    }

    private synchronized boolean shouldClose() {
        while (!this.closed) {
            if (!this.closing) {
                this.closing = true;
                return true;
            }
            this.doWait();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean bl) throws CorruptIndexException, IOException {
        try {
            if (this.infoStream != null) {
                this.message("now flush at close waitForMerges=" + bl);
            }
            this.docWriter.close();
            if (!this.hitOOM) {
                this.flush(bl, true);
            }
            if (bl) {
                this.mergeScheduler.merge(this);
            }
            this.mergePolicy.close();
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.finishMerges(bl);
                this.stopMerges = true;
            }
            this.mergeScheduler.close();
            if (this.infoStream != null) {
                this.message("now call final commit()");
            }
            if (!this.hitOOM) {
                this.commitInternal(null);
            }
            if (this.infoStream != null) {
                this.message("at close: " + this.segString());
            }
            indexWriter = this;
            synchronized (indexWriter) {
                this.readerPool.close();
                this.docWriter = null;
                this.deleter.close();
            }
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
            indexWriter = this;
            synchronized (indexWriter) {
                this.closed = true;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "closeInternal");
        }
        finally {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.closing = false;
                this.notifyAll();
                if (!this.closed && this.infoStream != null) {
                    this.message("hit exception while closing");
                }
            }
        }
    }

    public Directory getDirectory() {
        this.ensureOpen(false);
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        this.ensureOpen();
        return this.analyzer;
    }

    public synchronized int maxDoc() {
        this.ensureOpen();
        int n = this.docWriter != null ? this.docWriter.getNumDocs() : 0;
        return n += this.segmentInfos.totalDocCount();
    }

    public synchronized int numDocs() throws IOException {
        this.ensureOpen();
        int n = this.docWriter != null ? this.docWriter.getNumDocs() : 0;
        for (SegmentInfo segmentInfo : this.segmentInfos) {
            n += segmentInfo.docCount - this.numDeletedDocs(segmentInfo);
        }
        return n;
    }

    public synchronized boolean hasDeletions() throws IOException {
        this.ensureOpen();
        if (this.bufferedDeletesStream.any()) {
            return true;
        }
        if (this.docWriter.anyDeletions()) {
            return true;
        }
        for (SegmentInfo segmentInfo : this.segmentInfos) {
            if (!segmentInfo.hasDeletions()) continue;
            return true;
        }
        return false;
    }

    public void addDocument(Document document) throws CorruptIndexException, IOException {
        this.addDocument(document, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document document, Analyzer analyzer) throws CorruptIndexException, IOException {
        this.ensureOpen();
        boolean bl = false;
        boolean bl2 = false;
        try {
            try {
                bl = this.docWriter.updateDocument(document, analyzer, null);
                bl2 = true;
            }
            finally {
                if (!bl2 && this.infoStream != null) {
                    this.message("hit exception adding document");
                }
            }
            if (bl) {
                this.flush(true, false);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "addDocument");
        }
    }

    public void addDocuments(Collection<Document> collection) throws CorruptIndexException, IOException {
        this.addDocuments(collection, this.analyzer);
    }

    public void addDocuments(Collection<Document> collection, Analyzer analyzer) throws CorruptIndexException, IOException {
        this.updateDocuments(null, collection, analyzer);
    }

    public void updateDocuments(Term term, Collection<Document> collection) throws CorruptIndexException, IOException {
        this.updateDocuments(term, collection, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocuments(Term term, Collection<Document> collection, Analyzer analyzer) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            boolean bl = false;
            boolean bl2 = false;
            try {
                bl2 = this.docWriter.updateDocuments(collection, analyzer, term);
                bl = true;
            }
            finally {
                if (!bl && this.infoStream != null) {
                    this.message("hit exception updating document");
                }
            }
            if (bl2) {
                this.flush(true, false);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "updateDocuments");
        }
    }

    public void deleteDocuments(Term term) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            if (this.docWriter.deleteTerm(term, false)) {
                this.flush(true, false);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "deleteDocuments(Term)");
        }
    }

    public void deleteDocuments(Term ... termArray) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            if (this.docWriter.deleteTerms(termArray)) {
                this.flush(true, false);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "deleteDocuments(Term..)");
        }
    }

    public void deleteDocuments(Query query) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            if (this.docWriter.deleteQuery(query)) {
                this.flush(true, false);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "deleteDocuments(Query)");
        }
    }

    public void deleteDocuments(Query ... queryArray) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            if (this.docWriter.deleteQueries(queryArray)) {
                this.flush(true, false);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "deleteDocuments(Query..)");
        }
    }

    public void updateDocument(Term term, Document document) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.updateDocument(term, document, this.getAnalyzer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Term term, Document document, Analyzer analyzer) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            boolean bl = false;
            boolean bl2 = false;
            try {
                bl = this.docWriter.updateDocument(document, analyzer, term);
                bl2 = true;
            }
            finally {
                if (!bl2 && this.infoStream != null) {
                    this.message("hit exception updating document");
                }
            }
            if (bl) {
                this.flush(true, false);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "updateDocument");
        }
    }

    final synchronized int getSegmentCount() {
        return this.segmentInfos.size();
    }

    final synchronized int getNumBufferedDocuments() {
        return this.docWriter.getNumDocs();
    }

    final synchronized int getDocCount(int n) {
        if (n >= 0 && n < this.segmentInfos.size()) {
            return this.segmentInfos.info((int)n).docCount;
        }
        return -1;
    }

    final int getFlushCount() {
        return this.flushCount.get();
    }

    final int getFlushDeletesCount() {
        return this.flushDeletesCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String newSegmentName() {
        SegmentInfos segmentInfos = this.segmentInfos;
        synchronized (segmentInfos) {
            ++this.changeCount;
            this.segmentInfos.changed();
            return "_" + Integer.toString(this.segmentInfos.counter++, 36);
        }
    }

    @Deprecated
    public void optimize() throws CorruptIndexException, IOException {
        this.forceMerge(1, true);
    }

    @Deprecated
    public void optimize(int n) throws CorruptIndexException, IOException {
        this.forceMerge(n, true);
    }

    @Deprecated
    public void optimize(boolean bl) throws CorruptIndexException, IOException {
        this.forceMerge(1, bl);
    }

    public void forceMerge(int n) throws CorruptIndexException, IOException {
        this.forceMerge(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMerge(int n, boolean bl) throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (n < 1) {
            throw new IllegalArgumentException("maxNumSegments must be >= 1; got " + n);
        }
        if (this.infoStream != null) {
            this.message("forceMerge: index now " + this.segString());
            this.message("now flush at forceMerge");
        }
        this.flush(true, true);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.resetMergeExceptions();
            this.segmentsToMerge.clear();
            for (SegmentInfo object : this.segmentInfos) {
                this.segmentsToMerge.put(object, Boolean.TRUE);
            }
            this.mergeMaxNumSegments = n;
            for (MergePolicy.OneMerge oneMerge : this.pendingMerges) {
                oneMerge.maxNumSegments = n;
                this.segmentsToMerge.put(oneMerge.info, Boolean.TRUE);
            }
            for (MergePolicy.OneMerge oneMerge : this.runningMerges) {
                oneMerge.maxNumSegments = n;
                this.segmentsToMerge.put(oneMerge.info, Boolean.TRUE);
            }
        }
        this.maybeMerge(n);
        if (bl) {
            indexWriter = this;
            synchronized (indexWriter) {
                while (true) {
                    if (this.hitOOM) {
                        throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot complete forceMerge");
                    }
                    if (this.mergeExceptions.size() > 0) {
                        int n2 = this.mergeExceptions.size();
                        for (int i = 0; i < n2; ++i) {
                            MergePolicy.OneMerge oneMerge = this.mergeExceptions.get(i);
                            if (oneMerge.maxNumSegments == -1) continue;
                            IOException iOException = new IOException("background merge hit exception: " + oneMerge.segString(this.directory));
                            Throwable throwable = oneMerge.getException();
                            if (throwable != null) {
                                iOException.initCause(throwable);
                            }
                            throw iOException;
                        }
                    }
                    if (!this.maxNumSegmentsMergesPending()) break;
                    this.doWait();
                }
            }
            this.ensureOpen();
        }
    }

    private synchronized boolean maxNumSegmentsMergesPending() {
        for (MergePolicy.OneMerge oneMerge : this.pendingMerges) {
            if (oneMerge.maxNumSegments == -1) continue;
            return true;
        }
        for (MergePolicy.OneMerge oneMerge : this.runningMerges) {
            if (oneMerge.maxNumSegments == -1) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void expungeDeletes(boolean bl) throws CorruptIndexException, IOException {
        this.forceMergeDeletes(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMergeDeletes(boolean bl) throws CorruptIndexException, IOException {
        int n;
        MergePolicy.MergeSpecification mergeSpecification;
        this.ensureOpen();
        this.flush(true, true);
        if (this.infoStream != null) {
            this.message("forceMergeDeletes: index now " + this.segString());
        }
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            mergeSpecification = this.mergePolicy.findForcedDeletesMerges(this.segmentInfos);
            if (mergeSpecification != null) {
                int n2 = mergeSpecification.merges.size();
                for (n = 0; n < n2; ++n) {
                    this.registerMerge(mergeSpecification.merges.get(n));
                }
            }
        }
        this.mergeScheduler.merge(this);
        if (mergeSpecification != null && bl) {
            int n3 = mergeSpecification.merges.size();
            IndexWriter indexWriter2 = this;
            synchronized (indexWriter2) {
                n = 1;
                while (n != 0) {
                    if (this.hitOOM) {
                        throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot complete forceMergeDeletes");
                    }
                    n = 0;
                    for (int i = 0; i < n3; ++i) {
                        Throwable throwable;
                        MergePolicy.OneMerge oneMerge = mergeSpecification.merges.get(i);
                        if (this.pendingMerges.contains(oneMerge) || this.runningMerges.contains(oneMerge)) {
                            n = 1;
                        }
                        if ((throwable = oneMerge.getException()) == null) continue;
                        IOException iOException = new IOException("background merge hit exception: " + oneMerge.segString(this.directory));
                        iOException.initCause(throwable);
                        throw iOException;
                    }
                    if (n == 0) continue;
                    this.doWait();
                }
            }
        }
    }

    @Deprecated
    public void expungeDeletes() throws CorruptIndexException, IOException {
        this.forceMergeDeletes();
    }

    public void forceMergeDeletes() throws CorruptIndexException, IOException {
        this.forceMergeDeletes(true);
    }

    public final void maybeMerge() throws CorruptIndexException, IOException {
        this.maybeMerge(-1);
    }

    private final void maybeMerge(int n) throws CorruptIndexException, IOException {
        this.ensureOpen(false);
        this.updatePendingMerges(n);
        this.mergeScheduler.merge(this);
    }

    private synchronized void updatePendingMerges(int n) throws CorruptIndexException, IOException {
        int n2;
        int n3;
        MergePolicy.MergeSpecification mergeSpecification;
        assert (n == -1 || n > 0);
        if (this.stopMerges) {
            return;
        }
        if (this.hitOOM) {
            return;
        }
        if (n != -1) {
            mergeSpecification = this.mergePolicy.findForcedMerges(this.segmentInfos, n, Collections.unmodifiableMap(this.segmentsToMerge));
            if (mergeSpecification != null) {
                n3 = mergeSpecification.merges.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    MergePolicy.OneMerge oneMerge = mergeSpecification.merges.get(n2);
                    oneMerge.maxNumSegments = n;
                }
            }
        } else {
            mergeSpecification = this.mergePolicy.findMerges(this.segmentInfos);
        }
        if (mergeSpecification != null) {
            n3 = mergeSpecification.merges.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.registerMerge(mergeSpecification.merges.get(n2));
            }
        }
    }

    public synchronized Collection<SegmentInfo> getMergingSegments() {
        return this.mergingSegments;
    }

    public synchronized MergePolicy.OneMerge getNextMerge() {
        if (this.pendingMerges.size() == 0) {
            return null;
        }
        MergePolicy.OneMerge oneMerge = this.pendingMerges.removeFirst();
        this.runningMerges.add(oneMerge);
        return oneMerge;
    }

    @Override
    public void rollback() throws IOException {
        this.ensureOpen();
        if (this.shouldClose()) {
            this.rollbackInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackInternal() throws IOException {
        boolean bl = false;
        if (this.infoStream != null) {
            this.message("rollback");
        }
        try {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.finishMerges(false);
                this.stopMerges = true;
            }
            if (this.infoStream != null) {
                this.message("rollback: done finish merges");
            }
            this.mergePolicy.close();
            this.mergeScheduler.close();
            this.bufferedDeletesStream.clear();
            indexWriter = this;
            synchronized (indexWriter) {
                if (this.pendingCommit != null) {
                    this.pendingCommit.rollbackCommit(this.directory);
                    this.deleter.decRef(this.pendingCommit);
                    this.pendingCommit = null;
                    this.notifyAll();
                }
                this.segmentInfos.rollbackSegmentInfos(this.rollbackSegments);
                if (this.infoStream != null) {
                    this.message("rollback: infos=" + this.segString(this.segmentInfos));
                }
                this.docWriter.abort();
                assert (this.testPoint("rollback before checkpoint"));
                this.deleter.checkpoint(this.segmentInfos, false);
                this.deleter.refresh();
            }
            this.readerPool.clear(null);
            this.lastCommitChangeCount = this.changeCount;
            bl = true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "rollbackInternal");
        }
        finally {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (!bl) {
                    this.closing = false;
                    this.notifyAll();
                    if (this.infoStream != null) {
                        this.message("hit exception during rollback");
                    }
                }
            }
        }
        this.closeInternal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteAll() throws IOException {
        this.ensureOpen();
        try {
            this.finishMerges(false);
            this.docWriter.abort();
            this.segmentInfos.clear();
            this.deleter.checkpoint(this.segmentInfos, false);
            this.deleter.refresh();
            this.readerPool.dropAll();
            ++this.changeCount;
            this.segmentInfos.changed();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "deleteAll");
        }
        finally {
            if (this.infoStream != null) {
                this.message("hit exception during deleteAll");
            }
        }
    }

    private synchronized void finishMerges(boolean bl) throws IOException {
        if (!bl) {
            this.stopMerges = true;
            for (MergePolicy.OneMerge oneMerge : this.pendingMerges) {
                if (this.infoStream != null) {
                    this.message("now abort pending merge " + oneMerge.segString(this.directory));
                }
                oneMerge.abort();
                this.mergeFinish(oneMerge);
            }
            this.pendingMerges.clear();
            for (MergePolicy.OneMerge oneMerge : this.runningMerges) {
                if (this.infoStream != null) {
                    this.message("now abort running merge " + oneMerge.segString(this.directory));
                }
                oneMerge.abort();
            }
            while (this.runningMerges.size() > 0) {
                if (this.infoStream != null) {
                    this.message("now wait for " + this.runningMerges.size() + " running merge to abort");
                }
                this.doWait();
            }
            this.stopMerges = false;
            this.notifyAll();
            assert (0 == this.mergingSegments.size());
            if (this.infoStream != null) {
                this.message("all running merges have aborted");
            }
        } else {
            this.waitForMerges();
        }
    }

    public synchronized void waitForMerges() {
        this.ensureOpen(false);
        if (this.infoStream != null) {
            this.message("waitForMerges");
        }
        while (this.pendingMerges.size() > 0 || this.runningMerges.size() > 0) {
            this.doWait();
        }
        assert (0 == this.mergingSegments.size());
        if (this.infoStream != null) {
            this.message("waitForMerges done");
        }
    }

    synchronized void checkpoint() throws IOException {
        ++this.changeCount;
        this.segmentInfos.changed();
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    private synchronized void resetMergeExceptions() {
        this.mergeExceptions = new ArrayList<MergePolicy.OneMerge>();
        ++this.mergeGen;
    }

    private void noDupDirs(Directory ... directoryArray) {
        HashSet<Directory> hashSet = new HashSet<Directory>();
        for (Directory directory : directoryArray) {
            if (hashSet.contains(directory)) {
                throw new IllegalArgumentException("Directory " + directory + " appears more than once");
            }
            if (directory == this.directory) {
                throw new IllegalArgumentException("Cannot add directory to itself");
            }
            hashSet.add(directory);
        }
    }

    @Deprecated
    public void addIndexesNoOptimize(Directory ... directoryArray) throws CorruptIndexException, IOException {
        this.addIndexes(directoryArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexes(Directory ... directoryArray) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.noDupDirs(directoryArray);
        try {
            if (this.infoStream != null) {
                this.message("flush at addIndexes(Directory...)");
            }
            this.flush(false, true);
            int n = 0;
            ArrayList<SegmentInfo> arrayList = new ArrayList<SegmentInfo>();
            Comparator<String> comparator = StringHelper.getVersionComparator();
            for (Directory directory : directoryArray) {
                if (this.infoStream != null) {
                    this.message("addIndexes: process directory " + directory);
                }
                SegmentInfos segmentInfos = new SegmentInfos();
                segmentInfos.read(directory);
                HashSet<String> hashSet = new HashSet<String>();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (SegmentInfo segmentInfo : segmentInfos) {
                    boolean bl;
                    assert (!arrayList.contains(segmentInfo)) : "dup info dir=" + segmentInfo.dir + " name=" + segmentInfo.name;
                    n += segmentInfo.docCount;
                    String string = this.newSegmentName();
                    String string2 = segmentInfo.getDocStoreSegment();
                    if (this.infoStream != null) {
                        this.message("addIndexes: process segment origName=" + segmentInfo.name + " newName=" + string + " dsName=" + string2 + " info=" + segmentInfo);
                    }
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        bl = !segmentInfo.getUseCompoundFile() && this.mergePolicy.useCompoundFile(this.segmentInfos, segmentInfo) && comparator.compare(segmentInfo.getVersion(), "3.1") >= 0;
                    }
                    if (bl) {
                        this.copySegmentIntoCFS(segmentInfo, string);
                    } else {
                        this.copySegmentAsIs(segmentInfo, string, hashMap, hashSet);
                    }
                    arrayList.add(segmentInfo);
                }
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.ensureOpen();
                this.segmentInfos.addAll(arrayList);
                this.checkpoint();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "addIndexes(Directory...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexes(IndexReader ... indexReaderArray) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            int n;
            Closeable closeable2;
            if (this.infoStream != null) {
                this.message("flush at addIndexes(IndexReader...)");
            }
            this.flush(false, true);
            String string = this.newSegmentName();
            SegmentMerger segmentMerger = new SegmentMerger(this.directory, this.config.getTermIndexInterval(), string, null, this.payloadProcessorProvider, (FieldInfos)this.docWriter.getFieldInfos().clone());
            for (Closeable closeable2 : indexReaderArray) {
                segmentMerger.add((IndexReader)closeable2);
            }
            int n2 = segmentMerger.merge();
            SegmentInfo segmentInfo = new SegmentInfo(string, n2, this.directory, false, true, segmentMerger.fieldInfos().hasProx(), segmentMerger.fieldInfos().hasVectors());
            this.setDiagnostics(segmentInfo, "addIndexes(IndexReader...)");
            closeable2 = this;
            synchronized (closeable2) {
                if (this.stopMerges) {
                    this.deleter.deleteNewFiles(segmentInfo.files());
                    return;
                }
                this.ensureOpen();
                n = this.mergePolicy.useCompoundFile(this.segmentInfos, segmentInfo) ? 1 : 0;
            }
            if (n != 0) {
                segmentMerger.createCompoundFile(string + ".cfs", segmentInfo);
                closeable2 = this;
                synchronized (closeable2) {
                    this.deleter.deleteNewFiles(segmentInfo.files());
                }
                segmentInfo.setUseCompoundFile(true);
            }
            closeable2 = this;
            synchronized (closeable2) {
                if (this.stopMerges) {
                    this.deleter.deleteNewFiles(segmentInfo.files());
                    return;
                }
                this.ensureOpen();
                this.segmentInfos.add(segmentInfo);
                this.checkpoint();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "addIndexes(IndexReader...)");
        }
    }

    private void copySegmentIntoCFS(SegmentInfo segmentInfo, String string) throws IOException {
        String string2 = IndexFileNames.segmentFileName(string, "cfs");
        List<String> list = segmentInfo.files();
        CompoundFileWriter compoundFileWriter = new CompoundFileWriter(this.directory, string2);
        for (String string3 : list) {
            String string4 = string + IndexFileNames.stripSegmentName(string3);
            if (!IndexFileNames.matchesExtension(string3, "del") && !IndexFileNames.isSeparateNormsFile(string3)) {
                compoundFileWriter.addFile(string3, segmentInfo.dir);
                continue;
            }
            assert (!this.directory.fileExists(string4)) : "file \"" + string4 + "\" already exists";
            segmentInfo.dir.copy(this.directory, string3, string4);
        }
        compoundFileWriter.close();
        segmentInfo.dir = this.directory;
        segmentInfo.name = string;
        segmentInfo.setUseCompoundFile(true);
    }

    private void copySegmentAsIs(SegmentInfo segmentInfo, String string, Map<String, String> map, Set<String> set) throws IOException {
        String string2;
        String string3 = segmentInfo.getDocStoreSegment();
        if (string3 != null) {
            if (map.containsKey(string3)) {
                string2 = map.get(string3);
            } else {
                map.put(string3, string);
                string2 = string;
            }
        } else {
            string2 = string;
        }
        for (String string4 : segmentInfo.files()) {
            String string5;
            if (IndexFileNames.isDocStoreFile(string4)) {
                string5 = string2 + IndexFileNames.stripSegmentName(string4);
                if (set.contains(string5)) continue;
                set.add(string5);
            } else {
                string5 = string + IndexFileNames.stripSegmentName(string4);
            }
            assert (!this.directory.fileExists(string5)) : "file \"" + string5 + "\" already exists";
            segmentInfo.dir.copy(this.directory, string4, string5);
        }
        segmentInfo.setDocStore(segmentInfo.getDocStoreOffset(), string2, segmentInfo.getDocStoreIsCompoundFile());
        segmentInfo.dir = this.directory;
        segmentInfo.name = string;
    }

    protected void doAfterFlush() throws IOException {
    }

    protected void doBeforeFlush() throws IOException {
    }

    @Override
    public final void prepareCommit() throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.prepareCommit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void prepareCommit(Map<String, String> map) throws CorruptIndexException, IOException {
        IndexWriter indexWriter;
        this.ensureOpen(false);
        if (this.hitOOM) {
            throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot commit");
        }
        if (this.pendingCommit != null) {
            throw new IllegalStateException("prepareCommit was already called with no corresponding call to commit");
        }
        if (this.infoStream != null) {
            this.message("prepareCommit: flush");
        }
        this.ensureOpen(false);
        boolean bl = false;
        SegmentInfos segmentInfos = null;
        boolean bl2 = false;
        try {
            try {
                indexWriter = this;
                synchronized (indexWriter) {
                    bl = this.doFlush(true);
                    this.readerPool.commit(this.segmentInfos);
                    segmentInfos = (SegmentInfos)this.segmentInfos.clone();
                    this.pendingCommitChangeCount = this.changeCount;
                    this.deleter.incRef(segmentInfos, false);
                }
                bl2 = true;
            }
            finally {
                if (!bl2 && this.infoStream != null) {
                    this.message("hit exception during prepareCommit");
                }
                this.doAfterFlush();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "prepareCommit");
        }
        bl2 = false;
        try {
            if (bl) {
                this.maybeMerge();
            }
            bl2 = true;
        }
        finally {
            if (!bl2) {
                indexWriter = this;
                synchronized (indexWriter) {
                    this.deleter.decRef(segmentInfos);
                }
            }
        }
        this.startCommit(segmentInfos, map);
    }

    @Override
    public final void commit() throws CorruptIndexException, IOException {
        this.commit(null);
    }

    @Override
    public final void commit(Map<String, String> map) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.commitInternal(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void commitInternal(Map<String, String> map) throws CorruptIndexException, IOException {
        if (this.infoStream != null) {
            this.message("commit: start");
        }
        Object object = this.commitLock;
        synchronized (object) {
            if (this.infoStream != null) {
                this.message("commit: enter lock");
            }
            if (this.pendingCommit == null) {
                if (this.infoStream != null) {
                    this.message("commit: now prepare");
                }
                this.prepareCommit(map);
            } else if (this.infoStream != null) {
                this.message("commit: already prepared");
            }
            this.finishCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void finishCommit() throws CorruptIndexException, IOException {
        if (this.pendingCommit != null) {
            try {
                if (this.infoStream != null) {
                    this.message("commit: pendingCommit != null");
                }
                this.pendingCommit.finishCommit(this.directory);
                if (this.infoStream != null) {
                    this.message("commit: wrote segments file \"" + this.pendingCommit.getCurrentSegmentFileName() + "\"");
                }
                this.lastCommitChangeCount = this.pendingCommitChangeCount;
                this.segmentInfos.updateGeneration(this.pendingCommit);
                this.segmentInfos.setUserData(this.pendingCommit.getUserData());
                this.rollbackSegments = this.pendingCommit.createBackupSegmentInfos(true);
                this.deleter.checkpoint(this.pendingCommit, true);
            }
            finally {
                this.deleter.decRef(this.pendingCommit);
                this.pendingCommit = null;
                this.notifyAll();
            }
        } else if (this.infoStream != null) {
            this.message("commit: pendingCommit == null; skip");
        }
        if (this.infoStream != null) {
            this.message("commit: done");
        }
    }

    protected final void flush(boolean bl, boolean bl2, boolean bl3) throws CorruptIndexException, IOException {
        this.flush(bl, bl3);
    }

    protected final void flush(boolean bl, boolean bl2) throws CorruptIndexException, IOException {
        this.ensureOpen(false);
        if (this.doFlush(bl2) && bl) {
            this.maybeMerge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean doFlush(boolean bl) throws CorruptIndexException, IOException {
        if (this.hitOOM) {
            throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot flush");
        }
        this.doBeforeFlush();
        assert (this.testPoint("startDoFlush"));
        this.flushControl.setFlushPendingNoWait("explicit flush");
        boolean bl2 = false;
        try {
            SegmentInfo segmentInfo;
            if (this.infoStream != null) {
                this.message("  start flush: applyAllDeletes=" + bl);
                this.message("  index before flush " + this.segString());
            }
            if ((segmentInfo = this.docWriter.flush(this, this.deleter, this.mergePolicy, this.segmentInfos)) != null) {
                this.setDiagnostics(segmentInfo, "flush");
                this.segmentInfos.add(segmentInfo);
                this.checkpoint();
            }
            if (!bl && (this.flushControl.getFlushDeletes() || this.config.getRAMBufferSizeMB() != -1.0 && (double)this.bufferedDeletesStream.bytesUsed() > 1048576.0 * this.config.getRAMBufferSizeMB() / 2.0)) {
                bl = true;
                if (this.infoStream != null) {
                    this.message("force apply deletes bytesUsed=" + this.bufferedDeletesStream.bytesUsed() + " vs ramBuffer=" + 1048576.0 * this.config.getRAMBufferSizeMB());
                }
            }
            if (bl) {
                if (this.infoStream != null) {
                    this.message("apply all deletes during flush");
                }
                this.flushDeletesCount.incrementAndGet();
                BufferedDeletesStream.ApplyDeletesResult applyDeletesResult = this.bufferedDeletesStream.applyDeletes(this.readerPool, this.segmentInfos.asList());
                if (applyDeletesResult.anyDeletes) {
                    this.checkpoint();
                }
                if (!this.keepFullyDeletedSegments && applyDeletesResult.allDeleted != null) {
                    if (this.infoStream != null) {
                        this.message("drop 100% deleted segments: " + applyDeletesResult.allDeleted);
                    }
                    for (SegmentInfo segmentInfo2 : applyDeletesResult.allDeleted) {
                        if (this.mergingSegments.contains(segmentInfo2)) continue;
                        this.segmentInfos.remove(segmentInfo2);
                        if (this.readerPool == null) continue;
                        this.readerPool.drop(segmentInfo2);
                    }
                    this.checkpoint();
                }
                this.bufferedDeletesStream.prune(this.segmentInfos);
                assert (!this.bufferedDeletesStream.any());
                this.flushControl.clearDeletes();
            } else if (this.infoStream != null) {
                this.message("don't apply deletes now delTermCount=" + this.bufferedDeletesStream.numTerms() + " bytesUsed=" + this.bufferedDeletesStream.bytesUsed());
            }
            this.doAfterFlush();
            this.flushCount.incrementAndGet();
            bl2 = true;
            boolean bl3 = segmentInfo != null;
            return bl3;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "doFlush");
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.flushControl.clearFlushPending();
            if (!bl2 && this.infoStream != null) {
                this.message("hit exception during flush");
            }
        }
    }

    public final long ramSizeInBytes() {
        this.ensureOpen();
        return this.docWriter.bytesUsed() + this.bufferedDeletesStream.bytesUsed();
    }

    public final synchronized int numRamDocs() {
        this.ensureOpen();
        return this.docWriter.getNumDocs();
    }

    private void ensureValidMerge(MergePolicy.OneMerge oneMerge) throws IOException {
        for (SegmentInfo segmentInfo : oneMerge.segments) {
            if (this.segmentInfos.contains(segmentInfo)) continue;
            throw new MergePolicy.MergeException("MergePolicy selected a segment (" + segmentInfo.name + ") that is not in the current index " + this.segString(), this.directory);
        }
    }

    private synchronized void commitMergedDeletes(MergePolicy.OneMerge oneMerge, SegmentReader segmentReader) throws IOException {
        assert (this.testPoint("startCommitMergeDeletes"));
        List<SegmentInfo> list = oneMerge.segments;
        if (this.infoStream != null) {
            this.message("commitMergeDeletes " + oneMerge.segString(this.directory));
        }
        int n = 0;
        int n2 = 0;
        long l = Long.MAX_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            int n3;
            SegmentInfo segmentInfo = list.get(i);
            l = Math.min(segmentInfo.getBufferedDeletesGen(), l);
            int n4 = segmentInfo.docCount;
            SegmentReader segmentReader2 = oneMerge.readerClones.get(i);
            if (segmentReader2 == null) continue;
            SegmentReader segmentReader3 = oneMerge.readers.get(i);
            if (segmentReader2.hasDeletions()) {
                if (segmentReader3.numDeletedDocs() > segmentReader2.numDeletedDocs()) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (segmentReader2.isDeleted(n3)) {
                            assert (segmentReader3.isDeleted(n3));
                            continue;
                        }
                        if (segmentReader3.isDeleted(n3)) {
                            segmentReader.doDelete(n);
                            ++n2;
                        }
                        ++n;
                    }
                    continue;
                }
                n += n4 - segmentReader2.numDeletedDocs();
                continue;
            }
            if (segmentReader3.hasDeletions()) {
                for (n3 = 0; n3 < n4; ++n3) {
                    if (segmentReader3.isDeleted(n3)) {
                        segmentReader.doDelete(n);
                        ++n2;
                    }
                    ++n;
                }
                continue;
            }
            n += segmentInfo.docCount;
        }
        assert (segmentReader.numDeletedDocs() == n2);
        boolean bl = segmentReader.hasChanges = n2 > 0;
        assert (!segmentReader.hasChanges || l > segmentReader.getSegmentInfo().getBufferedDeletesGen());
        segmentReader.getSegmentInfo().setBufferedDeletesGen(l);
    }

    private synchronized boolean commitMerge(MergePolicy.OneMerge oneMerge, SegmentReader segmentReader) throws IOException {
        boolean bl;
        assert (this.testPoint("startCommitMerge"));
        if (this.hitOOM) {
            throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot complete merge");
        }
        if (this.infoStream != null) {
            this.message("commitMerge: " + oneMerge.segString(this.directory) + " index=" + this.segString());
        }
        assert (oneMerge.registerDone);
        if (oneMerge.isAborted()) {
            if (this.infoStream != null) {
                this.message("commitMerge: skipping merge " + oneMerge.segString(this.directory) + ": it was aborted");
            }
            return false;
        }
        this.commitMergedDeletes(oneMerge, segmentReader);
        assert (!this.segmentInfos.contains(oneMerge.info));
        boolean bl2 = bl = segmentReader.numDocs() == 0;
        if (this.infoStream != null && bl) {
            this.message("merged segment " + oneMerge.info + " is 100% deleted" + (this.keepFullyDeletedSegments ? "" : "; skipping insert"));
        }
        boolean bl3 = bl && !this.keepFullyDeletedSegments;
        this.segmentInfos.applyMergeChanges(oneMerge, bl3);
        if (bl3) {
            this.readerPool.drop(oneMerge.info);
        }
        if (this.infoStream != null) {
            this.message("after commit: " + this.segString());
        }
        this.closeMergeReaders(oneMerge, false);
        this.checkpoint();
        this.readerPool.clear(oneMerge.segments);
        if (oneMerge.maxNumSegments != -1 && !this.segmentsToMerge.containsKey(oneMerge.info)) {
            this.segmentsToMerge.put(oneMerge.info, Boolean.FALSE);
        }
        return true;
    }

    private final void handleMergeException(Throwable throwable, MergePolicy.OneMerge oneMerge) throws IOException {
        if (this.infoStream != null) {
            this.message("handleMergeException: merge=" + oneMerge.segString(this.directory) + " exc=" + throwable);
        }
        oneMerge.setException(throwable);
        this.addMergeException(oneMerge);
        if (throwable instanceof MergePolicy.MergeAbortedException) {
            if (oneMerge.isExternal) {
                throw (MergePolicy.MergeAbortedException)throwable;
            }
        } else {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(MergePolicy.OneMerge oneMerge) throws CorruptIndexException, IOException {
        boolean bl = false;
        long l = System.currentTimeMillis();
        try {
            try {
                try {
                    this.mergeInit(oneMerge);
                    if (this.infoStream != null) {
                        this.message("now merge\n  merge=" + oneMerge.segString(this.directory) + "\n  merge=" + oneMerge + "\n  index=" + this.segString());
                    }
                    this.mergeMiddle(oneMerge);
                    this.mergeSuccess(oneMerge);
                    bl = true;
                }
                catch (Throwable throwable) {
                    this.handleMergeException(throwable, oneMerge);
                }
            }
            finally {
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    this.mergeFinish(oneMerge);
                    if (!bl) {
                        if (this.infoStream != null) {
                            this.message("hit exception during merge");
                        }
                        if (oneMerge.info != null && !this.segmentInfos.contains(oneMerge.info)) {
                            this.deleter.refresh(oneMerge.info.name);
                        }
                    }
                    if (bl && !oneMerge.isAborted() && (oneMerge.maxNumSegments != -1 || !this.closed && !this.closing)) {
                        this.updatePendingMerges(oneMerge.maxNumSegments);
                    }
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "merge");
        }
        if (this.infoStream != null && oneMerge.info != null) {
            this.message("merge time " + (System.currentTimeMillis() - l) + " msec for " + oneMerge.info.docCount + " docs");
        }
    }

    void mergeSuccess(MergePolicy.OneMerge oneMerge) {
    }

    final synchronized boolean registerMerge(MergePolicy.OneMerge oneMerge) throws MergePolicy.MergeAbortedException, IOException {
        if (oneMerge.registerDone) {
            return true;
        }
        if (this.stopMerges) {
            oneMerge.abort();
            throw new MergePolicy.MergeAbortedException("merge is aborted: " + oneMerge.segString(this.directory));
        }
        boolean bl = false;
        for (SegmentInfo segmentInfo : oneMerge.segments) {
            if (this.mergingSegments.contains(segmentInfo)) {
                return false;
            }
            if (!this.segmentInfos.contains(segmentInfo)) {
                return false;
            }
            if (segmentInfo.dir != this.directory) {
                bl = true;
            }
            if (!this.segmentsToMerge.containsKey(segmentInfo)) continue;
            oneMerge.maxNumSegments = this.mergeMaxNumSegments;
        }
        this.ensureValidMerge(oneMerge);
        this.pendingMerges.add(oneMerge);
        if (this.infoStream != null) {
            this.message("add merge to pendingMerges: " + oneMerge.segString(this.directory) + " [total " + this.pendingMerges.size() + " pending]");
        }
        oneMerge.mergeGen = this.mergeGen;
        oneMerge.isExternal = bl;
        this.message("registerMerge merging=" + this.mergingSegments);
        for (SegmentInfo segmentInfo : oneMerge.segments) {
            this.message("registerMerge info=" + segmentInfo);
            this.mergingSegments.add(segmentInfo);
        }
        oneMerge.registerDone = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void mergeInit(MergePolicy.OneMerge oneMerge) throws IOException {
        boolean bl = false;
        try {
            this._mergeInit(oneMerge);
            bl = true;
        }
        finally {
            if (!bl) {
                if (this.infoStream != null) {
                    this.message("hit exception in mergeInit");
                }
                this.mergeFinish(oneMerge);
            }
        }
    }

    private synchronized void _mergeInit(MergePolicy.OneMerge oneMerge) throws IOException {
        assert (this.testPoint("startMergeInit"));
        assert (oneMerge.registerDone);
        assert (oneMerge.maxNumSegments == -1 || oneMerge.maxNumSegments > 0);
        if (this.hitOOM) {
            throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot merge");
        }
        if (oneMerge.info != null) {
            return;
        }
        if (oneMerge.isAborted()) {
            return;
        }
        boolean bl = false;
        for (SegmentInfo cloneable2 : oneMerge.segments) {
            if (!cloneable2.getHasVectors()) continue;
            bl = true;
        }
        oneMerge.info = new SegmentInfo(this.newSegmentName(), 0, this.directory, false, true, false, bl);
        BufferedDeletesStream.ApplyDeletesResult applyDeletesResult = this.bufferedDeletesStream.applyDeletes(this.readerPool, oneMerge.segments);
        if (applyDeletesResult.anyDeletes) {
            this.checkpoint();
        }
        if (!this.keepFullyDeletedSegments && applyDeletesResult.allDeleted != null) {
            if (this.infoStream != null) {
                this.message("drop 100% deleted segments: " + applyDeletesResult.allDeleted);
            }
            for (SegmentInfo segmentInfo : applyDeletesResult.allDeleted) {
                this.segmentInfos.remove(segmentInfo);
                if (!oneMerge.segments.contains(segmentInfo)) continue;
                this.mergingSegments.remove(segmentInfo);
                oneMerge.segments.remove(segmentInfo);
            }
            if (this.readerPool != null) {
                this.readerPool.drop(applyDeletesResult.allDeleted);
            }
            this.checkpoint();
        }
        oneMerge.info.setBufferedDeletesGen(applyDeletesResult.gen);
        this.bufferedDeletesStream.prune(this.segmentInfos);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("mergeMaxNumSegments", "" + oneMerge.maxNumSegments);
        hashMap.put("mergeFactor", Integer.toString(oneMerge.segments.size()));
        this.setDiagnostics(oneMerge.info, "merge", hashMap);
        if (this.infoStream != null) {
            this.message("merge seg=" + oneMerge.info.name);
        }
        assert (oneMerge.estimatedMergeBytes == 0L);
        for (SegmentInfo segmentInfo : oneMerge.segments) {
            if (segmentInfo.docCount <= 0) continue;
            int n = this.numDeletedDocs(segmentInfo);
            assert (n <= segmentInfo.docCount);
            double d = (double)n / (double)segmentInfo.docCount;
            oneMerge.estimatedMergeBytes = (long)((double)oneMerge.estimatedMergeBytes + (double)segmentInfo.sizeInBytes(true) * (1.0 - d));
        }
        this.mergingSegments.add(oneMerge.info);
    }

    private void setDiagnostics(SegmentInfo segmentInfo, String string) {
        this.setDiagnostics(segmentInfo, string, null);
    }

    private void setDiagnostics(SegmentInfo segmentInfo, String string, Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("source", string);
        hashMap.put("lucene.version", Constants.LUCENE_VERSION);
        hashMap.put("os", Constants.OS_NAME);
        hashMap.put("os.arch", Constants.OS_ARCH);
        hashMap.put("os.version", Constants.OS_VERSION);
        hashMap.put("java.version", Constants.JAVA_VERSION);
        hashMap.put("java.vendor", Constants.JAVA_VENDOR);
        if (map != null) {
            hashMap.putAll(map);
        }
        segmentInfo.setDiagnostics(hashMap);
    }

    final synchronized void mergeFinish(MergePolicy.OneMerge oneMerge) throws IOException {
        this.notifyAll();
        if (oneMerge.registerDone) {
            List<SegmentInfo> list = oneMerge.segments;
            for (SegmentInfo segmentInfo : list) {
                this.mergingSegments.remove(segmentInfo);
            }
            this.mergingSegments.remove(oneMerge.info);
            oneMerge.registerDone = false;
        }
        this.runningMerges.remove(oneMerge);
    }

    private final synchronized void closeMergeReaders(MergePolicy.OneMerge oneMerge, boolean bl) throws IOException {
        int n = oneMerge.readers.size();
        Throwable throwable = null;
        boolean bl2 = false;
        boolean bl3 = !bl;
        for (int i = 0; i < n; ++i) {
            block13: {
                if (oneMerge.readers.get(i) != null) {
                    block12: {
                        try {
                            bl2 |= this.readerPool.release(oneMerge.readers.get(i), bl3);
                        }
                        catch (Throwable throwable2) {
                            if (throwable != null) break block12;
                            throwable = throwable2;
                        }
                    }
                    oneMerge.readers.set(i, null);
                }
                if (i >= oneMerge.readerClones.size() || oneMerge.readerClones.get(i) == null) continue;
                try {
                    oneMerge.readerClones.get(i).close();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block13;
                    throwable = throwable3;
                }
            }
            assert (oneMerge.readerClones.get(i).getRefCount() == 0) : "refCount should be 0 but is " + oneMerge.readerClones.get(i).getRefCount();
            oneMerge.readerClones.set(i, null);
        }
        if (bl && bl2) {
            this.checkpoint();
        }
        if (!bl && throwable != null) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final int mergeMiddle(MergePolicy.OneMerge oneMerge) throws CorruptIndexException, IOException {
        oneMerge.checkAborted(this.directory);
        String string = oneMerge.info.name;
        int n = 0;
        List<SegmentInfo> list = oneMerge.segments;
        SegmentMerger segmentMerger = new SegmentMerger(this.directory, this.config.getTermIndexInterval(), string, oneMerge, this.payloadProcessorProvider, (FieldInfos)this.docWriter.getFieldInfos().clone());
        if (this.infoStream != null) {
            this.message("merging " + oneMerge.segString(this.directory) + " mergeVectors=" + oneMerge.info.getHasVectors());
        }
        oneMerge.readers = new ArrayList<SegmentReader>();
        oneMerge.readerClones = new ArrayList<SegmentReader>();
        boolean bl = false;
        try {
            void var11_23;
            boolean bl2;
            Object object;
            int n2 = 0;
            for (int i = 0; i < list.size(); ++i) {
                SegmentInfo segmentInfo = list.get(i);
                object = this.readerPool.get(segmentInfo, true, 4096, -1);
                oneMerge.readers.add((SegmentReader)object);
                SegmentReader segmentReader = (SegmentReader)((SegmentReader)object).clone(true);
                oneMerge.readerClones.add(segmentReader);
                if (segmentReader.numDocs() <= 0) continue;
                segmentMerger.add(segmentReader);
                n2 += segmentReader.numDocs();
            }
            if (this.infoStream != null) {
                this.message("merge: total " + n2 + " docs");
            }
            oneMerge.checkAborted(this.directory);
            n = oneMerge.info.docCount = segmentMerger.merge();
            oneMerge.info.setHasVectors(segmentMerger.fieldInfos().hasVectors());
            assert (n == n2);
            if (this.infoStream != null) {
                this.message("merge store matchedCount=" + segmentMerger.getMatchedSubReaderCount() + " vs " + oneMerge.readers.size());
            }
            this.anyNonBulkMerges |= segmentMerger.getAnyNonBulkMerges();
            assert (n == n2) : "mergedDocCount=" + n + " vs " + n2;
            oneMerge.info.setHasProx(segmentMerger.fieldInfos().hasProx());
            object = this;
            // MONITORENTER : object
            boolean bl3 = this.mergePolicy.useCompoundFile(this.segmentInfos, oneMerge.info);
            // MONITOREXIT : object
            if (bl3) {
                block56: {
                    bl = false;
                    object = IndexFileNames.segmentFileName(string, "cfs");
                    try {
                        if (this.infoStream != null) {
                            this.message("create compound file " + (String)object);
                        }
                        segmentMerger.createCompoundFile((String)object, oneMerge.info);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        IndexWriter indexWriter = this;
                        // MONITORENTER : indexWriter
                        if (!oneMerge.isAborted()) {
                            this.handleMergeException(iOException, oneMerge);
                        }
                        // MONITOREXIT : indexWriter
                    }
                    catch (Throwable throwable) {
                        this.handleMergeException(throwable, oneMerge);
                        if (bl) break block56;
                        if (this.infoStream != null) {
                            this.message("hit exception creating compound file during merge");
                        }
                        IndexWriter indexWriter = this;
                        this.deleter.deleteFile((String)object);
                        this.deleter.deleteNewFiles(oneMerge.info.files());
                        // MONITOREXIT : indexWriter
                    }
                    finally {
                        if (bl) {
                        }
                        if (this.infoStream != null) {
                            this.message("hit exception creating compound file during merge");
                        }
                        IndexWriter indexWriter = this;
                    }
                }
                bl = false;
                IndexWriter indexWriter = this;
                // MONITORENTER : indexWriter
                this.deleter.deleteNewFiles(oneMerge.info.files());
                if (oneMerge.isAborted()) {
                    if (this.infoStream != null) {
                        this.message("abort merge after building CFS");
                    }
                    this.deleter.deleteFile((String)object);
                    int n3 = 0;
                    // MONITOREXIT : indexWriter
                    return n3;
                }
                // MONITOREXIT : indexWriter
                oneMerge.info.setUseCompoundFile(true);
            }
            if (this.infoStream != null) {
                this.message(String.format("merged segment size=%.3f MB vs estimate=%.3f MB", (double)oneMerge.info.sizeInBytes(true) / 1024.0 / 1024.0, (double)(oneMerge.estimatedMergeBytes / 1024L) / 1024.0));
            }
            if ((object = this.config.getMergedSegmentWarmer()) != null) {
                int n4 = this.config.getReaderTermsIndexDivisor();
                bl2 = true;
            } else {
                int n5 = -1;
                bl2 = false;
            }
            SegmentReader segmentReader = this.readerPool.get(oneMerge.info, bl2, 1024, (int)var11_23);
            try {
                if (this.poolReaders && object != null) {
                    ((IndexReaderWarmer)object).warm(segmentReader);
                }
                if (!this.commitMerge(oneMerge, segmentReader)) {
                    int n6 = 0;
                    return n6;
                }
            }
            finally {
                IndexWriter indexWriter = this;
            }
            bl = true;
            return n;
        }
        finally {
            if (!bl) {
                this.closeMergeReaders(oneMerge, true);
            }
        }
    }

    synchronized void addMergeException(MergePolicy.OneMerge oneMerge) {
        assert (oneMerge.getException() != null);
        if (!this.mergeExceptions.contains(oneMerge) && this.mergeGen == oneMerge.mergeGen) {
            this.mergeExceptions.add(oneMerge);
        }
    }

    final int getBufferedDeleteTermsSize() {
        return this.docWriter.getPendingDeletes().terms.size();
    }

    final int getNumBufferedDeleteTerms() {
        return this.docWriter.getPendingDeletes().numTermDeletes.get();
    }

    synchronized SegmentInfo newestSegment() {
        return this.segmentInfos.size() > 0 ? this.segmentInfos.info(this.segmentInfos.size() - 1) : null;
    }

    public synchronized String segString() throws IOException {
        return this.segString(this.segmentInfos);
    }

    public synchronized String segString(Iterable<SegmentInfo> iterable) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (SegmentInfo segmentInfo : iterable) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.segString(segmentInfo));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String segString(SegmentInfo segmentInfo) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        SegmentReader segmentReader = this.readerPool.getIfExists(segmentInfo);
        try {
            if (segmentReader != null) {
                stringBuilder.append(segmentReader.toString());
            } else {
                stringBuilder.append(segmentInfo.toString(this.directory, 0));
                if (segmentInfo.dir != this.directory) {
                    stringBuilder.append("**");
                }
            }
        }
        finally {
            if (segmentReader != null) {
                this.readerPool.release(segmentReader);
            }
        }
        return stringBuilder.toString();
    }

    private synchronized void doWait() {
        try {
            this.wait(1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException(interruptedException);
        }
    }

    void keepFullyDeletedSegments() {
        this.keepFullyDeletedSegments = true;
    }

    boolean getKeepFullyDeletedSegments() {
        return this.keepFullyDeletedSegments;
    }

    private boolean filesExist(SegmentInfos segmentInfos) throws IOException {
        Collection<String> collection = segmentInfos.files(this.directory, false);
        for (String string : collection) {
            assert (this.directory.fileExists(string)) : "file " + string + " does not exist";
            assert (this.deleter.exists(string)) : "IndexFileDeleter doesn't know about file " + string;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCommit(SegmentInfos segmentInfos, Map<String, String> map) throws IOException {
        assert (this.testPoint("startStartCommit"));
        assert (this.pendingCommit == null);
        if (this.hitOOM) {
            throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot commit");
        }
        try {
            IndexWriter indexWriter;
            if (this.infoStream != null) {
                this.message("startCommit(): start");
            }
            IndexWriter indexWriter2 = this;
            synchronized (indexWriter2) {
                assert (this.lastCommitChangeCount <= this.changeCount);
                if (this.pendingCommitChangeCount == this.lastCommitChangeCount) {
                    if (this.infoStream != null) {
                        this.message("  skip startCommit(): no changes pending");
                    }
                    this.deleter.decRef(segmentInfos);
                    return;
                }
                if (this.infoStream != null) {
                    this.message("startCommit index=" + this.segString(segmentInfos) + " changeCount=" + this.changeCount);
                }
                assert (this.filesExist(segmentInfos));
                if (map != null) {
                    segmentInfos.setUserData(map);
                }
            }
            assert (this.testPoint("midStartCommit"));
            boolean bl = false;
            try {
                this.directory.sync(segmentInfos.files(this.directory, false));
                assert (this.testPoint("midStartCommit2"));
                indexWriter = this;
                synchronized (indexWriter) {
                    assert (this.pendingCommit == null);
                    assert (this.segmentInfos.getGeneration() == segmentInfos.getGeneration());
                    segmentInfos.prepareCommit(this.directory);
                    bl = true;
                    this.pendingCommit = segmentInfos;
                }
                if (this.infoStream != null) {
                    this.message("done all syncs");
                }
                assert (this.testPoint("midStartCommitSuccess"));
            }
            finally {
                indexWriter = this;
                synchronized (indexWriter) {
                    this.segmentInfos.updateGeneration(segmentInfos);
                    if (!bl) {
                        if (this.infoStream != null) {
                            this.message("hit exception committing segments file");
                        }
                        this.deleter.decRef(segmentInfos);
                    }
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOOM(outOfMemoryError, "startCommit");
        }
        assert (this.testPoint("finishStartCommit"));
    }

    public static boolean isLocked(Directory directory) throws IOException {
        return directory.makeLock(WRITE_LOCK_NAME).isLocked();
    }

    public static void unlock(Directory directory) throws IOException {
        directory.makeLock(WRITE_LOCK_NAME).release();
    }

    @Deprecated
    public void setMergedSegmentWarmer(IndexReaderWarmer indexReaderWarmer) {
        this.config.setMergedSegmentWarmer(indexReaderWarmer);
    }

    @Deprecated
    public IndexReaderWarmer getMergedSegmentWarmer() {
        return this.config.getMergedSegmentWarmer();
    }

    private void handleOOM(OutOfMemoryError outOfMemoryError, String string) {
        if (this.infoStream != null) {
            this.message("hit OutOfMemoryError inside " + string);
        }
        this.hitOOM = true;
        throw outOfMemoryError;
    }

    boolean testPoint(String string) {
        return true;
    }

    synchronized boolean nrtIsCurrent(SegmentInfos segmentInfos) {
        this.ensureOpen();
        return segmentInfos.version == this.segmentInfos.version && !this.docWriter.anyChanges() && !this.bufferedDeletesStream.any();
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void deleteUnusedFiles() throws IOException {
        this.ensureOpen(false);
        this.deleter.deletePendingFiles();
        this.deleter.revisitPolicy();
    }

    synchronized void deletePendingFiles() throws IOException {
        this.deleter.deletePendingFiles();
    }

    public void setPayloadProcessorProvider(PayloadProcessorProvider payloadProcessorProvider) {
        this.ensureOpen();
        this.payloadProcessorProvider = payloadProcessorProvider;
    }

    public PayloadProcessorProvider getPayloadProcessorProvider() {
        this.ensureOpen();
        return this.payloadProcessorProvider;
    }

    final class FlushControl {
        private boolean flushPending;
        private boolean flushDeletes;
        private int delCount;
        private int docCount;
        private boolean flushing;

        FlushControl() {
        }

        private synchronized boolean setFlushPending(String string, boolean bl) {
            if (this.flushPending || this.flushing) {
                if (bl) {
                    while (this.flushPending || this.flushing) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw new ThreadInterruptedException(interruptedException);
                        }
                    }
                }
                return false;
            }
            if (IndexWriter.this.infoStream != null) {
                IndexWriter.this.message("now trigger flush reason=" + string);
            }
            this.flushPending = true;
            return this.flushPending;
        }

        public synchronized void setFlushPendingNoWait(String string) {
            this.setFlushPending(string, false);
        }

        public synchronized boolean getFlushPending() {
            return this.flushPending;
        }

        public synchronized boolean getFlushDeletes() {
            return this.flushDeletes;
        }

        public synchronized void clearFlushPending() {
            if (IndexWriter.this.infoStream != null) {
                IndexWriter.this.message("clearFlushPending");
            }
            this.flushPending = false;
            this.flushDeletes = false;
            this.docCount = 0;
            this.notifyAll();
        }

        public synchronized void clearDeletes() {
            this.delCount = 0;
        }

        public synchronized boolean waitUpdate(int n, int n2) {
            return this.waitUpdate(n, n2, false);
        }

        public synchronized boolean waitUpdate(int n, int n2, boolean bl) {
            while (this.flushPending) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new ThreadInterruptedException(interruptedException);
                }
            }
            this.docCount += n;
            this.delCount += n2;
            if (bl) {
                return false;
            }
            int n3 = IndexWriter.this.config.getMaxBufferedDocs();
            if (n3 != -1 && this.docCount >= n3) {
                return this.setFlushPending("maxBufferedDocs", true);
            }
            int n4 = IndexWriter.this.config.getMaxBufferedDeleteTerms();
            if (n4 != -1 && this.delCount >= n4) {
                this.flushDeletes = true;
                return this.setFlushPending("maxBufferedDeleteTerms", true);
            }
            return this.flushByRAMUsage("add delete/doc");
        }

        public synchronized boolean flushByRAMUsage(String string) {
            double d = IndexWriter.this.config.getRAMBufferSizeMB();
            if (d != -1.0) {
                long l = (long)(d * 1024.0 * 1024.0);
                long l2 = IndexWriter.this.bufferedDeletesStream.bytesUsed() + IndexWriter.this.docWriter.bytesUsed();
                if (l2 >= l) {
                    IndexWriter.this.docWriter.balanceRAM();
                    l2 = IndexWriter.this.bufferedDeletesStream.bytesUsed() + IndexWriter.this.docWriter.bytesUsed();
                    if (l2 >= l) {
                        return this.setFlushPending("ram full: " + string, false);
                    }
                }
            }
            return false;
        }
    }

    public static abstract class IndexReaderWarmer {
        public abstract void warm(IndexReader var1) throws IOException;
    }

    @Deprecated
    public static final class MaxFieldLength {
        private int limit;
        private String name;
        public static final MaxFieldLength UNLIMITED = new MaxFieldLength("UNLIMITED", Integer.MAX_VALUE);
        public static final MaxFieldLength LIMITED = new MaxFieldLength("LIMITED", 10000);

        private MaxFieldLength(String string, int n) {
            this.name = string;
            this.limit = n;
        }

        public MaxFieldLength(int n) {
            this("User-specified", n);
        }

        public int getLimit() {
            return this.limit;
        }

        public String toString() {
            return this.name + ":" + this.limit;
        }
    }

    class ReaderPool {
        private final Map<SegmentInfo, SegmentReader> readerMap = new HashMap<SegmentInfo, SegmentReader>();

        ReaderPool() {
        }

        synchronized void clear(List<SegmentInfo> list) throws IOException {
            if (list == null) {
                for (Map.Entry<SegmentInfo, SegmentReader> entry : this.readerMap.entrySet()) {
                    entry.getValue().hasChanges = false;
                }
            } else {
                for (SegmentInfo segmentInfo : list) {
                    SegmentReader segmentReader = this.readerMap.get(segmentInfo);
                    if (segmentReader == null) continue;
                    segmentReader.hasChanges = false;
                }
            }
        }

        public synchronized boolean infoIsLive(SegmentInfo segmentInfo) {
            int n = IndexWriter.this.segmentInfos.indexOf(segmentInfo);
            assert (n != -1) : "info=" + segmentInfo + " isn't in pool";
            assert (IndexWriter.this.segmentInfos.info(n) == segmentInfo) : "info=" + segmentInfo + " doesn't match live info in segmentInfos";
            return true;
        }

        public synchronized SegmentInfo mapToLive(SegmentInfo segmentInfo) {
            int n = IndexWriter.this.segmentInfos.indexOf(segmentInfo);
            if (n != -1) {
                segmentInfo = IndexWriter.this.segmentInfos.info(n);
            }
            return segmentInfo;
        }

        public synchronized boolean release(SegmentReader segmentReader) throws IOException {
            return this.release(segmentReader, false);
        }

        public synchronized boolean release(SegmentReader segmentReader, boolean bl) throws IOException {
            boolean bl2 = this.readerMap.containsKey(segmentReader.getSegmentInfo());
            assert (!bl2 || this.readerMap.get(segmentReader.getSegmentInfo()) == segmentReader);
            segmentReader.decRef();
            if (bl2 && (bl || !IndexWriter.this.poolReaders && segmentReader.getRefCount() == 1)) {
                assert (!segmentReader.hasChanges || Thread.holdsLock(IndexWriter.this));
                boolean bl3 = segmentReader.hasChanges = segmentReader.hasChanges & !bl;
                segmentReader.close();
                this.readerMap.remove(segmentReader.getSegmentInfo());
                return bl3;
            }
            return false;
        }

        public synchronized void drop(List<SegmentInfo> list) throws IOException {
            for (SegmentInfo segmentInfo : list) {
                this.drop(segmentInfo);
            }
        }

        public synchronized void drop(SegmentInfo segmentInfo) throws IOException {
            SegmentReader segmentReader = this.readerMap.get(segmentInfo);
            if (segmentReader != null) {
                segmentReader.hasChanges = false;
                this.readerMap.remove(segmentInfo);
                segmentReader.close();
            }
        }

        public synchronized void dropAll() throws IOException {
            for (SegmentReader segmentReader : this.readerMap.values()) {
                segmentReader.hasChanges = false;
                segmentReader.decRef();
            }
            this.readerMap.clear();
        }

        synchronized void close() throws IOException {
            assert (Thread.holdsLock(IndexWriter.this));
            for (Map.Entry<SegmentInfo, SegmentReader> entry : this.readerMap.entrySet()) {
                SegmentReader segmentReader = entry.getValue();
                if (segmentReader.hasChanges) {
                    assert (this.infoIsLive(segmentReader.getSegmentInfo()));
                    segmentReader.doCommit(null);
                    IndexWriter.this.deleter.checkpoint(IndexWriter.this.segmentInfos, false);
                }
                segmentReader.decRef();
            }
            this.readerMap.clear();
        }

        synchronized void commit(SegmentInfos segmentInfos) throws IOException {
            assert (Thread.holdsLock(IndexWriter.this));
            for (SegmentInfo segmentInfo : segmentInfos) {
                SegmentReader segmentReader = this.readerMap.get(segmentInfo);
                if (segmentReader == null || !segmentReader.hasChanges) continue;
                assert (this.infoIsLive(segmentInfo));
                segmentReader.doCommit(null);
                IndexWriter.this.deleter.checkpoint(IndexWriter.this.segmentInfos, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized SegmentReader getReadOnlyClone(SegmentInfo segmentInfo, boolean bl, int n) throws IOException {
            SegmentReader segmentReader = this.get(segmentInfo, bl, 1024, n);
            try {
                SegmentReader segmentReader2 = (SegmentReader)segmentReader.clone(true);
                return segmentReader2;
            }
            finally {
                segmentReader.decRef();
            }
        }

        public synchronized SegmentReader get(SegmentInfo segmentInfo, boolean bl) throws IOException {
            return this.get(segmentInfo, bl, 1024, IndexWriter.this.config.getReaderTermsIndexDivisor());
        }

        public synchronized SegmentReader get(SegmentInfo segmentInfo, boolean bl, int n, int n2) throws IOException {
            SegmentReader segmentReader;
            if (IndexWriter.this.poolReaders) {
                n = 1024;
            }
            if ((segmentReader = this.readerMap.get(segmentInfo)) == null) {
                segmentReader = SegmentReader.get(false, segmentInfo.dir, segmentInfo, n, bl, n2);
                segmentReader.readerFinishedListeners = IndexWriter.this.readerFinishedListeners;
                if (segmentInfo.dir == IndexWriter.this.directory) {
                    this.readerMap.put(segmentInfo, segmentReader);
                }
            } else {
                if (bl) {
                    segmentReader.openDocStores();
                }
                if (n2 != -1 && !segmentReader.termsIndexLoaded()) {
                    segmentReader.loadTermsIndex(n2);
                }
            }
            if (segmentInfo.dir == IndexWriter.this.directory) {
                segmentReader.incRef();
            }
            return segmentReader;
        }

        public synchronized SegmentReader getIfExists(SegmentInfo segmentInfo) throws IOException {
            SegmentReader segmentReader = this.readerMap.get(segmentInfo);
            if (segmentReader != null) {
                segmentReader.incRef();
            }
            return segmentReader;
        }
    }
}

