/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.AllTermDocs;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.ReadOnlySegmentReader;
import org.apache.lucene.index.SegmentCoreReaders;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentNorms;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorsReader;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BitVector;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.StringHelper;

public class SegmentReader
extends IndexReader
implements Cloneable {
    protected boolean readOnly;
    private SegmentInfo si;
    private int readBufferSize;
    CloseableThreadLocal<FieldsReader> fieldsReaderLocal = new FieldsReaderLocal();
    CloseableThreadLocal<TermVectorsReader> termVectorsLocal = new CloseableThreadLocal();
    BitVector deletedDocs = null;
    AtomicInteger deletedDocsRef = null;
    private boolean deletedDocsDirty = false;
    private boolean normsDirty = false;
    private int pendingDeleteCount;
    private boolean rollbackHasChanges = false;
    private boolean rollbackDeletedDocsDirty = false;
    private boolean rollbackNormsDirty = false;
    private SegmentInfo rollbackSegmentInfo;
    private int rollbackPendingDeleteCount;
    IndexInput singleNormStream;
    AtomicInteger singleNormRef;
    SegmentCoreReaders core;
    Map<String, SegmentNorms> norms = new HashMap<String, SegmentNorms>();

    public static SegmentReader get(boolean bl, SegmentInfo segmentInfo, int n) throws CorruptIndexException, IOException {
        return SegmentReader.get(bl, segmentInfo.dir, segmentInfo, 1024, true, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SegmentReader get(boolean bl, Directory directory, SegmentInfo segmentInfo, int n, boolean bl2, int n2) throws CorruptIndexException, IOException {
        SegmentReader segmentReader = bl ? new ReadOnlySegmentReader() : new SegmentReader();
        segmentReader.readOnly = bl;
        segmentReader.si = segmentInfo;
        segmentReader.readBufferSize = n;
        boolean bl3 = false;
        try {
            segmentReader.core = new SegmentCoreReaders(segmentReader, directory, segmentInfo, n, n2);
            if (bl2) {
                segmentReader.core.openDocStores(segmentInfo);
            }
            segmentReader.loadDeletedDocs();
            segmentReader.openNorms(segmentReader.core.cfsDir, n);
            bl3 = true;
        }
        finally {
            if (!bl3) {
                segmentReader.doClose();
            }
        }
        return segmentReader;
    }

    void openDocStores() throws IOException {
        this.core.openDocStores(this.si);
    }

    private boolean checkDeletedCounts() throws IOException {
        int n = this.deletedDocs.getRecomputedCount();
        assert (this.deletedDocs.count() == n) : "deleted count=" + this.deletedDocs.count() + " vs recomputed count=" + n;
        assert (this.si.getDelCount() == n) : "delete count mismatch: info=" + this.si.getDelCount() + " vs BitVector=" + n;
        assert (this.si.getDelCount() <= this.maxDoc()) : "delete count mismatch: " + n + ") exceeds max doc (" + this.maxDoc() + ") for segment " + this.si.name;
        return true;
    }

    private void loadDeletedDocs() throws IOException {
        if (SegmentReader.hasDeletions(this.si)) {
            this.deletedDocs = new BitVector(this.directory(), this.si.getDelFileName());
            this.deletedDocsRef = new AtomicInteger(1);
            assert (this.checkDeletedCounts());
            if (this.deletedDocs.size() != this.si.docCount) {
                throw new CorruptIndexException("document count mismatch: deleted docs count " + this.deletedDocs.size() + " vs segment doc count " + this.si.docCount + " segment=" + this.si.name);
            }
        } else assert (this.si.getDelCount() == 0);
    }

    protected byte[] cloneNormBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    protected BitVector cloneDeletedDocs(BitVector bitVector) {
        this.ensureOpen();
        return (BitVector)bitVector.clone();
    }

    @Override
    public final synchronized Object clone() {
        try {
            return this.clone(this.readOnly);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public final synchronized IndexReader clone(boolean bl) throws CorruptIndexException, IOException {
        return this.reopenSegment(this.si, true, bl);
    }

    @Override
    protected synchronized IndexReader doOpenIfChanged() throws CorruptIndexException, IOException {
        return this.reopenSegment(this.si, false, this.readOnly);
    }

    @Override
    protected synchronized IndexReader doOpenIfChanged(boolean bl) throws CorruptIndexException, IOException {
        return this.reopenSegment(this.si, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized SegmentReader reopenSegment(SegmentInfo segmentInfo, boolean bl, boolean bl2) throws CorruptIndexException, IOException {
        this.ensureOpen();
        boolean bl3 = this.si.hasDeletions() == segmentInfo.hasDeletions() && (!segmentInfo.hasDeletions() || this.si.getDelFileName().equals(segmentInfo.getDelFileName()));
        boolean bl4 = true;
        boolean[] blArray = new boolean[this.core.fieldInfos.size()];
        int n = this.core.fieldInfos.size();
        for (int i = 0; i < n; ++i) {
            if (this.si.getNormFileName(i).equals(segmentInfo.getNormFileName(i))) continue;
            bl4 = false;
            blArray[i] = true;
        }
        if (bl4 && bl3 && !bl && bl2 && this.readOnly) {
            return null;
        }
        assert (!bl || bl4 && bl3);
        SegmentReader segmentReader = bl2 ? new ReadOnlySegmentReader() : new SegmentReader();
        boolean bl5 = false;
        try {
            this.core.incRef();
            segmentReader.core = this.core;
            segmentReader.readOnly = bl2;
            segmentReader.si = segmentInfo;
            segmentReader.readBufferSize = this.readBufferSize;
            segmentReader.pendingDeleteCount = this.pendingDeleteCount;
            segmentReader.readerFinishedListeners = this.readerFinishedListeners;
            if (!bl2 && this.hasChanges) {
                segmentReader.deletedDocsDirty = this.deletedDocsDirty;
                segmentReader.normsDirty = this.normsDirty;
                segmentReader.hasChanges = this.hasChanges;
                this.hasChanges = false;
            }
            if (bl) {
                if (this.deletedDocs != null) {
                    this.deletedDocsRef.incrementAndGet();
                    segmentReader.deletedDocs = this.deletedDocs;
                    segmentReader.deletedDocsRef = this.deletedDocsRef;
                }
            } else if (!bl3) {
                assert (segmentReader.deletedDocs == null);
                segmentReader.loadDeletedDocs();
            } else if (this.deletedDocs != null) {
                this.deletedDocsRef.incrementAndGet();
                segmentReader.deletedDocs = this.deletedDocs;
                segmentReader.deletedDocsRef = this.deletedDocsRef;
            }
            segmentReader.norms = new HashMap<String, SegmentNorms>();
            for (int i = 0; i < blArray.length; ++i) {
                String string;
                SegmentNorms segmentNorms;
                if (!bl && blArray[i] || (segmentNorms = this.norms.get(string = this.core.fieldInfos.fieldInfo((int)i).name)) == null) continue;
                segmentReader.norms.put(string, (SegmentNorms)segmentNorms.clone());
            }
            segmentReader.openNorms(segmentInfo.getUseCompoundFile() ? this.core.getCFSReader() : this.directory(), this.readBufferSize);
            bl5 = true;
        }
        finally {
            if (!bl5) {
                segmentReader.decRef();
            }
        }
        return segmentReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCommit(Map<String, String> map) throws IOException {
        if (this.hasChanges) {
            this.startCommit();
            boolean bl = false;
            try {
                this.commitChanges(map);
                bl = true;
            }
            finally {
                if (!bl) {
                    this.rollbackCommit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void commitChanges(Map<String, String> map) throws IOException {
        if (this.deletedDocsDirty) {
            this.si.advanceDelGen();
            assert (this.deletedDocs.size() == this.si.docCount);
            String string = this.si.getDelFileName();
            boolean bl = false;
            try {
                this.deletedDocs.write(this.directory(), string);
                bl = true;
            }
            finally {
                if (!bl) {
                    try {
                        this.directory().deleteFile(string);
                    }
                    catch (Throwable throwable) {}
                }
            }
            this.si.setDelCount(this.si.getDelCount() + this.pendingDeleteCount);
            this.pendingDeleteCount = 0;
            assert (this.deletedDocs.count() == this.si.getDelCount()) : "delete count mismatch during commit: info=" + this.si.getDelCount() + " vs BitVector=" + this.deletedDocs.count();
        } else assert (this.pendingDeleteCount == 0);
        if (this.normsDirty) {
            this.si.setNumFields(this.core.fieldInfos.size());
            for (SegmentNorms segmentNorms : this.norms.values()) {
                if (!segmentNorms.dirty) continue;
                segmentNorms.reWrite(this.si);
            }
        }
        this.deletedDocsDirty = false;
        this.normsDirty = false;
        this.hasChanges = false;
    }

    FieldsReader getFieldsReader() {
        return this.fieldsReaderLocal.get();
    }

    @Override
    protected void doClose() throws IOException {
        this.termVectorsLocal.close();
        this.fieldsReaderLocal.close();
        if (this.deletedDocs != null) {
            this.deletedDocsRef.decrementAndGet();
            this.deletedDocs = null;
        }
        for (SegmentNorms segmentNorms : this.norms.values()) {
            segmentNorms.decRef();
        }
        if (this.core != null) {
            this.core.decRef();
        }
    }

    static boolean hasDeletions(SegmentInfo segmentInfo) throws IOException {
        return segmentInfo.hasDeletions();
    }

    @Override
    public boolean hasDeletions() {
        return this.deletedDocs != null;
    }

    static boolean usesCompoundFile(SegmentInfo segmentInfo) throws IOException {
        return segmentInfo.getUseCompoundFile();
    }

    static boolean hasSeparateNorms(SegmentInfo segmentInfo) throws IOException {
        return segmentInfo.hasSeparateNorms();
    }

    @Override
    protected void doDelete(int n) {
        if (this.deletedDocs == null) {
            this.deletedDocs = new BitVector(this.maxDoc());
            this.deletedDocsRef = new AtomicInteger(1);
        }
        if (this.deletedDocsRef.get() > 1) {
            AtomicInteger atomicInteger = this.deletedDocsRef;
            this.deletedDocs = this.cloneDeletedDocs(this.deletedDocs);
            this.deletedDocsRef = new AtomicInteger(1);
            atomicInteger.decrementAndGet();
        }
        this.deletedDocsDirty = true;
        if (!this.deletedDocs.getAndSet(n)) {
            ++this.pendingDeleteCount;
        }
    }

    @Override
    protected void doUndeleteAll() {
        this.deletedDocsDirty = false;
        if (this.deletedDocs != null) {
            assert (this.deletedDocsRef != null);
            this.deletedDocsRef.decrementAndGet();
            this.deletedDocs = null;
            this.deletedDocsRef = null;
            this.pendingDeleteCount = 0;
            this.si.clearDelGen();
            this.si.setDelCount(0);
        } else {
            assert (this.deletedDocsRef == null);
            assert (this.pendingDeleteCount == 0);
        }
    }

    List<String> files() throws IOException {
        return new ArrayList<String>(this.si.files());
    }

    @Override
    public TermEnum terms() {
        this.ensureOpen();
        return this.core.getTermsReader().terms();
    }

    @Override
    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        return this.core.getTermsReader().terms(term);
    }

    FieldInfos fieldInfos() {
        return this.core.fieldInfos;
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (n < 0 || n >= this.maxDoc()) {
            throw new IllegalArgumentException("docID must be >= 0 and < maxDoc=" + this.maxDoc() + " (got docID=" + n + ")");
        }
        return this.getFieldsReader().doc(n, fieldSelector);
    }

    @Override
    public synchronized boolean isDeleted(int n) {
        return this.deletedDocs != null && this.deletedDocs.get(n);
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        if (term == null) {
            return new AllTermDocs(this);
        }
        return super.termDocs(term);
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new SegmentTermDocs(this);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new SegmentTermPositions(this);
    }

    @Override
    public int docFreq(Term term) throws IOException {
        this.ensureOpen();
        TermInfo termInfo = this.core.getTermsReader().get(term);
        if (termInfo != null) {
            return termInfo.docFreq;
        }
        return 0;
    }

    @Override
    public int numDocs() {
        int n = this.maxDoc();
        if (this.deletedDocs != null) {
            n -= this.deletedDocs.count();
        }
        return n;
    }

    @Override
    public int maxDoc() {
        return this.si.docCount;
    }

    @Override
    public Collection<String> getFieldNames(IndexReader.FieldOption fieldOption) {
        this.ensureOpen();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.core.fieldInfos.size(); ++i) {
            FieldInfo fieldInfo = this.core.fieldInfos.fieldInfo(i);
            if (fieldOption == IndexReader.FieldOption.ALL) {
                hashSet.add(fieldInfo.name);
                continue;
            }
            if (!fieldInfo.isIndexed && fieldOption == IndexReader.FieldOption.UNINDEXED) {
                hashSet.add(fieldInfo.name);
                continue;
            }
            if (fieldInfo.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY && fieldOption == IndexReader.FieldOption.OMIT_TERM_FREQ_AND_POSITIONS) {
                hashSet.add(fieldInfo.name);
                continue;
            }
            if (fieldInfo.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS && fieldOption == IndexReader.FieldOption.OMIT_POSITIONS) {
                hashSet.add(fieldInfo.name);
                continue;
            }
            if (fieldInfo.storePayloads && fieldOption == IndexReader.FieldOption.STORES_PAYLOADS) {
                hashSet.add(fieldInfo.name);
                continue;
            }
            if (fieldInfo.isIndexed && fieldOption == IndexReader.FieldOption.INDEXED) {
                hashSet.add(fieldInfo.name);
                continue;
            }
            if (fieldInfo.isIndexed && !fieldInfo.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_NO_TERMVECTOR) {
                hashSet.add(fieldInfo.name);
                continue;
            }
            if (fieldInfo.storeTermVector && !fieldInfo.storePositionWithTermVector && !fieldInfo.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR) {
                hashSet.add(fieldInfo.name);
                continue;
            }
            if (fieldInfo.isIndexed && fieldInfo.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_WITH_TERMVECTOR) {
                hashSet.add(fieldInfo.name);
                continue;
            }
            if (fieldInfo.storePositionWithTermVector && !fieldInfo.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_POSITION) {
                hashSet.add(fieldInfo.name);
                continue;
            }
            if (fieldInfo.storeOffsetWithTermVector && !fieldInfo.storePositionWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET) {
                hashSet.add(fieldInfo.name);
                continue;
            }
            if (!fieldInfo.storeOffsetWithTermVector || !fieldInfo.storePositionWithTermVector || fieldOption != IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET) continue;
            hashSet.add(fieldInfo.name);
        }
        return hashSet;
    }

    @Override
    public boolean hasNorms(String string) {
        this.ensureOpen();
        return this.norms.containsKey(string);
    }

    @Override
    public byte[] norms(String string) throws IOException {
        this.ensureOpen();
        SegmentNorms segmentNorms = this.norms.get(string);
        if (segmentNorms == null) {
            return null;
        }
        return segmentNorms.bytes();
    }

    @Override
    protected void doSetNorm(int n, String string, byte by) throws IOException {
        SegmentNorms segmentNorms = this.norms.get(string);
        if (segmentNorms == null) {
            throw new IllegalStateException("Cannot setNorm for field " + string + ": norms were omitted");
        }
        this.normsDirty = true;
        segmentNorms.copyOnWrite()[n] = by;
    }

    @Override
    public synchronized void norms(String string, byte[] byArray, int n) throws IOException {
        this.ensureOpen();
        SegmentNorms segmentNorms = this.norms.get(string);
        if (segmentNorms == null) {
            Arrays.fill(byArray, n, byArray.length, Similarity.getDefault().encodeNormValue(1.0f));
            return;
        }
        segmentNorms.bytes(byArray, n, this.maxDoc());
    }

    int getPostingsSkipInterval() {
        return this.core.getTermsReader().getSkipInterval();
    }

    private void openNorms(Directory directory, int n) throws IOException {
        long l = SegmentNorms.NORMS_HEADER.length;
        int n2 = this.maxDoc();
        for (int i = 0; i < this.core.fieldInfos.size(); ++i) {
            long l2;
            FieldInfo fieldInfo = this.core.fieldInfos.fieldInfo(i);
            if (this.norms.containsKey(fieldInfo.name) || !fieldInfo.isIndexed || fieldInfo.omitNorms) continue;
            Directory directory2 = this.directory();
            String string = this.si.getNormFileName(fieldInfo.number);
            if (!this.si.hasSeparateNorms(fieldInfo.number)) {
                directory2 = directory;
            }
            boolean bl = IndexFileNames.matchesExtension(string, "nrm");
            IndexInput indexInput = null;
            if (bl) {
                l2 = l;
                if (this.singleNormStream == null) {
                    this.singleNormStream = directory2.openInput(string, n);
                    this.singleNormRef = new AtomicInteger(1);
                } else {
                    this.singleNormRef.incrementAndGet();
                }
                indexInput = this.singleNormStream;
            } else {
                indexInput = directory2.openInput(string);
                String string2 = this.si.getVersion();
                boolean bl2 = (string2 == null || StringHelper.getVersionComparator().compare(string2, "3.2") < 0) && indexInput.length() == (long)this.maxDoc();
                l2 = bl2 ? 0L : (long)SegmentNorms.NORMS_HEADER.length;
            }
            this.norms.put(fieldInfo.name, new SegmentNorms(indexInput, fieldInfo.number, l2, this));
            l += (long)n2;
        }
    }

    boolean termsIndexLoaded() {
        return this.core.termsIndexIsLoaded();
    }

    void loadTermsIndex(int n) throws IOException {
        this.core.loadTermsIndex(this.si, n);
    }

    boolean normsClosed() {
        if (this.singleNormStream != null) {
            return false;
        }
        for (SegmentNorms segmentNorms : this.norms.values()) {
            if (segmentNorms.refCount <= 0) continue;
            return false;
        }
        return true;
    }

    boolean normsClosed(String string) {
        return this.norms.get((Object)string).refCount == 0;
    }

    TermVectorsReader getTermVectorsReader() {
        TermVectorsReader termVectorsReader = this.termVectorsLocal.get();
        if (termVectorsReader == null) {
            TermVectorsReader termVectorsReader2 = this.core.getTermVectorsReaderOrig();
            if (termVectorsReader2 == null) {
                return null;
            }
            try {
                termVectorsReader = (TermVectorsReader)termVectorsReader2.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
            this.termVectorsLocal.set(termVectorsReader);
        }
        return termVectorsReader;
    }

    TermVectorsReader getTermVectorsReaderOrig() {
        return this.core.getTermVectorsReaderOrig();
    }

    @Override
    public TermFreqVector getTermFreqVector(int n, String string) throws IOException {
        this.ensureOpen();
        FieldInfo fieldInfo = this.core.fieldInfos.fieldInfo(string);
        if (fieldInfo == null || !fieldInfo.storeTermVector) {
            return null;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(n, string);
    }

    @Override
    public void getTermFreqVector(int n, String string, TermVectorMapper termVectorMapper) throws IOException {
        this.ensureOpen();
        FieldInfo fieldInfo = this.core.fieldInfos.fieldInfo(string);
        if (fieldInfo == null || !fieldInfo.storeTermVector) {
            return;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return;
        }
        termVectorsReader.get(n, string, termVectorMapper);
    }

    @Override
    public void getTermFreqVector(int n, TermVectorMapper termVectorMapper) throws IOException {
        this.ensureOpen();
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return;
        }
        termVectorsReader.get(n, termVectorMapper);
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(n);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasChanges) {
            stringBuilder.append('*');
        }
        stringBuilder.append(this.si.toString(this.core.dir, this.pendingDeleteCount));
        return stringBuilder.toString();
    }

    public String getSegmentName() {
        return this.core.segment;
    }

    SegmentInfo getSegmentInfo() {
        return this.si;
    }

    void setSegmentInfo(SegmentInfo segmentInfo) {
        this.si = segmentInfo;
    }

    void startCommit() {
        this.rollbackSegmentInfo = (SegmentInfo)this.si.clone();
        this.rollbackHasChanges = this.hasChanges;
        this.rollbackDeletedDocsDirty = this.deletedDocsDirty;
        this.rollbackNormsDirty = this.normsDirty;
        this.rollbackPendingDeleteCount = this.pendingDeleteCount;
        for (SegmentNorms segmentNorms : this.norms.values()) {
            segmentNorms.rollbackDirty = segmentNorms.dirty;
        }
    }

    void rollbackCommit() {
        this.si.reset(this.rollbackSegmentInfo);
        this.hasChanges = this.rollbackHasChanges;
        this.deletedDocsDirty = this.rollbackDeletedDocsDirty;
        this.normsDirty = this.rollbackNormsDirty;
        this.pendingDeleteCount = this.rollbackPendingDeleteCount;
        for (SegmentNorms segmentNorms : this.norms.values()) {
            segmentNorms.dirty = segmentNorms.rollbackDirty;
        }
    }

    @Override
    public Directory directory() {
        return this.core.dir;
    }

    @Override
    public final Object getCoreCacheKey() {
        return this.core.freqStream;
    }

    @Override
    public Object getDeletesCacheKey() {
        return this.deletedDocs;
    }

    @Override
    public long getUniqueTermCount() {
        return this.core.getTermsReader().size();
    }

    @Deprecated
    static SegmentReader getOnlySegmentReader(Directory directory) throws IOException {
        return SegmentReader.getOnlySegmentReader(IndexReader.open(directory, false));
    }

    static SegmentReader getOnlySegmentReader(IndexReader indexReader) {
        if (indexReader instanceof SegmentReader) {
            return (SegmentReader)indexReader;
        }
        if (indexReader instanceof DirectoryReader) {
            IndexReader[] indexReaderArray = indexReader.getSequentialSubReaders();
            if (indexReaderArray.length != 1) {
                throw new IllegalArgumentException(indexReader + " has " + indexReaderArray.length + " segments instead of exactly one");
            }
            return (SegmentReader)indexReaderArray[0];
        }
        throw new IllegalArgumentException(indexReader + " is not a SegmentReader or a single-segment DirectoryReader");
    }

    @Override
    public int getTermInfosIndexDivisor() {
        return this.core.termsIndexDivisor;
    }

    @Override
    protected void readerFinished() {
    }

    private class FieldsReaderLocal
    extends CloseableThreadLocal<FieldsReader> {
        private FieldsReaderLocal() {
        }

        @Override
        protected FieldsReader initialValue() {
            return (FieldsReader)SegmentReader.this.core.getFieldsReaderOrig().clone();
        }
    }
}

