/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.lucene.util.StringHelper;

public final class Term
implements Comparable<Term>,
Serializable {
    String field;
    String text;

    public Term(String string, String string2) {
        this.field = StringHelper.intern(string);
        this.text = string2;
    }

    public Term(String string) {
        this(string, "", true);
    }

    Term(String string, String string2, boolean bl) {
        this.field = bl ? StringHelper.intern(string) : string;
        this.text = string2;
    }

    public final String field() {
        return this.field;
    }

    public final String text() {
        return this.text;
    }

    public Term createTerm(String string) {
        return new Term(this.field, string, false);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Term term = (Term)object;
        if (this.field == null ? term.field != null : this.field != term.field) {
            return false;
        }
        return !(this.text == null ? term.text != null : !this.text.equals(term.text));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.field == null ? 0 : this.field.hashCode());
        n = 31 * n + (this.text == null ? 0 : this.text.hashCode());
        return n;
    }

    @Override
    public final int compareTo(Term term) {
        if (this.field == term.field) {
            return this.text.compareTo(term.text);
        }
        return this.field.compareTo(term.field);
    }

    final void set(String string, String string2) {
        this.field = string;
        this.text = string2;
    }

    public final String toString() {
        return this.field + ":" + this.text;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.field = StringHelper.intern(this.field);
    }
}

