/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.UnicodeUtil;

final class TermBuffer
implements Cloneable {
    private String field;
    private Term term;
    private boolean preUTF8Strings;
    private boolean dirty;
    private UnicodeUtil.UTF16Result text = new UnicodeUtil.UTF16Result();
    private UnicodeUtil.UTF8Result bytes = new UnicodeUtil.UTF8Result();

    TermBuffer() {
    }

    public final int compareTo(TermBuffer termBuffer) {
        if (this.field == termBuffer.field) {
            return TermBuffer.compareChars(this.text.result, this.text.length, termBuffer.text.result, termBuffer.text.length);
        }
        return this.field.compareTo(termBuffer.field);
    }

    private static final int compareChars(char[] cArray, int n, char[] cArray2, int n2) {
        int n3 = n < n2 ? n : n2;
        for (int i = 0; i < n3; ++i) {
            char c = cArray[i];
            char c2 = cArray2[i];
            if (c == c2) continue;
            return c - c2;
        }
        return n - n2;
    }

    void setPreUTF8Strings() {
        this.preUTF8Strings = true;
    }

    public final void read(IndexInput indexInput, FieldInfos fieldInfos) throws IOException {
        this.term = null;
        int n = indexInput.readVInt();
        int n2 = indexInput.readVInt();
        int n3 = n + n2;
        if (this.preUTF8Strings) {
            this.text.setLength(n3);
            indexInput.readChars(this.text.result, n, n2);
        } else if (this.dirty) {
            UnicodeUtil.UTF16toUTF8(this.text.result, 0, this.text.length, this.bytes);
            this.bytes.setLength(n3);
            indexInput.readBytes(this.bytes.result, n, n2);
            UnicodeUtil.UTF8toUTF16(this.bytes.result, 0, n3, this.text);
            this.dirty = false;
        } else {
            this.bytes.setLength(n3);
            indexInput.readBytes(this.bytes.result, n, n2);
            UnicodeUtil.UTF8toUTF16(this.bytes.result, n, n2, this.text);
        }
        this.field = fieldInfos.fieldName(indexInput.readVInt());
    }

    public final void set(Term term) {
        if (term == null) {
            this.reset();
            return;
        }
        String string = term.text();
        int n = string.length();
        this.text.setLength(n);
        string.getChars(0, n, this.text.result, 0);
        this.dirty = true;
        this.field = term.field();
        this.term = term;
    }

    public final void set(TermBuffer termBuffer) {
        this.text.copyText(termBuffer.text);
        this.dirty = true;
        this.field = termBuffer.field;
        this.term = termBuffer.term;
    }

    public void reset() {
        this.field = null;
        this.text.setLength(0);
        this.term = null;
        this.dirty = true;
    }

    public Term toTerm() {
        if (this.field == null) {
            return null;
        }
        if (this.term == null) {
            this.term = new Term(this.field, new String(this.text.result, 0, this.text.length), false);
        }
        return this.term;
    }

    protected Object clone() {
        TermBuffer termBuffer = null;
        try {
            termBuffer = (TermBuffer)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        termBuffer.dirty = true;
        termBuffer.bytes = new UnicodeUtil.UTF8Result();
        termBuffer.text = new UnicodeUtil.UTF16Result();
        termBuffer.text.copyText(this.text);
        return termBuffer;
    }
}

