/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.UnicodeUtil;

final class TermInfosWriter
implements Closeable {
    public static final int FORMAT = -3;
    public static final int FORMAT_VERSION_UTF8_LENGTH_IN_BYTES = -4;
    public static final int FORMAT_CURRENT = -4;
    private FieldInfos fieldInfos;
    private IndexOutput output;
    private TermInfo lastTi = new TermInfo();
    private long size;
    int indexInterval = 128;
    int skipInterval = 16;
    int maxSkipLevels = 10;
    private long lastIndexPointer;
    private boolean isIndex;
    private byte[] lastTermBytes = new byte[10];
    private int lastTermBytesLength = 0;
    private int lastFieldNumber = -1;
    private TermInfosWriter other;
    private UnicodeUtil.UTF8Result utf8Result = new UnicodeUtil.UTF8Result();
    UnicodeUtil.UTF16Result utf16Result1;
    UnicodeUtil.UTF16Result utf16Result2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TermInfosWriter(Directory directory, String string, FieldInfos fieldInfos, int n) throws IOException {
        this.initialize(directory, string, fieldInfos, n, false);
        boolean bl = false;
        try {
            this.other = new TermInfosWriter(directory, string, fieldInfos, n, true);
            this.other.other = this;
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(this.output, this.other);
            throw throwable;
        }
    }

    private TermInfosWriter(Directory directory, String string, FieldInfos fieldInfos, int n, boolean bl) throws IOException {
        this.initialize(directory, string, fieldInfos, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize(Directory directory, String string, FieldInfos fieldInfos, int n, boolean bl) throws IOException {
        this.indexInterval = n;
        this.fieldInfos = fieldInfos;
        this.isIndex = bl;
        this.output = directory.createOutput(string + (this.isIndex ? ".tii" : ".tis"));
        boolean bl2 = false;
        try {
            this.output.writeInt(-4);
            this.output.writeLong(0L);
            this.output.writeInt(this.indexInterval);
            this.output.writeInt(this.skipInterval);
            this.output.writeInt(this.maxSkipLevels);
            assert (this.initUTF16Results());
            bl2 = true;
            if (bl2) return;
        }
        catch (Throwable throwable) {
            if (bl2) throw throwable;
            IOUtils.closeWhileHandlingException(this.output);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this.output);
    }

    void add(Term term, TermInfo termInfo) throws IOException {
        UnicodeUtil.UTF16toUTF8(term.text, 0, term.text.length(), this.utf8Result);
        this.add(this.fieldInfos.fieldNumber(term.field), this.utf8Result.result, this.utf8Result.length, termInfo);
    }

    private boolean initUTF16Results() {
        this.utf16Result1 = new UnicodeUtil.UTF16Result();
        this.utf16Result2 = new UnicodeUtil.UTF16Result();
        return true;
    }

    private int compareToLastTerm(int n, byte[] byArray, int n2) {
        int n3;
        if (this.lastFieldNumber != n && ((n3 = this.fieldInfos.fieldName(this.lastFieldNumber).compareTo(this.fieldInfos.fieldName(n))) != 0 || this.lastFieldNumber != -1)) {
            return n3;
        }
        UnicodeUtil.UTF8toUTF16(this.lastTermBytes, 0, this.lastTermBytesLength, this.utf16Result1);
        UnicodeUtil.UTF8toUTF16(byArray, 0, n2, this.utf16Result2);
        n3 = this.utf16Result1.length < this.utf16Result2.length ? this.utf16Result1.length : this.utf16Result2.length;
        for (int i = 0; i < n3; ++i) {
            char c = this.utf16Result1.result[i];
            char c2 = this.utf16Result2.result[i];
            if (c == c2) continue;
            return c - c2;
        }
        if (this.utf16Result1.length == 0 && this.lastFieldNumber == -1) {
            return -1;
        }
        return this.utf16Result1.length - this.utf16Result2.length;
    }

    void add(int n, byte[] byArray, int n2, TermInfo termInfo) throws IOException {
        assert (this.compareToLastTerm(n, byArray, n2) < 0 || this.isIndex && n2 == 0 && this.lastTermBytesLength == 0) : "Terms are out of order: field=" + this.fieldInfos.fieldName(n) + " (number " + n + ")" + " lastField=" + this.fieldInfos.fieldName(this.lastFieldNumber) + " (number " + this.lastFieldNumber + ")" + " text=" + new String(byArray, 0, n2, "UTF-8") + " lastText=" + new String(this.lastTermBytes, 0, this.lastTermBytesLength, "UTF-8");
        assert (termInfo.freqPointer >= this.lastTi.freqPointer) : "freqPointer out of order (" + termInfo.freqPointer + " < " + this.lastTi.freqPointer + ")";
        assert (termInfo.proxPointer >= this.lastTi.proxPointer) : "proxPointer out of order (" + termInfo.proxPointer + " < " + this.lastTi.proxPointer + ")";
        if (!this.isIndex && this.size % (long)this.indexInterval == 0L) {
            this.other.add(this.lastFieldNumber, this.lastTermBytes, this.lastTermBytesLength, this.lastTi);
        }
        this.writeTerm(n, byArray, n2);
        this.output.writeVInt(termInfo.docFreq);
        this.output.writeVLong(termInfo.freqPointer - this.lastTi.freqPointer);
        this.output.writeVLong(termInfo.proxPointer - this.lastTi.proxPointer);
        if (termInfo.docFreq >= this.skipInterval) {
            this.output.writeVInt(termInfo.skipOffset);
        }
        if (this.isIndex) {
            this.output.writeVLong(this.other.output.getFilePointer() - this.lastIndexPointer);
            this.lastIndexPointer = this.other.output.getFilePointer();
        }
        this.lastFieldNumber = n;
        this.lastTi.set(termInfo);
        ++this.size;
    }

    private void writeTerm(int n, byte[] byArray, int n2) throws IOException {
        int n3;
        int n4;
        int n5 = n4 = n2 < this.lastTermBytesLength ? n2 : this.lastTermBytesLength;
        for (n3 = 0; n3 < n4 && byArray[n3] == this.lastTermBytes[n3]; ++n3) {
        }
        int n6 = n2 - n3;
        this.output.writeVInt(n3);
        this.output.writeVInt(n6);
        this.output.writeBytes(byArray, n3, n6);
        this.output.writeVInt(n);
        if (this.lastTermBytes.length < n2) {
            this.lastTermBytes = ArrayUtil.grow(this.lastTermBytes, n2);
        }
        System.arraycopy(byArray, n3, this.lastTermBytes, n3, n6);
        this.lastTermBytesLength = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.output.seek(4L);
            this.output.writeLong(this.size);
        }
        finally {
            try {
                this.output.close();
            }
            finally {
                if (!this.isIndex) {
                    this.other.close();
                }
            }
        }
    }
}

