/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.DocInverterPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.InvertedDocConsumer;
import org.apache.lucene.index.InvertedDocConsumerPerField;
import org.apache.lucene.index.InvertedDocConsumerPerThread;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermsHashConsumer;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashConsumerPerThread;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.index.TermsHashPerThread;

final class TermsHash
extends InvertedDocConsumer {
    final TermsHashConsumer consumer;
    final TermsHash nextTermsHash;
    final DocumentsWriter docWriter;
    boolean trackAllocations;

    public TermsHash(DocumentsWriter documentsWriter, boolean bl, TermsHashConsumer termsHashConsumer, TermsHash termsHash) {
        this.docWriter = documentsWriter;
        this.consumer = termsHashConsumer;
        this.nextTermsHash = termsHash;
        this.trackAllocations = bl;
    }

    @Override
    InvertedDocConsumerPerThread addThread(DocInverterPerThread docInverterPerThread) {
        return new TermsHashPerThread(docInverterPerThread, this, this.nextTermsHash, null);
    }

    TermsHashPerThread addThread(DocInverterPerThread docInverterPerThread, TermsHashPerThread termsHashPerThread) {
        return new TermsHashPerThread(docInverterPerThread, this, this.nextTermsHash, termsHashPerThread);
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        this.fieldInfos = fieldInfos;
        this.consumer.setFieldInfos(fieldInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        try {
            this.consumer.abort();
        }
        finally {
            if (this.nextTermsHash != null) {
                this.nextTermsHash.abort();
            }
        }
    }

    @Override
    synchronized void flush(Map<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>> map, SegmentWriteState segmentWriteState) throws IOException {
        HashMap<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> hashMap = new HashMap<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>>();
        HashMap<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>> hashMap2 = this.nextTermsHash != null ? new HashMap<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>>() : null;
        for (Map.Entry<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>> entry : map.entrySet()) {
            TermsHashPerThread termsHashPerThread = (TermsHashPerThread)entry.getKey();
            Collection<InvertedDocConsumerPerField> collection = entry.getValue();
            Iterator<InvertedDocConsumerPerField> iterator = collection.iterator();
            HashSet<TermsHashConsumerPerField> hashSet = new HashSet<TermsHashConsumerPerField>();
            HashSet<TermsHashPerField> hashSet2 = this.nextTermsHash != null ? new HashSet<TermsHashPerField>() : null;
            while (iterator.hasNext()) {
                TermsHashPerField termsHashPerField = (TermsHashPerField)iterator.next();
                hashSet.add(termsHashPerField.consumer);
                if (this.nextTermsHash == null) continue;
                hashSet2.add(termsHashPerField.nextPerField);
            }
            hashMap.put(termsHashPerThread.consumer, hashSet);
            if (this.nextTermsHash == null) continue;
            hashMap2.put(termsHashPerThread.nextPerThread, hashSet2);
        }
        this.consumer.flush(hashMap, segmentWriteState);
        if (this.nextTermsHash != null) {
            this.nextTermsHash.flush(hashMap2, segmentWriteState);
        }
    }

    @Override
    public synchronized boolean freeRAM() {
        return false;
    }
}

