/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;

public class TieredMergePolicy
extends MergePolicy {
    private int maxMergeAtOnce = 10;
    private long maxMergedSegmentBytes = 0x140000000L;
    private int maxMergeAtOnceExplicit = 30;
    private long floorSegmentBytes = 0x200000L;
    private double segsPerTier = 10.0;
    private double forceMergeDeletesPctAllowed = 10.0;
    private boolean useCompoundFile = true;
    private double noCFSRatio = 0.1;
    private double reclaimDeletesWeight = 2.0;
    private final Comparator<SegmentInfo> segmentByteSizeDescending = new SegmentByteSizeDescending();

    public TieredMergePolicy setMaxMergeAtOnce(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("maxMergeAtOnce must be > 1 (got " + n + ")");
        }
        this.maxMergeAtOnce = n;
        return this;
    }

    public int getMaxMergeAtOnce() {
        return this.maxMergeAtOnce;
    }

    public TieredMergePolicy setMaxMergeAtOnceExplicit(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("maxMergeAtOnceExplicit must be > 1 (got " + n + ")");
        }
        this.maxMergeAtOnceExplicit = n;
        return this;
    }

    public int getMaxMergeAtOnceExplicit() {
        return this.maxMergeAtOnceExplicit;
    }

    public TieredMergePolicy setMaxMergedSegmentMB(double d) {
        this.maxMergedSegmentBytes = (long)(d * 1024.0 * 1024.0);
        return this;
    }

    public double getMaxMergedSegmentMB() {
        return (double)(this.maxMergedSegmentBytes / 1024L) / 1024.0;
    }

    public TieredMergePolicy setReclaimDeletesWeight(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("reclaimDeletesWeight must be >= 0.0 (got " + d + ")");
        }
        this.reclaimDeletesWeight = d;
        return this;
    }

    public double getReclaimDeletesWeight() {
        return this.reclaimDeletesWeight;
    }

    public TieredMergePolicy setFloorSegmentMB(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("floorSegmentMB must be >= 0.0 (got " + d + ")");
        }
        this.floorSegmentBytes = (long)(d * 1024.0 * 1024.0);
        return this;
    }

    public double getFloorSegmentMB() {
        return (double)(this.floorSegmentBytes / 1024L) * 1024.0;
    }

    public TieredMergePolicy setForceMergeDeletesPctAllowed(double d) {
        if (d < 0.0 || d > 100.0) {
            throw new IllegalArgumentException("forceMergeDeletesPctAllowed must be between 0.0 and 100.0 inclusive (got " + d + ")");
        }
        this.forceMergeDeletesPctAllowed = d;
        return this;
    }

    public double getForceMergeDeletesPctAllowed() {
        return this.forceMergeDeletesPctAllowed;
    }

    public TieredMergePolicy setSegmentsPerTier(double d) {
        if (d < 2.0) {
            throw new IllegalArgumentException("segmentsPerTier must be >= 2.0 (got " + d + ")");
        }
        this.segsPerTier = d;
        return this;
    }

    public double getSegmentsPerTier() {
        return this.segsPerTier;
    }

    public TieredMergePolicy setUseCompoundFile(boolean bl) {
        this.useCompoundFile = bl;
        return this;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public TieredMergePolicy setNoCFSRatio(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("noCFSRatio must be 0.0 to 1.0 inclusive; got " + d);
        }
        this.noCFSRatio = d;
        return this;
    }

    public double getNoCFSRatio() {
        return this.noCFSRatio;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(SegmentInfos segmentInfos) throws IOException {
        MergePolicy.MergeSpecification mergeSpecification;
        block18: {
            double d;
            int n;
            if (this.verbose()) {
                this.message("findMerges: " + segmentInfos.size() + " segments");
            }
            if (segmentInfos.size() == 0) {
                return null;
            }
            Collection<SegmentInfo> collection = ((IndexWriter)this.writer.get()).getMergingSegments();
            HashSet<SegmentInfo> hashSet = new HashSet<SegmentInfo>();
            ArrayList<SegmentInfo> arrayList = new ArrayList<SegmentInfo>(segmentInfos.asList());
            Collections.sort(arrayList, this.segmentByteSizeDescending);
            long l = 0L;
            long l2 = Long.MAX_VALUE;
            for (SegmentInfo segmentInfo : arrayList) {
                long l3 = this.size(segmentInfo);
                if (this.verbose()) {
                    String string;
                    String string2 = string = collection.contains(segmentInfo) ? " [merging]" : "";
                    if ((double)l3 >= (double)this.maxMergedSegmentBytes / 2.0) {
                        string = string + " [skip: too large]";
                    } else if (l3 < this.floorSegmentBytes) {
                        string = string + " [floored]";
                    }
                    this.message("  seg=" + ((IndexWriter)this.writer.get()).segString(segmentInfo) + " size=" + String.format("%.3f", (double)(l3 / 1024L) / 1024.0) + " MB" + string);
                }
                l2 = Math.min(l3, l2);
                l += l3;
            }
            for (n = 0; n < arrayList.size() && (double)this.size((SegmentInfo)arrayList.get(n)) >= (double)this.maxMergedSegmentBytes / 2.0; ++n) {
                l -= this.size((SegmentInfo)arrayList.get(n));
            }
            long l4 = l2 = this.floorSize(l2);
            long l5 = l;
            double d2 = 0.0;
            while (!((d = (double)l5 / (double)l4) < this.segsPerTier)) {
                d2 += this.segsPerTier;
                l5 = (long)((double)l5 - this.segsPerTier * (double)l4);
                l4 *= (long)this.maxMergeAtOnce;
            }
            int n2 = (int)(d2 += Math.ceil(d));
            mergeSpecification = null;
            while (true) {
                Object object;
                int n3;
                long l6 = 0L;
                ArrayList<SegmentInfo> arrayList2 = new ArrayList<SegmentInfo>();
                for (n3 = n; n3 < arrayList.size(); ++n3) {
                    object = (SegmentInfo)arrayList.get(n3);
                    if (collection.contains(object)) {
                        l6 += ((SegmentInfo)object).sizeInBytes(true);
                        continue;
                    }
                    if (hashSet.contains(object)) continue;
                    arrayList2.add((SegmentInfo)object);
                }
                n3 = l6 >= this.maxMergedSegmentBytes ? 1 : 0;
                this.message("  allowedSegmentCount=" + n2 + " vs count=" + arrayList.size() + " (eligible count=" + arrayList2.size() + ") tooBigCount=" + n);
                if (arrayList2.size() == 0) {
                    return mergeSpecification;
                }
                if (arrayList2.size() < n2) break block18;
                object = null;
                ArrayList<SegmentInfo> arrayList3 = null;
                boolean bl = false;
                long l7 = 0L;
                for (int i = 0; i <= arrayList2.size() - this.maxMergeAtOnce; ++i) {
                    long l8 = 0L;
                    ArrayList<SegmentInfo> arrayList4 = new ArrayList<SegmentInfo>();
                    boolean bl2 = false;
                    for (int j = i; j < arrayList2.size() && arrayList4.size() < this.maxMergeAtOnce; ++j) {
                        SegmentInfo segmentInfo = (SegmentInfo)arrayList2.get(j);
                        long l9 = this.size(segmentInfo);
                        if (l8 + l9 > this.maxMergedSegmentBytes) {
                            bl2 = true;
                            continue;
                        }
                        arrayList4.add(segmentInfo);
                        l8 += l9;
                    }
                    MergeScore mergeScore = this.score(arrayList4, bl2, l6);
                    this.message("  maybe=" + ((IndexWriter)this.writer.get()).segString(arrayList4) + " score=" + mergeScore.getScore() + " " + mergeScore.getExplanation() + " tooLarge=" + bl2 + " size=" + String.format("%.3f MB", (double)l8 / 1024.0 / 1024.0));
                    if (object != null && !(mergeScore.getScore() < ((MergeScore)object).getScore()) || bl2 && n3 != 0) continue;
                    arrayList3 = arrayList4;
                    object = mergeScore;
                    bl = bl2;
                    l7 = l8;
                }
                if (arrayList3 == null) break;
                if (mergeSpecification == null) {
                    mergeSpecification = new MergePolicy.MergeSpecification();
                }
                MergePolicy.OneMerge oneMerge = new MergePolicy.OneMerge(arrayList3);
                mergeSpecification.add(oneMerge);
                for (SegmentInfo segmentInfo : oneMerge.segments) {
                    hashSet.add(segmentInfo);
                }
                if (!this.verbose()) continue;
                this.message("  add merge=" + ((IndexWriter)this.writer.get()).segString(oneMerge.segments) + " size=" + String.format("%.3f MB", (double)l7 / 1024.0 / 1024.0) + " score=" + String.format("%.3f", ((MergeScore)object).getScore()) + " " + ((MergeScore)object).getExplanation() + (bl ? " [max merge]" : ""));
            }
            return mergeSpecification;
        }
        return mergeSpecification;
    }

    protected MergeScore score(List<SegmentInfo> list, boolean bl, long l) throws IOException {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (SegmentInfo segmentInfo : list) {
            long l5 = this.size(segmentInfo);
            l3 += l5;
            l4 += this.floorSize(l5);
            l2 += segmentInfo.sizeInBytes(true);
        }
        final double d = bl ? 1.0 / (double)this.maxMergeAtOnce : (double)this.floorSize(this.size(list.get(0))) / (double)l4;
        double d2 = d;
        d2 *= Math.pow(l3, 0.05);
        final double d3 = (double)l3 / (double)l2;
        final double d4 = d2 *= Math.pow(d3, this.reclaimDeletesWeight);
        return new MergeScore(){

            @Override
            public double getScore() {
                return d4;
            }

            @Override
            public String getExplanation() {
                return "skew=" + String.format("%.3f", d) + " nonDelRatio=" + String.format("%.3f", d3);
            }
        };
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int n, Map<SegmentInfo, Boolean> map) throws IOException {
        int n2;
        Object object;
        Object object22;
        if (this.verbose()) {
            this.message("findForcedMerges maxSegmentCount=" + n + " infos=" + ((IndexWriter)this.writer.get()).segString(segmentInfos) + " segmentsToMerge=" + map);
        }
        ArrayList<SegmentInfo> arrayList = new ArrayList<SegmentInfo>();
        boolean bl = false;
        Collection<SegmentInfo> collection = ((IndexWriter)this.writer.get()).getMergingSegments();
        boolean bl2 = false;
        for (Object object22 : segmentInfos) {
            object = map.get(object22);
            if (object == null) continue;
            bl2 = (Boolean)object;
            if (!collection.contains(object22)) {
                arrayList.add((SegmentInfo)object22);
                continue;
            }
            bl = true;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (n > 1 && arrayList.size() <= n || n == 1 && arrayList.size() == 1 && (!bl2 || this.isMerged((SegmentInfo)arrayList.get(0)))) {
            if (this.verbose()) {
                this.message("already merged");
            }
            return null;
        }
        Collections.sort(arrayList, this.segmentByteSizeDescending);
        if (this.verbose()) {
            this.message("eligible=" + arrayList);
            this.message("forceMergeRunning=" + bl);
        }
        object22 = null;
        for (n2 = arrayList.size(); n2 >= this.maxMergeAtOnceExplicit + n - 1; n2 -= this.maxMergeAtOnceExplicit) {
            if (object22 == null) {
                object22 = new MergePolicy.MergeSpecification();
            }
            object = new MergePolicy.OneMerge(arrayList.subList(n2 - this.maxMergeAtOnceExplicit, n2));
            if (this.verbose()) {
                this.message("add merge=" + ((IndexWriter)this.writer.get()).segString(((MergePolicy.OneMerge)object).segments));
            }
            ((MergePolicy.MergeSpecification)object22).add((MergePolicy.OneMerge)object);
        }
        if (object22 == null && !bl) {
            int n3 = n2 - n + 1;
            MergePolicy.OneMerge oneMerge = new MergePolicy.OneMerge(arrayList.subList(n2 - n3, n2));
            if (this.verbose()) {
                this.message("add final merge=" + oneMerge.segString(((IndexWriter)this.writer.get()).getDirectory()));
            }
            object22 = new MergePolicy.MergeSpecification();
            ((MergePolicy.MergeSpecification)object22).add(oneMerge);
        }
        return object22;
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos) throws CorruptIndexException, IOException {
        Object object2;
        if (this.verbose()) {
            this.message("findForcedDeletesMerges infos=" + ((IndexWriter)this.writer.get()).segString(segmentInfos) + " forceMergeDeletesPctAllowed=" + this.forceMergeDeletesPctAllowed);
        }
        ArrayList<SegmentInfo> arrayList = new ArrayList<SegmentInfo>();
        Collection<SegmentInfo> collection = ((IndexWriter)this.writer.get()).getMergingSegments();
        for (Object object2 : segmentInfos) {
            double d = 100.0 * (double)((IndexWriter)this.writer.get()).numDeletedDocs((SegmentInfo)object2) / (double)((SegmentInfo)object2).docCount;
            if (!(d > this.forceMergeDeletesPctAllowed) || collection.contains(object2)) continue;
            arrayList.add((SegmentInfo)object2);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Collections.sort(arrayList, this.segmentByteSizeDescending);
        if (this.verbose()) {
            this.message("eligible=" + arrayList);
        }
        int n = 0;
        object2 = null;
        while (n < arrayList.size()) {
            int n2 = Math.min(n + this.maxMergeAtOnceExplicit, arrayList.size());
            if (object2 == null) {
                object2 = new MergePolicy.MergeSpecification();
            }
            MergePolicy.OneMerge oneMerge = new MergePolicy.OneMerge(arrayList.subList(n, n2));
            if (this.verbose()) {
                this.message("add merge=" + ((IndexWriter)this.writer.get()).segString(oneMerge.segments));
            }
            ((MergePolicy.MergeSpecification)object2).add(oneMerge);
            n = n2;
        }
        return object2;
    }

    @Override
    public boolean useCompoundFile(SegmentInfos segmentInfos, SegmentInfo segmentInfo) throws IOException {
        boolean bl;
        if (!this.useCompoundFile) {
            bl = false;
        } else if (this.noCFSRatio == 1.0) {
            bl = true;
        } else {
            long l = 0L;
            for (SegmentInfo segmentInfo2 : segmentInfos) {
                l += this.size(segmentInfo2);
            }
            bl = (double)this.size(segmentInfo) <= this.noCFSRatio * (double)l;
        }
        return bl;
    }

    @Override
    public void close() {
    }

    private boolean isMerged(SegmentInfo segmentInfo) throws IOException {
        IndexWriter indexWriter = (IndexWriter)this.writer.get();
        assert (indexWriter != null);
        boolean bl = indexWriter.numDeletedDocs(segmentInfo) > 0;
        return !bl && !segmentInfo.hasSeparateNorms() && segmentInfo.dir == indexWriter.getDirectory() && (segmentInfo.getUseCompoundFile() == this.useCompoundFile || this.noCFSRatio < 1.0);
    }

    private long size(SegmentInfo segmentInfo) throws IOException {
        double d;
        long l = segmentInfo.sizeInBytes(true);
        int n = ((IndexWriter)this.writer.get()).numDeletedDocs(segmentInfo);
        double d2 = d = segmentInfo.docCount <= 0 ? 0.0 : (double)n / (double)segmentInfo.docCount;
        assert (d <= 1.0);
        return (long)((double)l * (1.0 - d));
    }

    private long floorSize(long l) {
        return Math.max(this.floorSegmentBytes, l);
    }

    private boolean verbose() {
        IndexWriter indexWriter = (IndexWriter)this.writer.get();
        return indexWriter != null && indexWriter.verbose();
    }

    private void message(String string) {
        if (this.verbose()) {
            ((IndexWriter)this.writer.get()).message("TMP: " + string);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[" + this.getClass().getSimpleName() + ": ");
        stringBuilder.append("maxMergeAtOnce=").append(this.maxMergeAtOnce).append(", ");
        stringBuilder.append("maxMergeAtOnceExplicit=").append(this.maxMergeAtOnceExplicit).append(", ");
        stringBuilder.append("maxMergedSegmentMB=").append((double)(this.maxMergedSegmentBytes / 1024L) / 1024.0).append(", ");
        stringBuilder.append("floorSegmentMB=").append((double)(this.floorSegmentBytes / 1024L) / 1024.0).append(", ");
        stringBuilder.append("forceMergeDeletesPctAllowed=").append(this.forceMergeDeletesPctAllowed).append(", ");
        stringBuilder.append("segmentsPerTier=").append(this.segsPerTier).append(", ");
        stringBuilder.append("useCompoundFile=").append(this.useCompoundFile).append(", ");
        stringBuilder.append("noCFSRatio=").append(this.noCFSRatio);
        return stringBuilder.toString();
    }

    protected static abstract class MergeScore {
        protected MergeScore() {
        }

        abstract double getScore();

        abstract String getExplanation();
    }

    private class SegmentByteSizeDescending
    implements Comparator<SegmentInfo> {
        private SegmentByteSizeDescending() {
        }

        @Override
        public int compare(SegmentInfo segmentInfo, SegmentInfo segmentInfo2) {
            try {
                long l = TieredMergePolicy.this.size(segmentInfo);
                long l2 = TieredMergePolicy.this.size(segmentInfo2);
                if (l > l2) {
                    return -1;
                }
                if (l2 > l) {
                    return 1;
                }
                return segmentInfo.name.compareTo(segmentInfo2.name);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

