/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.SpanFilter;
import org.apache.lucene.search.SpanFilterResult;

public class CachingSpanFilter
extends SpanFilter {
    private SpanFilter filter;
    private final CachingWrapperFilter.FilterCache<SpanFilterResult> cache;
    int hitCount;
    int missCount;

    public CachingSpanFilter(SpanFilter spanFilter) {
        this(spanFilter, CachingWrapperFilter.DeletesMode.RECACHE);
    }

    public CachingSpanFilter(SpanFilter spanFilter, CachingWrapperFilter.DeletesMode deletesMode) {
        this.filter = spanFilter;
        if (deletesMode == CachingWrapperFilter.DeletesMode.DYNAMIC) {
            throw new IllegalArgumentException("DeletesMode.DYNAMIC is not supported");
        }
        this.cache = new CachingWrapperFilter.FilterCache<SpanFilterResult>(deletesMode){

            @Override
            protected SpanFilterResult mergeDeletes(IndexReader indexReader, SpanFilterResult spanFilterResult) {
                throw new IllegalStateException("DeletesMode.DYNAMIC is not supported");
            }
        };
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
        SpanFilterResult spanFilterResult = this.getCachedResult(indexReader);
        return spanFilterResult != null ? spanFilterResult.getDocIdSet() : null;
    }

    private SpanFilterResult getCachedResult(IndexReader indexReader) throws IOException {
        Object object;
        Object object2 = indexReader.getCoreCacheKey();
        SpanFilterResult spanFilterResult = this.cache.get(indexReader, object2, object = indexReader.hasDeletions() ? indexReader.getDeletesCacheKey() : object2);
        if (spanFilterResult != null) {
            ++this.hitCount;
            return spanFilterResult;
        }
        ++this.missCount;
        spanFilterResult = this.filter.bitSpans(indexReader);
        this.cache.put(object2, object, spanFilterResult);
        return spanFilterResult;
    }

    @Override
    public SpanFilterResult bitSpans(IndexReader indexReader) throws IOException {
        return this.getCachedResult(indexReader);
    }

    public String toString() {
        return "CachingSpanFilter(" + this.filter + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof CachingSpanFilter)) {
            return false;
        }
        return this.filter.equals(((CachingSpanFilter)object).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }
}

