/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSet;
import org.apache.lucene.util.FixedBitSet;

public class CachingWrapperFilter
extends Filter {
    Filter filter;
    protected final FilterCache<DocIdSet> cache;
    int hitCount;
    int missCount;

    public CachingWrapperFilter(Filter filter) {
        this(filter, DeletesMode.IGNORE);
    }

    public CachingWrapperFilter(Filter filter, DeletesMode deletesMode) {
        this.filter = filter;
        this.cache = new FilterCache<DocIdSet>(deletesMode){

            @Override
            public DocIdSet mergeDeletes(final IndexReader indexReader, DocIdSet docIdSet) {
                return new FilteredDocIdSet(docIdSet){

                    @Override
                    protected boolean match(int n) {
                        return !indexReader.isDeleted(n);
                    }
                };
            }
        };
    }

    protected DocIdSet docIdSetToCache(DocIdSet docIdSet, IndexReader indexReader) throws IOException {
        if (docIdSet == null) {
            return DocIdSet.EMPTY_DOCIDSET;
        }
        if (docIdSet.isCacheable()) {
            return docIdSet;
        }
        DocIdSetIterator docIdSetIterator = docIdSet.iterator();
        if (docIdSetIterator == null) {
            return DocIdSet.EMPTY_DOCIDSET;
        }
        FixedBitSet fixedBitSet = new FixedBitSet(indexReader.maxDoc());
        fixedBitSet.or(docIdSetIterator);
        return fixedBitSet;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
        Object object;
        Object object2 = indexReader.getCoreCacheKey();
        DocIdSet docIdSet = this.cache.get(indexReader, object2, object = indexReader.hasDeletions() ? indexReader.getDeletesCacheKey() : object2);
        if (docIdSet != null) {
            ++this.hitCount;
            return docIdSet;
        }
        ++this.missCount;
        docIdSet = this.docIdSetToCache(this.filter.getDocIdSet(indexReader), indexReader);
        if (docIdSet != null) {
            this.cache.put(object2, object, docIdSet);
        }
        return docIdSet;
    }

    public String toString() {
        return "CachingWrapperFilter(" + this.filter + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof CachingWrapperFilter)) {
            return false;
        }
        return this.filter.equals(((CachingWrapperFilter)object).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }

    static abstract class FilterCache<T>
    implements Serializable {
        transient Map<Object, T> cache;
        private final DeletesMode deletesMode;

        public FilterCache(DeletesMode deletesMode) {
            this.deletesMode = deletesMode;
        }

        public synchronized T get(IndexReader indexReader, Object object, Object object2) throws IOException {
            T t;
            if (this.cache == null) {
                this.cache = new WeakHashMap<Object, T>();
            }
            if (this.deletesMode == DeletesMode.IGNORE) {
                t = this.cache.get(object);
            } else if (this.deletesMode == DeletesMode.RECACHE) {
                t = this.cache.get(object2);
            } else {
                assert (this.deletesMode == DeletesMode.DYNAMIC);
                t = this.cache.get(object2);
                if (t == null && (t = this.cache.get(object)) != null && indexReader.hasDeletions()) {
                    t = this.mergeDeletes(indexReader, t);
                }
            }
            return t;
        }

        protected abstract T mergeDeletes(IndexReader var1, T var2);

        public synchronized void put(Object object, Object object2, T t) {
            if (this.deletesMode == DeletesMode.IGNORE) {
                this.cache.put(object, t);
            } else if (this.deletesMode == DeletesMode.RECACHE) {
                this.cache.put(object2, t);
            } else {
                this.cache.put(object, t);
                this.cache.put(object2, t);
            }
        }
    }

    public static enum DeletesMode {
        IGNORE,
        RECACHE,
        DYNAMIC;

    }
}

