/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCacheImpl;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;

public interface FieldCache {
    public static final int STRING_INDEX = -1;
    public static final FieldCache DEFAULT = new FieldCacheImpl();
    public static final ByteParser DEFAULT_BYTE_PARSER = new ByteParser(){

        @Override
        public byte parseByte(String string) {
            return Byte.parseByte(string);
        }

        protected Object readResolve() {
            return DEFAULT_BYTE_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_BYTE_PARSER";
        }
    };
    public static final ShortParser DEFAULT_SHORT_PARSER = new ShortParser(){

        @Override
        public short parseShort(String string) {
            return Short.parseShort(string);
        }

        protected Object readResolve() {
            return DEFAULT_SHORT_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_SHORT_PARSER";
        }
    };
    public static final IntParser DEFAULT_INT_PARSER = new IntParser(){

        @Override
        public int parseInt(String string) {
            return Integer.parseInt(string);
        }

        protected Object readResolve() {
            return DEFAULT_INT_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_INT_PARSER";
        }
    };
    public static final FloatParser DEFAULT_FLOAT_PARSER = new FloatParser(){

        @Override
        public float parseFloat(String string) {
            return Float.parseFloat(string);
        }

        protected Object readResolve() {
            return DEFAULT_FLOAT_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_FLOAT_PARSER";
        }
    };
    public static final LongParser DEFAULT_LONG_PARSER = new LongParser(){

        @Override
        public long parseLong(String string) {
            return Long.parseLong(string);
        }

        protected Object readResolve() {
            return DEFAULT_LONG_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_LONG_PARSER";
        }
    };
    public static final DoubleParser DEFAULT_DOUBLE_PARSER = new DoubleParser(){

        @Override
        public double parseDouble(String string) {
            return Double.parseDouble(string);
        }

        protected Object readResolve() {
            return DEFAULT_DOUBLE_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_DOUBLE_PARSER";
        }
    };
    public static final IntParser NUMERIC_UTILS_INT_PARSER = new IntParser(){

        @Override
        public int parseInt(String string) {
            int n = string.charAt(0) - 96;
            if (n > 0 && n <= 31) {
                throw new FieldCacheImpl.StopFillCacheException();
            }
            return NumericUtils.prefixCodedToInt(string);
        }

        protected Object readResolve() {
            return NUMERIC_UTILS_INT_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_INT_PARSER";
        }
    };
    public static final FloatParser NUMERIC_UTILS_FLOAT_PARSER = new FloatParser(){

        @Override
        public float parseFloat(String string) {
            int n = string.charAt(0) - 96;
            if (n > 0 && n <= 31) {
                throw new FieldCacheImpl.StopFillCacheException();
            }
            return NumericUtils.sortableIntToFloat(NumericUtils.prefixCodedToInt(string));
        }

        protected Object readResolve() {
            return NUMERIC_UTILS_FLOAT_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_FLOAT_PARSER";
        }
    };
    public static final LongParser NUMERIC_UTILS_LONG_PARSER = new LongParser(){

        @Override
        public long parseLong(String string) {
            int n = string.charAt(0) - 32;
            if (n > 0 && n <= 63) {
                throw new FieldCacheImpl.StopFillCacheException();
            }
            return NumericUtils.prefixCodedToLong(string);
        }

        protected Object readResolve() {
            return NUMERIC_UTILS_LONG_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_LONG_PARSER";
        }
    };
    public static final DoubleParser NUMERIC_UTILS_DOUBLE_PARSER = new DoubleParser(){

        @Override
        public double parseDouble(String string) {
            int n = string.charAt(0) - 32;
            if (n > 0 && n <= 63) {
                throw new FieldCacheImpl.StopFillCacheException();
            }
            return NumericUtils.sortableLongToDouble(NumericUtils.prefixCodedToLong(string));
        }

        protected Object readResolve() {
            return NUMERIC_UTILS_DOUBLE_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_DOUBLE_PARSER";
        }
    };

    public Bits getDocsWithField(IndexReader var1, String var2) throws IOException;

    public byte[] getBytes(IndexReader var1, String var2) throws IOException;

    public byte[] getBytes(IndexReader var1, String var2, ByteParser var3) throws IOException;

    public byte[] getBytes(IndexReader var1, String var2, ByteParser var3, boolean var4) throws IOException;

    public short[] getShorts(IndexReader var1, String var2) throws IOException;

    public short[] getShorts(IndexReader var1, String var2, ShortParser var3) throws IOException;

    public short[] getShorts(IndexReader var1, String var2, ShortParser var3, boolean var4) throws IOException;

    public int[] getInts(IndexReader var1, String var2) throws IOException;

    public int[] getInts(IndexReader var1, String var2, IntParser var3) throws IOException;

    public int[] getInts(IndexReader var1, String var2, IntParser var3, boolean var4) throws IOException;

    public float[] getFloats(IndexReader var1, String var2) throws IOException;

    public float[] getFloats(IndexReader var1, String var2, FloatParser var3) throws IOException;

    public float[] getFloats(IndexReader var1, String var2, FloatParser var3, boolean var4) throws IOException;

    public long[] getLongs(IndexReader var1, String var2) throws IOException;

    public long[] getLongs(IndexReader var1, String var2, LongParser var3) throws IOException;

    public long[] getLongs(IndexReader var1, String var2, LongParser var3, boolean var4) throws IOException;

    public double[] getDoubles(IndexReader var1, String var2) throws IOException;

    public double[] getDoubles(IndexReader var1, String var2, DoubleParser var3) throws IOException;

    public double[] getDoubles(IndexReader var1, String var2, DoubleParser var3, boolean var4) throws IOException;

    public String[] getStrings(IndexReader var1, String var2) throws IOException;

    public StringIndex getStringIndex(IndexReader var1, String var2) throws IOException;

    public CacheEntry[] getCacheEntries();

    public void purgeAllCaches();

    public void purge(IndexReader var1);

    public void setInfoStream(PrintStream var1);

    public PrintStream getInfoStream();

    public static abstract class CacheEntry {
        private String size = null;

        public abstract Object getReaderKey();

        public abstract String getFieldName();

        public abstract Class<?> getCacheType();

        public abstract Object getCustom();

        public abstract Object getValue();

        protected final void setEstimatedSize(String string) {
            this.size = string;
        }

        public void estimateSize() {
            this.estimateSize(new RamUsageEstimator(false));
        }

        public void estimateSize(RamUsageEstimator ramUsageEstimator) {
            long l = ramUsageEstimator.estimateRamUsage(this.getValue());
            this.setEstimatedSize(RamUsageEstimator.humanReadableUnits(l, new DecimalFormat("0.#")));
        }

        public final String getEstimatedSize() {
            return this.size;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("'").append(this.getReaderKey()).append("'=>");
            stringBuilder.append("'").append(this.getFieldName()).append("',");
            stringBuilder.append(this.getCacheType()).append(",").append(this.getCustom());
            stringBuilder.append("=>").append(this.getValue().getClass().getName()).append("#");
            stringBuilder.append(System.identityHashCode(this.getValue()));
            String string = this.getEstimatedSize();
            if (null != string) {
                stringBuilder.append(" (size =~ ").append(string).append(')');
            }
            return stringBuilder.toString();
        }
    }

    public static interface DoubleParser
    extends Parser {
        public double parseDouble(String var1);
    }

    public static interface LongParser
    extends Parser {
        public long parseLong(String var1);
    }

    public static interface FloatParser
    extends Parser {
        public float parseFloat(String var1);
    }

    public static interface IntParser
    extends Parser {
        public int parseInt(String var1);
    }

    public static interface ShortParser
    extends Parser {
        public short parseShort(String var1);
    }

    public static interface ByteParser
    extends Parser {
        public byte parseByte(String var1);
    }

    public static interface Parser
    extends Serializable {
    }

    public static class StringIndex {
        public final String[] lookup;
        public final int[] order;

        public int binarySearchLookup(String string) {
            if (string == null) {
                return 0;
            }
            int n = 1;
            int n2 = this.lookup.length - 1;
            while (n <= n2) {
                int n3 = n + n2 >>> 1;
                int n4 = this.lookup[n3].compareTo(string);
                if (n4 < 0) {
                    n = n3 + 1;
                    continue;
                }
                if (n4 > 0) {
                    n2 = n3 - 1;
                    continue;
                }
                return n3;
            }
            return -(n + 1);
        }

        public StringIndex(int[] nArray, String[] stringArray) {
            this.order = nArray;
            this.lookup = stringArray;
        }
    }

    public static final class CreationPlaceholder {
        Object value;
    }
}

