/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

public class ScoreCachingWrappingScorer
extends Scorer {
    private final Scorer scorer;
    private int curDoc = -1;
    private float curScore;

    public ScoreCachingWrappingScorer(Scorer scorer) {
        super(scorer.getSimilarity(), scorer.weight);
        this.scorer = scorer;
    }

    @Override
    protected boolean score(Collector collector, int n, int n2) throws IOException {
        return this.scorer.score(collector, n, n2);
    }

    @Override
    public Similarity getSimilarity() {
        return this.scorer.getSimilarity();
    }

    @Override
    public float score() throws IOException {
        int n = this.scorer.docID();
        if (n != this.curDoc) {
            this.curScore = this.scorer.score();
            this.curDoc = n;
        }
        return this.curScore;
    }

    @Override
    public int docID() {
        return this.scorer.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.scorer.nextDoc();
    }

    @Override
    public void score(Collector collector) throws IOException {
        this.scorer.score(collector);
    }

    @Override
    public int advance(int n) throws IOException {
        return this.scorer.advance(n);
    }
}

