/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public abstract class Scorer
extends DocIdSetIterator {
    private final Similarity similarity;
    protected final Weight weight;

    protected Scorer(Weight weight) {
        this(null, weight);
    }

    @Deprecated
    protected Scorer(Similarity similarity) {
        this(similarity, null);
    }

    @Deprecated
    protected Scorer(Similarity similarity, Weight weight) {
        this.similarity = similarity;
        this.weight = weight;
    }

    @Deprecated
    public Similarity getSimilarity() {
        return this.similarity;
    }

    public void score(Collector collector) throws IOException {
        int n;
        collector.setScorer(this);
        while ((n = this.nextDoc()) != Integer.MAX_VALUE) {
            collector.collect(n);
        }
    }

    protected boolean score(Collector collector, int n, int n2) throws IOException {
        collector.setScorer(this);
        int n3 = n2;
        while (n3 < n) {
            collector.collect(n3);
            n3 = this.nextDoc();
        }
        return n3 != Integer.MAX_VALUE;
    }

    public abstract float score() throws IOException;

    public float freq() throws IOException {
        throw new UnsupportedOperationException(this + " does not implement freq()");
    }

    public void visitScorers(ScorerVisitor<Query, Query, Scorer> scorerVisitor) {
        this.visitSubScorers(null, BooleanClause.Occur.MUST, scorerVisitor);
    }

    protected void visitSubScorers(Query query, BooleanClause.Occur occur, ScorerVisitor<Query, Query, Scorer> scorerVisitor) {
        if (this.weight == null) {
            throw new UnsupportedOperationException();
        }
        Query query2 = this.weight.getQuery();
        switch (occur) {
            case MUST: {
                scorerVisitor.visitRequired(query, query2, this);
                break;
            }
            case MUST_NOT: {
                scorerVisitor.visitProhibited(query, query2, this);
                break;
            }
            case SHOULD: {
                scorerVisitor.visitOptional(query, query2, this);
            }
        }
    }

    public static abstract class ScorerVisitor<P extends Query, C extends Query, S extends Scorer> {
        public void visitOptional(P p, C c, S s) {
        }

        public void visitRequired(P p, C c, S s) {
        }

        public void visitProhibited(P p, C c, S s) {
        }
    }
}

