/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PhraseQueue;
import org.apache.lucene.search.PhraseScorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

final class SloppyPhraseScorer
extends PhraseScorer {
    private int slop;
    private boolean checkedRepeats;
    private boolean hasRepeats;
    private PhraseQueue pq;
    private PhrasePositions[] nrPps;

    SloppyPhraseScorer(Weight weight, PhraseQuery.PostingsAndFreq[] postingsAndFreqArray, Similarity similarity, int n, byte[] byArray) {
        super(weight, postingsAndFreqArray, similarity, byArray);
        this.slop = n;
    }

    @Override
    protected float phraseFreq() throws IOException {
        int n;
        int n2 = this.initPhrasePositions();
        if (n2 == Integer.MIN_VALUE) {
            return 0.0f;
        }
        float f = 0.0f;
        PhrasePositions phrasePositions = (PhrasePositions)this.pq.pop();
        int n3 = n2 - phrasePositions.position;
        int n4 = n = this.pq.size() > 0 ? ((PhrasePositions)this.pq.top()).position : phrasePositions.position;
        while (phrasePositions.nextPosition() && (n2 = this.advanceRepeats(phrasePositions, n2)) != Integer.MIN_VALUE) {
            if (phrasePositions.position > n) {
                if (n3 <= this.slop) {
                    f += this.getSimilarity().sloppyFreq(n3);
                }
                this.pq.add(phrasePositions);
                phrasePositions = (PhrasePositions)this.pq.pop();
                n = this.pq.size() > 0 ? ((PhrasePositions)this.pq.top()).position : phrasePositions.position;
                n3 = n2 - phrasePositions.position;
                continue;
            }
            int n5 = n2 - phrasePositions.position;
            if (n5 >= n3) continue;
            n3 = n5;
        }
        if (n3 <= this.slop) {
            f += this.getSimilarity().sloppyFreq(n3);
        }
        return f;
    }

    private int advanceRepeats(PhrasePositions phrasePositions, int n) throws IOException {
        int n2 = n;
        if (phrasePositions.position > n2) {
            n2 = phrasePositions.position;
        }
        if (!this.hasRepeats) {
            return n2;
        }
        int n3 = this.tpPos(phrasePositions);
        PhrasePositions phrasePositions2 = phrasePositions.nextRepeating;
        while (phrasePositions2 != null) {
            while (this.tpPos(phrasePositions2) <= n3) {
                if (phrasePositions2.nextPosition()) continue;
                return Integer.MIN_VALUE;
            }
            n3 = this.tpPos(phrasePositions2);
            if (phrasePositions2.position > n2) {
                n2 = phrasePositions2.position;
            }
            if (phrasePositions2.position < phrasePositions.position) {
                phrasePositions.position = phrasePositions2.position;
            }
            phrasePositions2 = phrasePositions2.nextRepeating;
        }
        return n2;
    }

    private int initPhrasePositions() throws IOException {
        int n = Integer.MIN_VALUE;
        if (this.checkedRepeats && !this.hasRepeats) {
            this.pq.clear();
            PhrasePositions phrasePositions = this.min;
            PhrasePositions phrasePositions2 = null;
            while (phrasePositions2 != this.max) {
                phrasePositions.firstPosition();
                if (phrasePositions.position > n) {
                    n = phrasePositions.position;
                }
                this.pq.add(phrasePositions);
                phrasePositions2 = phrasePositions;
                phrasePositions = phrasePositions2.next;
            }
            return n;
        }
        Object object = this.min;
        Object object2 = null;
        while (object2 != this.max) {
            ((PhrasePositions)object).firstPosition();
            object2 = object;
            object = ((PhrasePositions)object).next;
        }
        if (!this.checkedRepeats) {
            this.checkedRepeats = true;
            object = new ArrayList();
            object2 = new PhrasePositions(null, -1, -1);
            PhrasePositions phrasePositions = this.min;
            PhrasePositions phrasePositions3 = null;
            while (phrasePositions3 != this.max) {
                if (phrasePositions.nextRepeating == null) {
                    ((ArrayList)object).add(phrasePositions);
                    int n2 = this.tpPos(phrasePositions);
                    PhrasePositions phrasePositions4 = phrasePositions;
                    PhrasePositions phrasePositions5 = phrasePositions.next;
                    while (phrasePositions5 != this.min) {
                        if (phrasePositions5.nextRepeating == null && phrasePositions.offset != phrasePositions5.offset && this.tpPos(phrasePositions5) == n2) {
                            this.hasRepeats = true;
                            phrasePositions4.nextRepeating = phrasePositions5;
                            phrasePositions5.nextRepeating = object2;
                            phrasePositions4 = phrasePositions5;
                        }
                        phrasePositions5 = phrasePositions5.next;
                    }
                }
                phrasePositions3 = phrasePositions;
                phrasePositions = phrasePositions3.next;
            }
            if (this.hasRepeats) {
                phrasePositions = this.min;
                phrasePositions3 = null;
                while (phrasePositions3 != this.max) {
                    if (phrasePositions.nextRepeating == object2) {
                        phrasePositions.nextRepeating = null;
                    }
                    phrasePositions3 = phrasePositions;
                    phrasePositions = phrasePositions3.next;
                }
            }
            this.nrPps = ((ArrayList)object).toArray(new PhrasePositions[0]);
            this.pq = new PhraseQueue(this.nrPps.length);
        }
        if (this.hasRepeats) {
            for (PhrasePositions phrasePositions3 : this.nrPps) {
                if ((n = this.advanceRepeats(phrasePositions3, n)) != Integer.MIN_VALUE) continue;
                return Integer.MIN_VALUE;
            }
        }
        this.pq.clear();
        for (PhrasePositions phrasePositions3 : this.nrPps) {
            if (phrasePositions3.position > n) {
                n = phrasePositions3.position;
            }
            this.pq.add(phrasePositions3);
        }
        return n;
    }

    private final int tpPos(PhrasePositions phrasePositions) {
        return phrasePositions.position + phrasePositions.offset;
    }
}

