/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.SpanFilter;
import org.apache.lucene.search.SpanFilterResult;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.FixedBitSet;

public class SpanQueryFilter
extends SpanFilter {
    protected SpanQuery query;

    protected SpanQueryFilter() {
    }

    public SpanQueryFilter(SpanQuery spanQuery) {
        this.query = spanQuery;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
        SpanFilterResult spanFilterResult = this.bitSpans(indexReader);
        return spanFilterResult.getDocIdSet();
    }

    @Override
    public SpanFilterResult bitSpans(IndexReader indexReader) throws IOException {
        FixedBitSet fixedBitSet = new FixedBitSet(indexReader.maxDoc());
        Spans spans = this.query.getSpans(indexReader);
        ArrayList<SpanFilterResult.PositionInfo> arrayList = new ArrayList<SpanFilterResult.PositionInfo>(20);
        int n = -1;
        SpanFilterResult.PositionInfo positionInfo = null;
        while (spans.next()) {
            int n2 = spans.doc();
            fixedBitSet.set(n2);
            if (n != n2) {
                positionInfo = new SpanFilterResult.PositionInfo(n2);
                arrayList.add(positionInfo);
                n = n2;
            }
            positionInfo.addPosition(spans.start(), spans.end());
        }
        return new SpanFilterResult(fixedBitSet, arrayList);
    }

    public SpanQuery getQuery() {
        return this.query;
    }

    public String toString() {
        return "SpanQueryFilter(" + this.query + ")";
    }

    public boolean equals(Object object) {
        return object instanceof SpanQueryFilter && this.query.equals(((SpanQueryFilter)object).query);
    }

    public int hashCode() {
        return this.query.hashCode() ^ 0x923F64B9;
    }
}

