/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.PriorityQueue;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermCollectingRewrite;

public abstract class TopTermsRewrite<Q extends Query>
extends TermCollectingRewrite<Q> {
    private final int size;

    public TopTermsRewrite(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    protected abstract int getMaxSize();

    public Q rewrite(IndexReader indexReader, MultiTermQuery multiTermQuery) throws IOException {
        final int n = Math.min(this.size, this.getMaxSize());
        final PriorityQueue priorityQueue = new PriorityQueue();
        this.collectTerms(indexReader, multiTermQuery, new TermCollectingRewrite.TermCollector(){
            private ScoreTerm st = new ScoreTerm();

            @Override
            public boolean collect(Term term, float f) {
                if (priorityQueue.size() >= n && f <= ((ScoreTerm)priorityQueue.peek()).boost) {
                    return true;
                }
                this.st.term = term;
                this.st.boost = f;
                priorityQueue.offer(this.st);
                this.st = priorityQueue.size() > n ? (ScoreTerm)priorityQueue.poll() : new ScoreTerm();
                return true;
            }
        });
        Object q = this.getTopLevelQuery();
        for (ScoreTerm scoreTerm : priorityQueue) {
            this.addClause(q, scoreTerm.term, multiTermQuery.getBoost() * scoreTerm.boost);
        }
        multiTermQuery.incTotalNumberOfTerms(priorityQueue.size());
        return q;
    }

    public int hashCode() {
        return 31 * this.size;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TopTermsRewrite topTermsRewrite = (TopTermsRewrite)object;
        return this.size == topTermsRewrite.size;
    }

    private static class ScoreTerm
    implements Comparable<ScoreTerm> {
        public Term term;
        public float boost;

        private ScoreTerm() {
        }

        @Override
        public int compareTo(ScoreTerm scoreTerm) {
            if (this.boost == scoreTerm.boost) {
                return scoreTerm.term.compareTo(this.term);
            }
            return Float.compare(this.boost, scoreTerm.boost);
        }
    }
}

