/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import org.apache.lucene.search.Explanation;

public abstract class DocValues {
    private float minVal = Float.NaN;
    private float maxVal = Float.NaN;
    private float avgVal = Float.NaN;
    private boolean computed = false;

    public abstract float floatVal(int var1);

    public int intVal(int n) {
        return (int)this.floatVal(n);
    }

    public long longVal(int n) {
        return (long)this.floatVal(n);
    }

    public double doubleVal(int n) {
        return this.floatVal(n);
    }

    public String strVal(int n) {
        return Float.toString(this.floatVal(n));
    }

    public abstract String toString(int var1);

    public Explanation explain(int n) {
        return new Explanation(this.floatVal(n), this.toString(n));
    }

    Object getInnerArray() {
        throw new UnsupportedOperationException("this optional method is for test purposes only");
    }

    private void compute() {
        if (this.computed) {
            return;
        }
        float f = 0.0f;
        int n = 0;
        while (true) {
            float f2;
            try {
                f2 = this.floatVal(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
            f += f2;
            this.minVal = Float.isNaN(this.minVal) ? f2 : Math.min(this.minVal, f2);
            this.maxVal = Float.isNaN(this.maxVal) ? f2 : Math.max(this.maxVal, f2);
            ++n;
        }
        this.avgVal = n == 0 ? Float.NaN : f / (float)n;
        this.computed = true;
    }

    public float getMinValue() {
        this.compute();
        return this.minVal;
    }

    public float getMaxValue() {
        this.compute();
        return this.maxVal;
    }

    public float getAverageValue() {
        this.compute();
        return this.avgVal;
    }
}

