/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.ValueSource;

public class ReverseOrdFieldSource
extends ValueSource {
    public String field;
    private static final int hcode = ReverseOrdFieldSource.class.hashCode();

    public ReverseOrdFieldSource(String string) {
        this.field = string;
    }

    @Override
    public String description() {
        return "rord(" + this.field + ')';
    }

    @Override
    public DocValues getValues(IndexReader indexReader) throws IOException {
        FieldCache.StringIndex stringIndex = FieldCache.DEFAULT.getStringIndex(indexReader, this.field);
        final int[] nArray = stringIndex.order;
        final int n = stringIndex.lookup.length;
        return new DocValues(){

            @Override
            public float floatVal(int n2) {
                return n - nArray[n2];
            }

            @Override
            public int intVal(int n2) {
                return n - nArray[n2];
            }

            @Override
            public String strVal(int n2) {
                return Integer.toString(this.intVal(n2));
            }

            @Override
            public String toString(int n2) {
                return ReverseOrdFieldSource.this.description() + '=' + this.strVal(n2);
            }

            @Override
            Object getInnerArray() {
                return nArray;
            }
        };
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != ReverseOrdFieldSource.class) {
            return false;
        }
        ReverseOrdFieldSource reverseOrdFieldSource = (ReverseOrdFieldSource)object;
        return this.field.equals(reverseOrdFieldSource.field);
    }

    @Override
    public int hashCode() {
        return hcode + this.field.hashCode();
    }
}

