/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ArrayUtil;

public class NearSpansOrdered
extends Spans {
    private final int allowedSlop;
    private boolean firstTime = true;
    private boolean more = false;
    private final Spans[] subSpans;
    private boolean inSameDoc = false;
    private int matchDoc = -1;
    private int matchStart = -1;
    private int matchEnd = -1;
    private List<byte[]> matchPayload;
    private final Spans[] subSpansByDoc;
    private final Comparator<Spans> spanDocComparator = new Comparator<Spans>(){

        @Override
        public int compare(Spans spans, Spans spans2) {
            return spans.doc() - spans2.doc();
        }
    };
    private SpanNearQuery query;
    private boolean collectPayloads = true;

    public NearSpansOrdered(SpanNearQuery spanNearQuery, IndexReader indexReader) throws IOException {
        this(spanNearQuery, indexReader, true);
    }

    public NearSpansOrdered(SpanNearQuery spanNearQuery, IndexReader indexReader, boolean bl) throws IOException {
        if (spanNearQuery.getClauses().length < 2) {
            throw new IllegalArgumentException("Less than 2 clauses: " + spanNearQuery);
        }
        this.collectPayloads = bl;
        this.allowedSlop = spanNearQuery.getSlop();
        SpanQuery[] spanQueryArray = spanNearQuery.getClauses();
        this.subSpans = new Spans[spanQueryArray.length];
        this.matchPayload = new LinkedList<byte[]>();
        this.subSpansByDoc = new Spans[spanQueryArray.length];
        for (int i = 0; i < spanQueryArray.length; ++i) {
            this.subSpans[i] = spanQueryArray[i].getSpans(indexReader);
            this.subSpansByDoc[i] = this.subSpans[i];
        }
        this.query = spanNearQuery;
    }

    @Override
    public int doc() {
        return this.matchDoc;
    }

    @Override
    public int start() {
        return this.matchStart;
    }

    @Override
    public int end() {
        return this.matchEnd;
    }

    public Spans[] getSubSpans() {
        return this.subSpans;
    }

    @Override
    public Collection<byte[]> getPayload() throws IOException {
        return this.matchPayload;
    }

    @Override
    public boolean isPayloadAvailable() {
        return !this.matchPayload.isEmpty();
    }

    @Override
    public boolean next() throws IOException {
        if (this.firstTime) {
            this.firstTime = false;
            for (int i = 0; i < this.subSpans.length; ++i) {
                if (this.subSpans[i].next()) continue;
                this.more = false;
                return false;
            }
            this.more = true;
        }
        if (this.collectPayloads) {
            this.matchPayload.clear();
        }
        return this.advanceAfterOrdered();
    }

    @Override
    public boolean skipTo(int n) throws IOException {
        if (this.firstTime) {
            this.firstTime = false;
            for (int i = 0; i < this.subSpans.length; ++i) {
                if (this.subSpans[i].skipTo(n)) continue;
                this.more = false;
                return false;
            }
            this.more = true;
        } else if (this.more && this.subSpans[0].doc() < n) {
            if (this.subSpans[0].skipTo(n)) {
                this.inSameDoc = false;
            } else {
                this.more = false;
                return false;
            }
        }
        if (this.collectPayloads) {
            this.matchPayload.clear();
        }
        return this.advanceAfterOrdered();
    }

    private boolean advanceAfterOrdered() throws IOException {
        while (this.more && (this.inSameDoc || this.toSameDoc())) {
            if (!this.stretchToOrder() || !this.shrinkToAfterShortestMatch()) continue;
            return true;
        }
        return false;
    }

    private boolean toSameDoc() throws IOException {
        ArrayUtil.mergeSort(this.subSpansByDoc, this.spanDocComparator);
        int n = 0;
        int n2 = this.subSpansByDoc[this.subSpansByDoc.length - 1].doc();
        while (this.subSpansByDoc[n].doc() != n2) {
            if (!this.subSpansByDoc[n].skipTo(n2)) {
                this.more = false;
                this.inSameDoc = false;
                return false;
            }
            n2 = this.subSpansByDoc[n].doc();
            if (++n != this.subSpansByDoc.length) continue;
            n = 0;
        }
        for (int i = 0; i < this.subSpansByDoc.length; ++i) {
            assert (this.subSpansByDoc[i].doc() == n2) : " NearSpansOrdered.toSameDoc() spans " + this.subSpansByDoc[0] + "\n at doc " + this.subSpansByDoc[i].doc() + ", but should be at " + n2;
        }
        this.inSameDoc = true;
        return true;
    }

    static final boolean docSpansOrdered(Spans spans, Spans spans2) {
        int n;
        assert (spans.doc() == spans2.doc()) : "doc1 " + spans.doc() + " != doc2 " + spans2.doc();
        int n2 = spans.start();
        return n2 == (n = spans2.start()) ? spans.end() < spans2.end() : n2 < n;
    }

    private static final boolean docSpansOrdered(int n, int n2, int n3, int n4) {
        return n == n3 ? n2 < n4 : n < n3;
    }

    private boolean stretchToOrder() throws IOException {
        this.matchDoc = this.subSpans[0].doc();
        block0: for (int i = 1; this.inSameDoc && i < this.subSpans.length; ++i) {
            while (!NearSpansOrdered.docSpansOrdered(this.subSpans[i - 1], this.subSpans[i])) {
                if (!this.subSpans[i].next()) {
                    this.inSameDoc = false;
                    this.more = false;
                    continue block0;
                }
                if (this.matchDoc == this.subSpans[i].doc()) continue;
                this.inSameDoc = false;
                continue block0;
            }
        }
        return this.inSameDoc;
    }

    private boolean shrinkToAfterShortestMatch() throws IOException {
        int n;
        this.matchStart = this.subSpans[this.subSpans.length - 1].start();
        this.matchEnd = this.subSpans[this.subSpans.length - 1].end();
        HashSet<Object> hashSet = new HashSet<Object>();
        if (this.subSpans[this.subSpans.length - 1].isPayloadAvailable()) {
            hashSet.addAll(this.subSpans[this.subSpans.length - 1].getPayload());
        }
        ArrayList<byte[]> arrayList = null;
        int n2 = 0;
        int n3 = this.matchStart;
        int n4 = this.matchEnd;
        for (n = this.subSpans.length - 2; n >= 0; --n) {
            Spans spans = this.subSpans[n];
            if (this.collectPayloads && spans.isPayloadAvailable()) {
                Collection<byte[]> collection = spans.getPayload();
                arrayList = new ArrayList<byte[]>(collection.size());
                arrayList.addAll(collection);
            }
            int n5 = spans.start();
            int n6 = spans.end();
            while (true) {
                int n7;
                if (!spans.next()) {
                    this.inSameDoc = false;
                    this.more = false;
                    break;
                }
                if (this.matchDoc != spans.doc()) {
                    this.inSameDoc = false;
                    break;
                }
                int n8 = spans.start();
                if (!NearSpansOrdered.docSpansOrdered(n8, n7 = spans.end(), n3, n4)) break;
                n5 = n8;
                n6 = n7;
                if (!this.collectPayloads || !spans.isPayloadAvailable()) continue;
                Collection<byte[]> collection = spans.getPayload();
                arrayList = new ArrayList(collection.size());
                arrayList.addAll(collection);
            }
            if (this.collectPayloads && arrayList != null) {
                hashSet.addAll(arrayList);
            }
            assert (n5 <= this.matchStart);
            if (this.matchStart > n6) {
                n2 += this.matchStart - n6;
            }
            this.matchStart = n5;
            n3 = n5;
            n4 = n6;
        }
        int n9 = n = n2 <= this.allowedSlop ? 1 : 0;
        if (this.collectPayloads && n != 0 && hashSet.size() > 0) {
            this.matchPayload.addAll(hashSet);
        }
        return n != 0;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.query.toString() + ")@" + (this.firstTime ? "START" : (this.more ? this.doc() + ":" + this.start() + "-" + this.end() : "END"));
    }
}

