/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.ToStringUtils;

public class SpanOrQuery
extends SpanQuery
implements Cloneable {
    private List<SpanQuery> clauses;
    private String field;

    public SpanOrQuery(SpanQuery ... spanQueryArray) {
        this.clauses = new ArrayList<SpanQuery>(spanQueryArray.length);
        for (int i = 0; i < spanQueryArray.length; ++i) {
            this.addClause(spanQueryArray[i]);
        }
    }

    public final void addClause(SpanQuery spanQuery) {
        if (this.field == null) {
            this.field = spanQuery.getField();
        } else if (!spanQuery.getField().equals(this.field)) {
            throw new IllegalArgumentException("Clauses must have same field.");
        }
        this.clauses.add(spanQuery);
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void extractTerms(Set<Term> set) {
        for (SpanQuery spanQuery : this.clauses) {
            spanQuery.extractTerms(set);
        }
    }

    @Override
    public Object clone() {
        int n = this.clauses.size();
        SpanQuery[] spanQueryArray = new SpanQuery[n];
        for (int i = 0; i < n; ++i) {
            spanQueryArray[i] = (SpanQuery)this.clauses.get(i).clone();
        }
        SpanOrQuery spanOrQuery = new SpanOrQuery(spanQueryArray);
        spanOrQuery.setBoost(this.getBoost());
        return spanOrQuery;
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        SpanOrQuery spanOrQuery = null;
        for (int i = 0; i < this.clauses.size(); ++i) {
            SpanQuery spanQuery = this.clauses.get(i);
            SpanQuery spanQuery2 = (SpanQuery)spanQuery.rewrite(indexReader);
            if (spanQuery2 == spanQuery) continue;
            if (spanOrQuery == null) {
                spanOrQuery = (SpanOrQuery)this.clone();
            }
            spanOrQuery.clauses.set(i, spanQuery2);
        }
        if (spanOrQuery != null) {
            return spanOrQuery;
        }
        return this;
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("spanOr([");
        Iterator<SpanQuery> iterator = this.clauses.iterator();
        while (iterator.hasNext()) {
            SpanQuery spanQuery = iterator.next();
            stringBuilder.append(spanQuery.toString(string));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("])");
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SpanOrQuery spanOrQuery = (SpanOrQuery)object;
        if (!((Object)this.clauses).equals(spanOrQuery.clauses)) {
            return false;
        }
        if (!this.clauses.isEmpty() && !this.field.equals(spanOrQuery.field)) {
            return false;
        }
        return this.getBoost() == spanOrQuery.getBoost();
    }

    @Override
    public int hashCode() {
        int n = ((Object)this.clauses).hashCode();
        n ^= n << 10 | n >>> 23;
        return n ^= Float.floatToRawIntBits(this.getBoost());
    }

    @Override
    public Spans getSpans(final IndexReader indexReader) throws IOException {
        if (this.clauses.size() == 1) {
            return this.clauses.get(0).getSpans(indexReader);
        }
        return new Spans(){
            private SpanQueue queue = null;

            private boolean initSpanQueue(int n) throws IOException {
                this.queue = new SpanQueue(SpanOrQuery.this.clauses.size());
                Iterator iterator = SpanOrQuery.this.clauses.iterator();
                while (iterator.hasNext()) {
                    Spans spans = ((SpanQuery)iterator.next()).getSpans(indexReader);
                    if ((n != -1 || !spans.next()) && (n == -1 || !spans.skipTo(n))) continue;
                    this.queue.add(spans);
                }
                return this.queue.size() != 0;
            }

            @Override
            public boolean next() throws IOException {
                if (this.queue == null) {
                    return this.initSpanQueue(-1);
                }
                if (this.queue.size() == 0) {
                    return false;
                }
                if (this.top().next()) {
                    this.queue.updateTop();
                    return true;
                }
                this.queue.pop();
                return this.queue.size() != 0;
            }

            private Spans top() {
                return (Spans)this.queue.top();
            }

            @Override
            public boolean skipTo(int n) throws IOException {
                if (this.queue == null) {
                    return this.initSpanQueue(n);
                }
                boolean bl = false;
                while (this.queue.size() != 0 && this.top().doc() < n) {
                    if (this.top().skipTo(n)) {
                        this.queue.updateTop();
                    } else {
                        this.queue.pop();
                    }
                    bl = true;
                }
                if (bl) {
                    return this.queue.size() != 0;
                }
                return this.next();
            }

            @Override
            public int doc() {
                return this.top().doc();
            }

            @Override
            public int start() {
                return this.top().start();
            }

            @Override
            public int end() {
                return this.top().end();
            }

            @Override
            public Collection<byte[]> getPayload() throws IOException {
                ArrayList<byte[]> arrayList = null;
                Spans spans = this.top();
                if (spans != null && spans.isPayloadAvailable()) {
                    arrayList = new ArrayList<byte[]>(spans.getPayload());
                }
                return arrayList;
            }

            @Override
            public boolean isPayloadAvailable() {
                Spans spans = this.top();
                return spans != null && spans.isPayloadAvailable();
            }

            public String toString() {
                return "spans(" + SpanOrQuery.this + ")@" + (this.queue == null ? "START" : (this.queue.size() > 0 ? this.doc() + ":" + this.start() + "-" + this.end() : "END"));
            }
        };
    }

    private class SpanQueue
    extends PriorityQueue<Spans> {
        public SpanQueue(int n) {
            this.initialize(n);
        }

        @Override
        protected final boolean lessThan(Spans spans, Spans spans2) {
            if (spans.doc() == spans2.doc()) {
                if (spans.start() == spans2.start()) {
                    return spans.end() < spans2.end();
                }
                return spans.start() < spans2.start();
            }
            return spans.doc() < spans2.doc();
        }
    }
}

