/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.spans.TermSpans;
import org.apache.lucene.util.ToStringUtils;

public class SpanTermQuery
extends SpanQuery {
    protected Term term;

    public SpanTermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public String getField() {
        return this.term.field();
    }

    @Override
    public void extractTerms(Set<Term> set) {
        set.add(this.term);
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.term.field().equals(string)) {
            stringBuilder.append(this.term.text());
        } else {
            stringBuilder.append(this.term.toString());
        }
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.term == null ? 0 : this.term.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SpanTermQuery spanTermQuery = (SpanTermQuery)object;
        return !(this.term == null ? spanTermQuery.term != null : !this.term.equals(spanTermQuery.term));
    }

    @Override
    public Spans getSpans(IndexReader indexReader) throws IOException {
        return new TermSpans(indexReader.termPositions(this.term), this.term);
    }
}

