/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;

public abstract class BufferedIndexOutput
extends IndexOutput {
    static final int BUFFER_SIZE = 16384;
    private final byte[] buffer = new byte[16384];
    private long bufferStart = 0L;
    private int bufferPosition = 0;

    @Override
    public void writeByte(byte by) throws IOException {
        if (this.bufferPosition >= 16384) {
            this.flush();
        }
        this.buffer[this.bufferPosition++] = by;
    }

    @Override
    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 16384 - this.bufferPosition;
        if (n3 >= n2) {
            System.arraycopy(byArray, n, this.buffer, this.bufferPosition, n2);
            this.bufferPosition += n2;
            if (16384 - this.bufferPosition == 0) {
                this.flush();
            }
        } else if (n2 > 16384) {
            if (this.bufferPosition > 0) {
                this.flush();
            }
            this.flushBuffer(byArray, n, n2);
            this.bufferStart += (long)n2;
        } else {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n2 - n4 < n3 ? n2 - n4 : n3;
                System.arraycopy(byArray, n4 + n, this.buffer, this.bufferPosition, n5);
                n4 += n5;
                this.bufferPosition += n5;
                n3 = 16384 - this.bufferPosition;
                if (n3 != 0) continue;
                this.flush();
                n3 = 16384;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer(this.buffer, this.bufferPosition);
        this.bufferStart += (long)this.bufferPosition;
        this.bufferPosition = 0;
    }

    private void flushBuffer(byte[] byArray, int n) throws IOException {
        this.flushBuffer(byArray, 0, n);
    }

    protected abstract void flushBuffer(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    @Override
    public void seek(long l) throws IOException {
        this.flush();
        this.bufferStart = l;
    }

    @Override
    public abstract long length() throws IOException;
}

