/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.Constants;

public class MMapDirectory
extends FSDirectory {
    private boolean useUnmapHack = UNMAP_SUPPORTED;
    public static final int DEFAULT_MAX_BUFF;
    private int chunkSizePower;
    public static final boolean UNMAP_SUPPORTED;

    public MMapDirectory(File file, LockFactory lockFactory) throws IOException {
        super(file, lockFactory);
        this.setMaxChunkSize(DEFAULT_MAX_BUFF);
    }

    public MMapDirectory(File file) throws IOException {
        super(file, null);
        this.setMaxChunkSize(DEFAULT_MAX_BUFF);
    }

    public void setUseUnmap(boolean bl) {
        if (bl && !UNMAP_SUPPORTED) {
            throw new IllegalArgumentException("Unmap hack not supported on this platform!");
        }
        this.useUnmapHack = bl;
    }

    public boolean getUseUnmap() {
        return this.useUnmapHack;
    }

    final void cleanMapping(final ByteBuffer byteBuffer) throws IOException {
        if (this.useUnmapHack) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Method method = byteBuffer.getClass().getMethod("cleaner", new Class[0]);
                        method.setAccessible(true);
                        Object object = method.invoke((Object)byteBuffer, new Object[0]);
                        if (object != null) {
                            object.getClass().getMethod("clean", new Class[0]).invoke(object, new Object[0]);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                IOException iOException = new IOException("unable to unmap the mapped buffer");
                iOException.initCause(privilegedActionException.getCause());
                throw iOException;
            }
        }
    }

    public final void setMaxChunkSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Maximum chunk size for mmap must be >0");
        }
        this.chunkSizePower = 31 - Integer.numberOfLeadingZeros(n);
        assert (this.chunkSizePower >= 0 && this.chunkSizePower <= 30);
    }

    public final int getMaxChunkSize() {
        return 1 << this.chunkSizePower;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexInput openInput(String string, int n) throws IOException {
        this.ensureOpen();
        File file = new File(this.getDirectory(), string);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            MMapIndexInput mMapIndexInput = new MMapIndexInput("MMapIndexInput(path=\"" + file + "\")", randomAccessFile, this.chunkSizePower);
            return mMapIndexInput;
        }
        finally {
            randomAccessFile.close();
        }
    }

    static {
        boolean bl;
        DEFAULT_MAX_BUFF = Constants.JRE_IS_64BIT ? 0x40000000 : 0x10000000;
        try {
            Class.forName("sun.misc.Cleaner");
            Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        UNMAP_SUPPORTED = bl;
    }

    private final class MMapIndexInput
    extends IndexInput {
        private ByteBuffer[] buffers;
        private final long length;
        private final long chunkSizeMask;
        private final long chunkSize;
        private final int chunkSizePower;
        private int curBufIndex;
        private ByteBuffer curBuf;
        private boolean isClone;

        MMapIndexInput(String string, RandomAccessFile randomAccessFile, int n) throws IOException {
            super(string);
            this.isClone = false;
            this.length = randomAccessFile.length();
            this.chunkSizePower = n;
            this.chunkSize = 1L << n;
            this.chunkSizeMask = this.chunkSize - 1L;
            if (n < 0 || n > 30) {
                throw new IllegalArgumentException("Invalid chunkSizePower used for ByteBuffer size: " + n);
            }
            if (this.length >>> n >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("RandomAccessFile too big for chunk size: " + randomAccessFile.toString());
            }
            int n2 = (int)(this.length >>> n) + 1;
            this.buffers = new ByteBuffer[n2];
            long l = 0L;
            FileChannel fileChannel = randomAccessFile.getChannel();
            for (int i = 0; i < n2; ++i) {
                int n3 = (int)(this.length > l + this.chunkSize ? this.chunkSize : this.length - l);
                this.buffers[i] = fileChannel.map(FileChannel.MapMode.READ_ONLY, l, n3);
                l += (long)n3;
            }
            this.seek(0L);
        }

        @Override
        public byte readByte() throws IOException {
            try {
                return this.curBuf.get();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                do {
                    ++this.curBufIndex;
                    if (this.curBufIndex >= this.buffers.length) {
                        throw new IOException("read past EOF: " + this);
                    }
                    this.curBuf = this.buffers[this.curBufIndex];
                    this.curBuf.position(0);
                } while (!this.curBuf.hasRemaining());
                return this.curBuf.get();
            }
        }

        @Override
        public void readBytes(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.curBuf.get(byArray, n, n2);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                int n3 = this.curBuf.remaining();
                while (n2 > n3) {
                    this.curBuf.get(byArray, n, n3);
                    n2 -= n3;
                    n += n3;
                    ++this.curBufIndex;
                    if (this.curBufIndex >= this.buffers.length) {
                        throw new IOException("read past EOF: " + this);
                    }
                    this.curBuf = this.buffers[this.curBufIndex];
                    this.curBuf.position(0);
                    n3 = this.curBuf.remaining();
                }
                this.curBuf.get(byArray, n, n2);
            }
        }

        @Override
        public int readInt() throws IOException {
            try {
                return this.curBuf.getInt();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                return super.readInt();
            }
        }

        @Override
        public long readLong() throws IOException {
            try {
                return this.curBuf.getLong();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                return super.readLong();
            }
        }

        @Override
        public long getFilePointer() {
            return ((long)this.curBufIndex << this.chunkSizePower) + (long)this.curBuf.position();
        }

        @Override
        public void seek(long l) throws IOException {
            int n = (int)(l >> this.chunkSizePower);
            try {
                ByteBuffer byteBuffer = this.buffers[n];
                byteBuffer.position((int)(l & this.chunkSizeMask));
                this.curBufIndex = n;
                this.curBuf = byteBuffer;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (l < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this);
                }
                throw new IOException("seek past EOF");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (l < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this);
                }
                throw new IOException("seek past EOF: " + this);
            }
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public Object clone() {
            if (this.buffers == null) {
                throw new AlreadyClosedException("MMapIndexInput already closed: " + this);
            }
            MMapIndexInput mMapIndexInput = (MMapIndexInput)super.clone();
            mMapIndexInput.isClone = true;
            mMapIndexInput.buffers = new ByteBuffer[this.buffers.length];
            for (int i = 0; i < this.buffers.length; ++i) {
                mMapIndexInput.buffers[i] = this.buffers[i].duplicate();
            }
            try {
                mMapIndexInput.seek(this.getFilePointer());
            }
            catch (IOException iOException) {
                throw new RuntimeException("Should never happen: " + this, iOException);
            }
            return mMapIndexInput;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                if (this.isClone || this.buffers == null) {
                    return;
                }
                for (int i = 0; i < this.buffers.length; ++i) {
                    try {
                        MMapDirectory.this.cleanMapping(this.buffers[i]);
                        continue;
                    }
                    finally {
                        this.buffers[i] = null;
                    }
                }
            }
            finally {
                this.buffers = null;
            }
        }
    }
}

