/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SimpleFSDirectory;

public class NIOFSDirectory
extends FSDirectory {
    public NIOFSDirectory(File file, LockFactory lockFactory) throws IOException {
        super(file, lockFactory);
    }

    public NIOFSDirectory(File file) throws IOException {
        super(file, null);
    }

    @Override
    public IndexInput openInput(String string, int n) throws IOException {
        this.ensureOpen();
        return new NIOFSIndexInput(new File(this.getDirectory(), string), n, this.getReadChunkSize());
    }

    protected static class NIOFSIndexInput
    extends SimpleFSDirectory.SimpleFSIndexInput {
        private ByteBuffer byteBuf;
        private byte[] otherBuffer;
        private ByteBuffer otherByteBuf;
        final FileChannel channel;

        public NIOFSIndexInput(File file, int n, int n2) throws IOException {
            super("NIOFSIndexInput(path=\"" + file + "\")", file, n, n2);
            this.channel = this.file.getChannel();
        }

        @Override
        protected void newBuffer(byte[] byArray) {
            super.newBuffer(byArray);
            this.byteBuf = ByteBuffer.wrap(byArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (!this.isClone && this.file.isOpen) {
                try {
                    this.channel.close();
                }
                finally {
                    this.file.close();
                }
            }
        }

        @Override
        protected void readInternal(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            ByteBuffer byteBuffer;
            if (byArray == this.buffer && 0 == n) {
                assert (this.byteBuf != null);
                this.byteBuf.clear();
                this.byteBuf.limit(n2);
                byteBuffer = this.byteBuf;
            } else if (n == 0) {
                if (this.otherBuffer != byArray) {
                    this.otherBuffer = byArray;
                    this.otherByteBuf = ByteBuffer.wrap(byArray);
                } else {
                    this.otherByteBuf.clear();
                }
                this.otherByteBuf.limit(n2);
                byteBuffer = this.otherByteBuf;
            } else {
                byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            }
            int n4 = byteBuffer.position();
            assert (n3 == n2);
            long l = this.getFilePointer();
            try {
                int n5;
                for (n3 = byteBuffer.limit() - n4; n3 > 0; n3 -= n5) {
                    int n6 = n3 > this.chunkSize ? n4 + this.chunkSize : n4 + n3;
                    byteBuffer.limit(n6);
                    n5 = this.channel.read(byteBuffer, l);
                    if (n5 == -1) {
                        throw new EOFException("read past EOF (resource: " + this + ")");
                    }
                    l += (long)n5;
                    n4 += n5;
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("OutOfMemoryError likely caused by the Sun VM Bug described in https://issues.apache.org/jira/browse/LUCENE-1566; try calling FSDirectory.setReadChunkSize with a value smaller than the current chunk size (" + this.chunkSize + ")");
                outOfMemoryError2.initCause(outOfMemoryError);
                throw outOfMemoryError2;
            }
            catch (IOException iOException) {
                IOException iOException2 = new IOException(iOException.getMessage() + ": " + this);
                iOException2.initCause(iOException);
                throw iOException2;
            }
        }
    }
}

