/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashSet;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockReleaseFailedException;

class NativeFSLock
extends Lock {
    private RandomAccessFile f;
    private FileChannel channel;
    private FileLock lock;
    private File path;
    private File lockDir;
    private static HashSet<String> LOCK_HELD = new HashSet();

    public NativeFSLock(File file, String string) {
        this.lockDir = file;
        this.path = new File(file, string);
    }

    private synchronized boolean lockExists() {
        return this.lock != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean obtain() throws IOException {
        block49: {
            if (this.lockExists()) {
                return false;
            }
            if (!this.lockDir.exists()) {
                if (!this.lockDir.mkdirs()) {
                    throw new IOException("Cannot create directory: " + this.lockDir.getAbsolutePath());
                }
            } else if (!this.lockDir.isDirectory()) {
                throw new IOException("Found regular file where directory expected: " + this.lockDir.getAbsolutePath());
            }
            String string = this.path.getCanonicalPath();
            boolean bl = false;
            try {
                HashSet<String> hashSet = LOCK_HELD;
                synchronized (hashSet) {
                    block48: {
                        if (!LOCK_HELD.contains(string)) break block48;
                        boolean bl2 = false;
                        return bl2;
                    }
                    LOCK_HELD.add(string);
                    bl = true;
                }
                try {
                    this.f = new RandomAccessFile(this.path, "rw");
                }
                catch (IOException iOException) {
                    this.failureReason = iOException;
                    this.f = null;
                }
                if (this.f == null) break block49;
                try {
                    this.channel = this.f.getChannel();
                    try {
                        this.lock = this.channel.tryLock();
                    }
                    catch (IOException iOException) {
                        this.failureReason = iOException;
                    }
                    finally {
                        if (this.lock == null) {
                            try {
                                this.channel.close();
                            }
                            finally {
                                this.channel = null;
                            }
                        }
                    }
                }
                finally {
                    if (this.channel == null) {
                        try {
                            this.f.close();
                        }
                        finally {
                            this.f = null;
                        }
                    }
                }
            }
            finally {
                if (bl && !this.lockExists()) {
                    HashSet<String> hashSet = LOCK_HELD;
                    synchronized (hashSet) {
                        if (LOCK_HELD.contains(string)) {
                            LOCK_HELD.remove(string);
                        }
                    }
                }
            }
        }
        return this.lockExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release() throws IOException {
        if (this.lockExists()) {
            try {
                this.lock.release();
            }
            finally {
                this.lock = null;
                try {
                    this.channel.close();
                }
                finally {
                    this.channel = null;
                    try {
                        this.f.close();
                    }
                    finally {
                        this.f = null;
                        HashSet<String> hashSet = LOCK_HELD;
                        synchronized (hashSet) {
                            LOCK_HELD.remove(this.path.getCanonicalPath());
                        }
                    }
                }
            }
            this.path.delete();
        } else {
            boolean bl = false;
            try {
                bl = this.obtain();
                if (!bl) {
                    throw new LockReleaseFailedException("Cannot forcefully unlock a NativeFSLock which is held by another indexer component: " + this.path);
                }
            }
            finally {
                if (bl) {
                    this.release();
                }
            }
        }
    }

    @Override
    public synchronized boolean isLocked() {
        if (this.lockExists()) {
            return true;
        }
        if (!this.path.exists()) {
            return false;
        }
        try {
            boolean bl = this.obtain();
            if (bl) {
                this.release();
            }
            return !bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String toString() {
        return "NativeFSLock@" + this.path;
    }
}

