/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;

public final class CodecUtil {
    private static final int CODEC_MAGIC = 1071082519;

    private CodecUtil() {
    }

    public static DataOutput writeHeader(DataOutput dataOutput, String string, int n) throws IOException {
        BytesRef bytesRef = new BytesRef(string);
        if (bytesRef.length != string.length() || bytesRef.length >= 128) {
            throw new IllegalArgumentException("codec must be simple ASCII, less than 128 characters in length [got " + string + "]");
        }
        dataOutput.writeInt(1071082519);
        dataOutput.writeString(string);
        dataOutput.writeInt(n);
        return dataOutput;
    }

    public static int headerLength(String string) {
        return 9 + string.length();
    }

    public static int checkHeader(DataInput dataInput, String string, int n, int n2) throws IOException {
        int n3 = dataInput.readInt();
        if (n3 != 1071082519) {
            throw new CorruptIndexException("codec header mismatch: actual header=" + n3 + " vs expected header=" + 1071082519 + " (resource: " + dataInput + ")");
        }
        String string2 = dataInput.readString();
        if (!string2.equals(string)) {
            throw new CorruptIndexException("codec mismatch: actual codec=" + string2 + " vs expected codec=" + string + " (resource: " + dataInput + ")");
        }
        int n4 = dataInput.readInt();
        if (n4 < n) {
            throw new IndexFormatTooOldException(dataInput, n4, n, n2);
        }
        if (n4 > n2) {
            throw new IndexFormatTooNewException(dataInput, n4, n, n2);
        }
        return n4;
    }
}

