/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.ArrayUtil;

public final class IntsRef
implements Comparable<IntsRef> {
    public int[] ints;
    public int offset;
    public int length;

    public IntsRef() {
    }

    public IntsRef(int n) {
        this.ints = new int[n];
    }

    public IntsRef(int[] nArray, int n, int n2) {
        this.ints = nArray;
        this.offset = n;
        this.length = n2;
    }

    public IntsRef(IntsRef intsRef) {
        this.copy(intsRef);
    }

    public Object clone() {
        return new IntsRef(this);
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.offset + this.length;
        for (int i = this.offset; i < n2; ++i) {
            n = 31 * n + this.ints[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.intsEquals((IntsRef)object);
    }

    public boolean intsEquals(IntsRef intsRef) {
        if (this.length == intsRef.length) {
            int n = intsRef.offset;
            int[] nArray = intsRef.ints;
            int n2 = this.offset + this.length;
            int n3 = this.offset;
            while (n3 < n2) {
                if (this.ints[n3] != nArray[n]) {
                    return false;
                }
                ++n3;
                ++n;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(IntsRef intsRef) {
        if (this == intsRef) {
            return 0;
        }
        int[] nArray = this.ints;
        int n = this.offset;
        int[] nArray2 = intsRef.ints;
        int n2 = intsRef.offset;
        int n3 = n + Math.min(this.length, intsRef.length);
        while (n < n3) {
            int n4;
            int n5;
            if ((n5 = nArray[n++]) > (n4 = nArray2[n2++])) {
                return 1;
            }
            if (n5 >= n4) continue;
            return -1;
        }
        return this.length - intsRef.length;
    }

    public void copy(IntsRef intsRef) {
        this.ints = this.ints == null ? new int[intsRef.length] : ArrayUtil.grow(this.ints, intsRef.length);
        System.arraycopy(intsRef.ints, intsRef.offset, this.ints, 0, intsRef.length);
        this.length = intsRef.length;
        this.offset = 0;
    }

    public void grow(int n) {
        if (this.ints.length < n) {
            this.ints = ArrayUtil.grow(this.ints, n);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = this.offset + this.length;
        for (int i = this.offset; i < n; ++i) {
            if (i > this.offset) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(Integer.toHexString(this.ints[i]));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

