/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger threadPoolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private static final String NAME_PATTERN = "%s-%d-thread";
    private final String threadNamePrefix;

    public NamedThreadFactory(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.threadNamePrefix = String.format(NAME_PATTERN, NamedThreadFactory.checkPrefix(string), threadPoolNumber.getAndIncrement());
    }

    private static String checkPrefix(String string) {
        return string == null || string.length() == 0 ? "Lucene" : string;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.group, runnable, String.format("%s-%d", this.threadNamePrefix, this.threadNumber.getAndIncrement()), 0L);
        thread.setDaemon(false);
        thread.setPriority(5);
        return thread;
    }
}

