/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.util.TwoPhaseCommit;

public final class TwoPhaseCommitTool {
    private static void rollback(TwoPhaseCommit ... twoPhaseCommitArray) {
        for (TwoPhaseCommit twoPhaseCommit : twoPhaseCommitArray) {
            if (twoPhaseCommit == null) continue;
            try {
                twoPhaseCommit.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void execute(TwoPhaseCommit ... twoPhaseCommitArray) throws PrepareCommitFailException, CommitFailException {
        int n;
        TwoPhaseCommit twoPhaseCommit = null;
        try {
            for (n = 0; n < twoPhaseCommitArray.length; ++n) {
                twoPhaseCommit = twoPhaseCommitArray[n];
                if (twoPhaseCommit == null) continue;
                twoPhaseCommit.prepareCommit();
            }
        }
        catch (Throwable throwable) {
            TwoPhaseCommitTool.rollback(twoPhaseCommitArray);
            throw new PrepareCommitFailException(throwable, twoPhaseCommit);
        }
        try {
            for (n = 0; n < twoPhaseCommitArray.length; ++n) {
                twoPhaseCommit = twoPhaseCommitArray[n];
                if (twoPhaseCommit == null) continue;
                twoPhaseCommit.commit();
            }
        }
        catch (Throwable throwable) {
            TwoPhaseCommitTool.rollback(twoPhaseCommitArray);
            throw new CommitFailException(throwable, twoPhaseCommit);
        }
    }

    public static class CommitFailException
    extends IOException {
        public CommitFailException(Throwable throwable, TwoPhaseCommit twoPhaseCommit) {
            super("commit() failed on " + twoPhaseCommit);
            this.initCause(throwable);
        }
    }

    public static class PrepareCommitFailException
    extends IOException {
        public PrepareCommitFailException(Throwable throwable, TwoPhaseCommit twoPhaseCommit) {
            super("prepareCommit() failed on " + twoPhaseCommit);
            this.initCause(throwable);
        }
    }

    public static final class TwoPhaseCommitWrapper
    implements TwoPhaseCommit {
        private final TwoPhaseCommit tpc;
        private final Map<String, String> commitData;

        public TwoPhaseCommitWrapper(TwoPhaseCommit twoPhaseCommit, Map<String, String> map) {
            this.tpc = twoPhaseCommit;
            this.commitData = map;
        }

        @Override
        public void prepareCommit() throws IOException {
            this.prepareCommit(this.commitData);
        }

        @Override
        public void prepareCommit(Map<String, String> map) throws IOException {
            this.tpc.prepareCommit(this.commitData);
        }

        @Override
        public void commit() throws IOException {
            this.commit(this.commitData);
        }

        @Override
        public void commit(Map<String, String> map) throws IOException {
            this.tpc.commit(this.commitData);
        }

        @Override
        public void rollback() throws IOException {
            this.tpc.rollback();
        }
    }
}

