/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.NodeHash;
import org.apache.lucene.util.fst.Outputs;

public class Builder<T> {
    private final NodeHash<T> dedupHash;
    private final FST<T> fst;
    private final T NO_OUTPUT;
    private final int minSuffixCount1;
    private final int minSuffixCount2;
    private final boolean doShareNonSingletonNodes;
    private final int shareMaxTailLength;
    private final IntsRef lastInput = new IntsRef();
    private UnCompiledNode<T>[] frontier;
    private final IntsRef scratchIntsRef = new IntsRef(10);

    public Builder(FST.INPUT_TYPE iNPUT_TYPE, Outputs<T> outputs) {
        this(iNPUT_TYPE, 0, 0, true, true, Integer.MAX_VALUE, outputs);
    }

    public Builder(FST.INPUT_TYPE iNPUT_TYPE, int n, int n2, boolean bl, boolean bl2, int n3, Outputs<T> outputs) {
        this.minSuffixCount1 = n;
        this.minSuffixCount2 = n2;
        this.doShareNonSingletonNodes = bl2;
        this.shareMaxTailLength = n3;
        this.fst = new FST<T>(iNPUT_TYPE, outputs);
        this.dedupHash = bl ? new NodeHash<T>(this.fst) : null;
        this.NO_OUTPUT = outputs.getNoOutput();
        UnCompiledNode[] unCompiledNodeArray = new UnCompiledNode[10];
        this.frontier = unCompiledNodeArray;
        for (int i = 0; i < this.frontier.length; ++i) {
            this.frontier[i] = new UnCompiledNode(this, i);
        }
    }

    public int getTotStateCount() {
        return this.fst.nodeCount;
    }

    public long getTermCount() {
        return this.frontier[0].inputCount;
    }

    public int getMappedStateCount() {
        return this.dedupHash == null ? 0 : this.fst.nodeCount;
    }

    private CompiledNode compileNode(UnCompiledNode<T> unCompiledNode, int n) throws IOException {
        int n2 = this.dedupHash != null && (this.doShareNonSingletonNodes || unCompiledNode.numArcs <= 1) && n <= this.shareMaxTailLength ? (unCompiledNode.numArcs == 0 ? this.fst.addNode(unCompiledNode) : this.dedupHash.add(unCompiledNode)) : this.fst.addNode(unCompiledNode);
        assert (n2 != -2);
        unCompiledNode.clear();
        CompiledNode compiledNode = new CompiledNode();
        compiledNode.address = n2;
        return compiledNode;
    }

    private void compilePrevTail(int n) throws IOException {
        assert (n >= 1);
        for (int i = this.lastInput.length; i >= n; --i) {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = false;
            UnCompiledNode<T> unCompiledNode = this.frontier[i];
            UnCompiledNode unCompiledNode2 = this.frontier[i - 1];
            if (unCompiledNode.inputCount < (long)this.minSuffixCount1) {
                bl2 = true;
                bl3 = true;
            } else if (i > n) {
                bl2 = unCompiledNode2.inputCount < (long)this.minSuffixCount2 || this.minSuffixCount2 == 1 && unCompiledNode2.inputCount == 1L;
                bl3 = true;
            } else {
                boolean bl4 = bl3 = this.minSuffixCount2 == 0;
            }
            if (unCompiledNode.inputCount < (long)this.minSuffixCount2 || this.minSuffixCount2 == 1 && unCompiledNode.inputCount == 1L) {
                for (int j = 0; j < unCompiledNode.numArcs; ++j) {
                    UnCompiledNode unCompiledNode3 = (UnCompiledNode)unCompiledNode.arcs[j].target;
                    unCompiledNode3.clear();
                }
                unCompiledNode.numArcs = 0;
            }
            if (bl2) {
                unCompiledNode.clear();
                unCompiledNode2.deleteLast(this.lastInput.ints[this.lastInput.offset + i - 1], unCompiledNode);
                continue;
            }
            if (this.minSuffixCount2 != 0) {
                this.compileAllTargets(unCompiledNode, this.lastInput.length - i);
            }
            Object t = unCompiledNode.output;
            boolean bl5 = bl = unCompiledNode.isFinal || unCompiledNode.numArcs == 0;
            if (bl3) {
                unCompiledNode2.replaceLast(this.lastInput.ints[this.lastInput.offset + i - 1], this.compileNode(unCompiledNode, 1 + this.lastInput.length - i), t, bl);
                continue;
            }
            unCompiledNode2.replaceLast(this.lastInput.ints[this.lastInput.offset + i - 1], unCompiledNode, t, bl);
            this.frontier[i] = new UnCompiledNode(this, i);
        }
    }

    public void add(BytesRef bytesRef, T t) throws IOException {
        assert (this.fst.getInputType() == FST.INPUT_TYPE.BYTE1);
        this.scratchIntsRef.grow(bytesRef.length);
        for (int i = 0; i < bytesRef.length; ++i) {
            this.scratchIntsRef.ints[i] = bytesRef.bytes[i + bytesRef.offset] & 0xFF;
        }
        this.scratchIntsRef.length = bytesRef.length;
        this.add(this.scratchIntsRef, t);
    }

    public void add(char[] cArray, int n, int n2, T t) throws IOException {
        assert (this.fst.getInputType() == FST.INPUT_TYPE.BYTE4);
        int n3 = n;
        int n4 = 0;
        int n5 = n + n2;
        while (n3 < n5) {
            int n6;
            this.scratchIntsRef.grow(n4 + 1);
            this.scratchIntsRef.ints[n4] = n6 = Character.codePointAt(cArray, n3);
            n3 += Character.charCount(n6);
            ++n4;
        }
        this.scratchIntsRef.length = n4;
        this.add(this.scratchIntsRef, t);
    }

    public void add(CharSequence charSequence, T t) throws IOException {
        assert (this.fst.getInputType() == FST.INPUT_TYPE.BYTE4);
        int n = 0;
        int n2 = 0;
        int n3 = charSequence.length();
        while (n < n3) {
            int n4;
            this.scratchIntsRef.grow(n2 + 1);
            this.scratchIntsRef.ints[n2] = n4 = Character.codePointAt(charSequence, n);
            n += Character.charCount(n4);
            ++n2;
        }
        this.scratchIntsRef.length = n2;
        this.add(this.scratchIntsRef, t);
    }

    public void add(IntsRef intsRef, T t) throws IOException {
        int n;
        assert (this.lastInput.length == 0 || intsRef.compareTo(this.lastInput) >= 0) : "inputs are added out of order lastInput=" + this.lastInput + " vs input=" + intsRef;
        assert (this.validOutput(t));
        if (intsRef.length == 0) {
            ++this.frontier[0].inputCount;
            this.frontier[0].isFinal = true;
            this.fst.setEmptyOutput(t);
            return;
        }
        int n2 = 0;
        int n3 = intsRef.offset;
        int n4 = Math.min(this.lastInput.length, intsRef.length);
        while (true) {
            ++this.frontier[n2].inputCount;
            if (n2 >= n4 || this.lastInput.ints[n2] != intsRef.ints[n3]) break;
            ++n2;
            ++n3;
        }
        int n5 = n2 + 1;
        if (this.frontier.length < intsRef.length + 1) {
            UnCompiledNode[] unCompiledNodeArray = new UnCompiledNode[ArrayUtil.oversize(intsRef.length + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.frontier, 0, unCompiledNodeArray, 0, this.frontier.length);
            for (n = this.frontier.length; n < unCompiledNodeArray.length; ++n) {
                unCompiledNodeArray[n] = new UnCompiledNode(this, n);
            }
            this.frontier = unCompiledNodeArray;
        }
        this.compilePrevTail(n5);
        for (int i = n5; i <= intsRef.length; ++i) {
            this.frontier[i - 1].addArc(intsRef.ints[intsRef.offset + i - 1], this.frontier[i]);
            ++this.frontier[i].inputCount;
        }
        UnCompiledNode<T> unCompiledNode = this.frontier[intsRef.length];
        unCompiledNode.isFinal = true;
        unCompiledNode.output = this.NO_OUTPUT;
        for (n = 1; n < n5; ++n) {
            T t2;
            T t3;
            UnCompiledNode<T> unCompiledNode2 = this.frontier[n];
            UnCompiledNode<T> unCompiledNode3 = this.frontier[n - 1];
            T t4 = unCompiledNode3.getLastOutput(intsRef.ints[intsRef.offset + n - 1]);
            assert (this.validOutput(t4));
            if (t4 != this.NO_OUTPUT) {
                t3 = this.fst.outputs.common(t, t4);
                assert (this.validOutput(t3));
                t2 = this.fst.outputs.subtract(t4, t3);
                assert (this.validOutput(t2));
                unCompiledNode3.setLastOutput(intsRef.ints[intsRef.offset + n - 1], t3);
                unCompiledNode2.prependOutput(t2);
            } else {
                t3 = t2 = this.NO_OUTPUT;
            }
            t = this.fst.outputs.subtract(t, t3);
            assert (this.validOutput(t));
        }
        if (this.lastInput.length == intsRef.length && n5 == 1 + intsRef.length) {
            unCompiledNode.output = this.fst.outputs.merge(unCompiledNode.output, t);
        } else {
            this.frontier[n5 - 1].setLastOutput(intsRef.ints[intsRef.offset + n5 - 1], t);
        }
        this.lastInput.copy(intsRef);
    }

    private boolean validOutput(T t) {
        return t == this.NO_OUTPUT || !t.equals(this.NO_OUTPUT);
    }

    public FST<T> finish() throws IOException {
        this.compilePrevTail(1);
        if (this.frontier[0].inputCount < (long)this.minSuffixCount1 || this.frontier[0].inputCount < (long)this.minSuffixCount2 || this.frontier[0].numArcs == 0) {
            if (this.fst.emptyOutput == null) {
                return null;
            }
            if (this.minSuffixCount1 > 0 || this.minSuffixCount2 > 0) {
                return null;
            }
            this.fst.finish(this.compileNode(this.frontier[0], (int)this.lastInput.length).address);
            return this.fst;
        }
        if (this.minSuffixCount2 != 0) {
            this.compileAllTargets(this.frontier[0], this.lastInput.length);
        }
        this.fst.finish(this.compileNode(this.frontier[0], (int)this.lastInput.length).address);
        return this.fst;
    }

    private void compileAllTargets(UnCompiledNode<T> unCompiledNode, int n) throws IOException {
        for (int i = 0; i < unCompiledNode.numArcs; ++i) {
            Arc arc = unCompiledNode.arcs[i];
            if (arc.target.isCompiled()) continue;
            UnCompiledNode unCompiledNode2 = (UnCompiledNode)arc.target;
            if (unCompiledNode2.numArcs == 0) {
                unCompiledNode2.isFinal = true;
                arc.isFinal = true;
            }
            arc.target = this.compileNode(unCompiledNode2, n - 1);
        }
    }

    static final class UnCompiledNode<T>
    implements Node {
        final Builder<T> owner;
        int numArcs;
        Arc<T>[] arcs;
        T output;
        boolean isFinal;
        long inputCount;
        final int depth;

        public UnCompiledNode(Builder<T> builder, int n) {
            this.owner = builder;
            this.arcs = new Arc[1];
            this.arcs[0] = new Arc();
            this.output = ((Builder)builder).NO_OUTPUT;
            this.depth = n;
        }

        @Override
        public boolean isCompiled() {
            return false;
        }

        public void clear() {
            this.numArcs = 0;
            this.isFinal = false;
            this.output = ((Builder)this.owner).NO_OUTPUT;
            this.inputCount = 0L;
        }

        public T getLastOutput(int n) {
            assert (this.numArcs > 0);
            assert (this.arcs[this.numArcs - 1].label == n);
            return this.arcs[this.numArcs - 1].output;
        }

        public void addArc(int n, Node node) {
            Object object;
            assert (n >= 0);
            assert (this.numArcs == 0 || n > this.arcs[this.numArcs - 1].label) : "arc[-1].label=" + this.arcs[this.numArcs - 1].label + " new label=" + n + " numArcs=" + this.numArcs;
            if (this.numArcs == this.arcs.length) {
                object = new Arc[ArrayUtil.oversize(this.numArcs + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.arcs, 0, object, 0, this.arcs.length);
                for (int i = this.numArcs; i < ((Arc[])object).length; ++i) {
                    object[i] = new Arc();
                }
                this.arcs = object;
            }
            object = this.arcs[this.numArcs++];
            object.label = n;
            object.target = node;
            object.nextFinalOutput = ((Builder)this.owner).NO_OUTPUT;
            object.output = object.nextFinalOutput;
            object.isFinal = false;
        }

        public void replaceLast(int n, Node node, T t, boolean bl) {
            assert (this.numArcs > 0);
            Arc<T> arc = this.arcs[this.numArcs - 1];
            assert (arc.label == n) : "arc.label=" + arc.label + " vs " + n;
            arc.target = node;
            arc.nextFinalOutput = t;
            arc.isFinal = bl;
        }

        public void deleteLast(int n, Node node) {
            assert (this.numArcs > 0);
            assert (n == this.arcs[this.numArcs - 1].label);
            assert (node == this.arcs[this.numArcs - 1].target);
            --this.numArcs;
        }

        public void setLastOutput(int n, T t) {
            assert (((Builder)this.owner).validOutput(t));
            assert (this.numArcs > 0);
            Arc<T> arc = this.arcs[this.numArcs - 1];
            assert (arc.label == n);
            arc.output = t;
        }

        public void prependOutput(T t) {
            assert (((Builder)this.owner).validOutput(t));
            for (int i = 0; i < this.numArcs; ++i) {
                this.arcs[i].output = ((Builder)this.owner).fst.outputs.add(t, this.arcs[i].output);
                assert (((Builder)this.owner).validOutput(this.arcs[i].output));
            }
            if (this.isFinal) {
                this.output = ((Builder)this.owner).fst.outputs.add(t, this.output);
                assert (((Builder)this.owner).validOutput(this.output));
            }
        }
    }

    static final class CompiledNode
    implements Node {
        int address;

        CompiledNode() {
        }

        @Override
        public boolean isCompiled() {
            return true;
        }
    }

    static interface Node {
        public boolean isCompiled();
    }

    static class Arc<T> {
        public int label;
        public Node target;
        public boolean isFinal;
        public T output;
        public T nextFinalOutput;

        Arc() {
        }
    }
}

