/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTEnum;

public final class BytesRefFSTEnum<T>
extends FSTEnum<T> {
    private final BytesRef current = new BytesRef(10);
    private final InputOutput<T> result = new InputOutput();
    private BytesRef target;

    public BytesRefFSTEnum(FST<T> fST) {
        super(fST);
        this.result.input = this.current;
        this.current.offset = 1;
    }

    public InputOutput<T> current() {
        return this.result;
    }

    public InputOutput<T> next() throws IOException {
        this.doNext();
        return this.setResult();
    }

    public InputOutput<T> seekCeil(BytesRef bytesRef) throws IOException {
        this.target = bytesRef;
        this.targetLength = bytesRef.length;
        super.doSeekCeil();
        return this.setResult();
    }

    public InputOutput<T> seekFloor(BytesRef bytesRef) throws IOException {
        this.target = bytesRef;
        this.targetLength = bytesRef.length;
        super.doSeekFloor();
        return this.setResult();
    }

    @Override
    protected int getTargetLabel() {
        if (this.upto - 1 == this.target.length) {
            return -1;
        }
        return this.target.bytes[this.target.offset + this.upto - 1] & 0xFF;
    }

    @Override
    protected int getCurrentLabel() {
        return this.current.bytes[this.upto] & 0xFF;
    }

    @Override
    protected void setCurrentLabel(int n) {
        this.current.bytes[this.upto] = (byte)n;
    }

    @Override
    protected void grow() {
        this.current.grow(this.upto + 1);
    }

    private InputOutput<T> setResult() {
        if (this.upto == 0) {
            return null;
        }
        this.current.length = this.upto - 1;
        this.result.output = this.output[this.upto];
        return this.result;
    }

    public static class InputOutput<T> {
        public BytesRef input;
        public T output;
    }
}

