/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.CodecUtil;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.Outputs;

public class FST<T> {
    public final INPUT_TYPE inputType;
    private static final int BIT_FINAL_ARC = 1;
    private static final int BIT_LAST_ARC = 2;
    private static final int BIT_TARGET_NEXT = 4;
    private static final int BIT_STOP_NODE = 8;
    private static final int BIT_ARC_HAS_OUTPUT = 16;
    private static final int BIT_ARC_HAS_FINAL_OUTPUT = 32;
    private static final int BIT_ARCS_AS_FIXED_ARRAY = 64;
    static final int FIXED_ARRAY_SHALLOW_DISTANCE = 3;
    static final int FIXED_ARRAY_NUM_ARCS_SHALLOW = 5;
    static final int FIXED_ARRAY_NUM_ARCS_DEEP = 10;
    private int[] bytesPerArc = new int[0];
    private static final String FILE_FORMAT_NAME = "FST";
    private static final int VERSION_START = 0;
    private static final int VERSION_INT_NUM_BYTES_PER_ARC = 1;
    private static final int VERSION_CURRENT = 1;
    private static final int FINAL_END_NODE = -1;
    private static final int NON_FINAL_END_NODE = 0;
    T emptyOutput;
    private byte[] emptyOutputBytes;
    private byte[] bytes;
    int byteUpto = 0;
    private int startNode = -1;
    public final Outputs<T> outputs;
    private int lastFrozenNode;
    private final T NO_OUTPUT;
    public int nodeCount;
    public int arcCount;
    public int arcWithOutputCount;
    public static final int END_LABEL = -1;
    private Arc<T>[] cachedRootArcs;
    private final BytesWriter writer;

    static boolean flag(int n, int n2) {
        return (n & n2) != 0;
    }

    public FST(INPUT_TYPE iNPUT_TYPE, Outputs<T> outputs) {
        this.inputType = iNPUT_TYPE;
        this.outputs = outputs;
        this.bytes = new byte[128];
        this.NO_OUTPUT = outputs.getNoOutput();
        this.writer = new BytesWriter();
        this.emptyOutput = null;
    }

    public FST(DataInput dataInput, Outputs<T> outputs) throws IOException {
        int n;
        this.outputs = outputs;
        this.writer = null;
        CodecUtil.checkHeader(dataInput, FILE_FORMAT_NAME, 1, 1);
        if (dataInput.readByte() == 1) {
            n = dataInput.readVInt();
            this.bytes = new byte[n];
            dataInput.readBytes(this.bytes, 0, n);
            this.emptyOutput = outputs.read(this.getBytesReader(n - 1));
        } else {
            this.emptyOutput = null;
        }
        n = dataInput.readByte();
        switch (n) {
            case 0: {
                this.inputType = INPUT_TYPE.BYTE1;
                break;
            }
            case 1: {
                this.inputType = INPUT_TYPE.BYTE2;
                break;
            }
            case 2: {
                this.inputType = INPUT_TYPE.BYTE4;
                break;
            }
            default: {
                throw new IllegalStateException("invalid input type " + n);
            }
        }
        this.startNode = dataInput.readVInt();
        this.nodeCount = dataInput.readVInt();
        this.arcCount = dataInput.readVInt();
        this.arcWithOutputCount = dataInput.readVInt();
        this.bytes = new byte[dataInput.readVInt()];
        dataInput.readBytes(this.bytes, 0, this.bytes.length);
        this.NO_OUTPUT = outputs.getNoOutput();
        this.cacheRootArcs();
    }

    public INPUT_TYPE getInputType() {
        return this.inputType;
    }

    public int sizeInBytes() {
        return this.bytes.length;
    }

    void finish(int n) throws IOException {
        if (n == -1 && this.emptyOutput != null) {
            n = 0;
        }
        if (this.startNode != -1) {
            throw new IllegalStateException("already finished");
        }
        byte[] byArray = new byte[this.writer.posWrite];
        System.arraycopy(this.bytes, 0, byArray, 0, this.writer.posWrite);
        this.bytes = byArray;
        this.startNode = n;
        this.cacheRootArcs();
    }

    private void cacheRootArcs() throws IOException {
        this.cachedRootArcs = new Arc[128];
        Arc arc = new Arc();
        this.getFirstArc(arc);
        BytesReader bytesReader = this.getBytesReader(0);
        if (this.targetHasArcs(arc)) {
            this.readFirstRealArc(arc.target, arc);
            while (true) {
                assert (arc.label != -1);
                if (arc.label >= this.cachedRootArcs.length) break;
                this.cachedRootArcs[arc.label] = new Arc().copyFrom(arc);
                if (arc.isLast()) break;
                this.readNextRealArc(arc, bytesReader);
            }
        }
    }

    void setEmptyOutput(T t) throws IOException {
        this.emptyOutput = this.emptyOutput != null ? this.outputs.merge(this.emptyOutput, t) : t;
        int n = this.writer.posWrite;
        this.outputs.write(this.emptyOutput, this.writer);
        this.emptyOutputBytes = new byte[this.writer.posWrite - n];
        int n2 = (this.writer.posWrite - n) / 2;
        for (int i = 0; i < n2; ++i) {
            byte by = this.bytes[n + i];
            this.bytes[n + i] = this.bytes[this.writer.posWrite - i - 1];
            this.bytes[this.writer.posWrite - i - 1] = by;
        }
        System.arraycopy(this.bytes, n, this.emptyOutputBytes, 0, this.writer.posWrite - n);
        this.writer.posWrite = n;
    }

    public void save(DataOutput dataOutput) throws IOException {
        if (this.startNode == -1) {
            throw new IllegalStateException("call finish first");
        }
        CodecUtil.writeHeader(dataOutput, FILE_FORMAT_NAME, 1);
        if (this.emptyOutput != null) {
            dataOutput.writeByte((byte)1);
            dataOutput.writeVInt(this.emptyOutputBytes.length);
            dataOutput.writeBytes(this.emptyOutputBytes, 0, this.emptyOutputBytes.length);
        } else {
            dataOutput.writeByte((byte)0);
        }
        int n = this.inputType == INPUT_TYPE.BYTE1 ? 0 : (this.inputType == INPUT_TYPE.BYTE2 ? 1 : 2);
        dataOutput.writeByte((byte)n);
        dataOutput.writeVInt(this.startNode);
        dataOutput.writeVInt(this.nodeCount);
        dataOutput.writeVInt(this.arcCount);
        dataOutput.writeVInt(this.arcWithOutputCount);
        dataOutput.writeVInt(this.bytes.length);
        dataOutput.writeBytes(this.bytes, 0, this.bytes.length);
    }

    private void writeLabel(int n) throws IOException {
        assert (n >= 0) : "v=" + n;
        if (this.inputType == INPUT_TYPE.BYTE1) {
            assert (n <= 255) : "v=" + n;
            this.writer.writeByte((byte)n);
        } else if (this.inputType == INPUT_TYPE.BYTE2) {
            assert (n <= 65535) : "v=" + n;
            this.writer.writeVInt(n);
        } else {
            this.writer.writeVInt(n);
        }
    }

    int readLabel(DataInput dataInput) throws IOException {
        int n = this.inputType == INPUT_TYPE.BYTE1 ? dataInput.readByte() & 0xFF : dataInput.readVInt();
        return n;
    }

    public boolean targetHasArcs(Arc<T> arc) {
        return arc.target > 0;
    }

    int addNode(Builder.UnCompiledNode<T> unCompiledNode) throws IOException {
        int n;
        int n2;
        int n3;
        if (unCompiledNode.numArcs == 0) {
            if (unCompiledNode.isFinal) {
                return -1;
            }
            return 0;
        }
        int n4 = this.writer.posWrite;
        boolean bl = this.shouldExpand(unCompiledNode);
        if (bl) {
            if (this.bytesPerArc.length < unCompiledNode.numArcs) {
                this.bytesPerArc = new int[ArrayUtil.oversize(unCompiledNode.numArcs, 1)];
            }
            this.writer.writeByte((byte)64);
            this.writer.writeVInt(unCompiledNode.numArcs);
            this.writer.writeInt(0);
            n3 = this.writer.posWrite;
        } else {
            n3 = 0;
        }
        ++this.nodeCount;
        this.arcCount += unCompiledNode.numArcs;
        int n5 = unCompiledNode.numArcs - 1;
        int n6 = this.writer.posWrite;
        int n7 = 0;
        for (n2 = 0; n2 < unCompiledNode.numArcs; ++n2) {
            boolean bl2;
            Builder.Arc arc = unCompiledNode.arcs[n2];
            Builder.CompiledNode compiledNode = (Builder.CompiledNode)arc.target;
            n = 0;
            if (n2 == n5) {
                n += 2;
            }
            if (this.lastFrozenNode == compiledNode.address && !bl) {
                n += 4;
            }
            if (arc.isFinal) {
                ++n;
                if (arc.nextFinalOutput != this.NO_OUTPUT) {
                    n += 32;
                }
            } else assert (arc.nextFinalOutput == this.NO_OUTPUT);
            boolean bl3 = bl2 = compiledNode.address > 0;
            if (!bl2) {
                n += 8;
            }
            if (arc.output != this.NO_OUTPUT) {
                n += 16;
            }
            this.writer.writeByte((byte)n);
            this.writeLabel(arc.label);
            if (arc.output != this.NO_OUTPUT) {
                this.outputs.write(arc.output, this.writer);
                ++this.arcWithOutputCount;
            }
            if (arc.nextFinalOutput != this.NO_OUTPUT) {
                this.outputs.write(arc.nextFinalOutput, this.writer);
            }
            if (bl2 && (bl || this.lastFrozenNode != compiledNode.address)) {
                assert (compiledNode.address > 0);
                this.writer.writeInt(compiledNode.address);
            }
            if (!bl) continue;
            this.bytesPerArc[n2] = this.writer.posWrite - n6;
            n6 = this.writer.posWrite;
            n7 = Math.max(n7, this.bytesPerArc[n2]);
        }
        if (bl) {
            int n8;
            assert (n7 > 0);
            n2 = n3 + unCompiledNode.numArcs * n7;
            this.bytes = ArrayUtil.grow(this.bytes, n2);
            this.bytes[n3 - 4] = (byte)(n7 >> 24);
            this.bytes[n3 - 3] = (byte)(n7 >> 16);
            this.bytes[n3 - 2] = (byte)(n7 >> 8);
            this.bytes[n3 - 1] = (byte)n7;
            int n9 = this.writer.posWrite;
            this.writer.posWrite = n8 = n3 + unCompiledNode.numArcs * n7;
            for (n = unCompiledNode.numArcs - 1; n >= 0; --n) {
                if ((n9 -= this.bytesPerArc[n]) == (n8 -= n7)) continue;
                assert (n8 > n9);
                System.arraycopy(this.bytes, n9, this.bytes, n8, this.bytesPerArc[n]);
            }
        }
        n2 = this.lastFrozenNode = this.writer.posWrite - 1;
        int n10 = n4;
        int n11 = n2;
        while (n10 < n11) {
            n = this.bytes[n10];
            this.bytes[n10++] = this.bytes[n11];
            this.bytes[n11--] = n;
        }
        return n2;
    }

    public Arc<T> getFirstArc(Arc<T> arc) {
        if (this.emptyOutput != null) {
            arc.flags = (byte)3;
            arc.nextFinalOutput = this.emptyOutput;
        } else {
            arc.flags = (byte)2;
            arc.nextFinalOutput = this.NO_OUTPUT;
        }
        arc.output = this.NO_OUTPUT;
        arc.target = this.startNode;
        return arc;
    }

    public Arc<T> readLastTargetArc(Arc<T> arc, Arc<T> arc2) throws IOException {
        if (!this.targetHasArcs(arc)) {
            assert (arc.isFinal());
            arc2.label = -1;
            arc2.output = arc.nextFinalOutput;
            arc2.flags = (byte)2;
            return arc2;
        }
        BytesReader bytesReader = this.getBytesReader(arc.target);
        arc2.flags = bytesReader.readByte();
        if (arc2.flag(64)) {
            arc2.numArcs = bytesReader.readVInt();
            arc2.bytesPerArc = bytesReader.readInt();
            arc2.posArcsStart = bytesReader.pos;
            arc2.arcIdx = arc2.numArcs - 2;
        } else {
            arc2.bytesPerArc = 0;
            while (!arc2.isLast()) {
                this.readLabel(bytesReader);
                if (arc2.flag(16)) {
                    this.outputs.read(bytesReader);
                }
                if (arc2.flag(32)) {
                    this.outputs.read(bytesReader);
                }
                if (!arc2.flag(8) && !arc2.flag(4)) {
                    bytesReader.pos -= 4;
                }
                arc2.flags = bytesReader.readByte();
            }
            arc2.nextArc = bytesReader.pos + 1;
        }
        this.readNextRealArc(arc2, bytesReader);
        assert (arc2.isLast());
        return arc2;
    }

    public Arc<T> readFirstTargetArc(Arc<T> arc, Arc<T> arc2) throws IOException {
        if (arc.isFinal()) {
            arc2.label = -1;
            arc2.output = arc.nextFinalOutput;
            if (arc.target <= 0) {
                arc2.flags = (byte)2;
            } else {
                arc2.flags = 0;
                arc2.nextArc = arc.target;
            }
            return arc2;
        }
        return this.readFirstRealArc(arc.target, arc2);
    }

    Arc<T> readFirstRealArc(int n, Arc<T> arc) throws IOException {
        BytesReader bytesReader = this.getBytesReader(n);
        arc.flags = bytesReader.readByte();
        if (arc.flag(64)) {
            arc.numArcs = bytesReader.readVInt();
            arc.bytesPerArc = bytesReader.readInt();
            arc.arcIdx = -1;
            arc.nextArc = arc.posArcsStart = bytesReader.pos;
        } else {
            arc.nextArc = n;
            arc.bytesPerArc = 0;
        }
        return this.readNextRealArc(arc, bytesReader);
    }

    boolean isExpandedTarget(Arc<T> arc) throws IOException {
        if (!this.targetHasArcs(arc)) {
            return false;
        }
        BytesReader bytesReader = this.getBytesReader(arc.target);
        byte by = bytesReader.readByte();
        return (by & 0x40) != 0;
    }

    public Arc<T> readNextArc(Arc<T> arc) throws IOException {
        if (arc.label == -1) {
            if (arc.nextArc <= 0) {
                return null;
            }
            return this.readFirstRealArc(arc.nextArc, arc);
        }
        return this.readNextRealArc(arc, this.getBytesReader(0));
    }

    public int readNextArcLabel(Arc<T> arc) throws IOException {
        BytesReader bytesReader;
        assert (!arc.isLast());
        if (arc.label == -1) {
            bytesReader = this.getBytesReader(arc.nextArc);
            byte by = this.bytes[bytesReader.pos];
            if (FST.flag(by, 64)) {
                --bytesReader.pos;
                bytesReader.readVInt();
                bytesReader.readInt();
            }
        } else {
            bytesReader = arc.bytesPerArc != 0 ? this.getBytesReader(arc.posArcsStart - (1 + arc.arcIdx) * arc.bytesPerArc) : this.getBytesReader(arc.nextArc);
        }
        bytesReader.readByte();
        return this.readLabel(bytesReader);
    }

    Arc<T> readNextRealArc(Arc<T> arc, BytesReader bytesReader) throws IOException {
        if (arc.bytesPerArc != 0) {
            ++arc.arcIdx;
            assert (arc.arcIdx < arc.numArcs);
            bytesReader.pos = arc.posArcsStart - arc.arcIdx * arc.bytesPerArc;
        } else {
            bytesReader.pos = arc.nextArc;
        }
        arc.flags = bytesReader.readByte();
        arc.label = this.readLabel(bytesReader);
        arc.output = arc.flag(16) ? this.outputs.read(bytesReader) : this.outputs.getNoOutput();
        arc.nextFinalOutput = arc.flag(32) ? this.outputs.read(bytesReader) : this.outputs.getNoOutput();
        if (arc.flag(8)) {
            arc.target = arc.flag(1) ? -1 : 0;
            arc.nextArc = bytesReader.pos;
        } else if (arc.flag(4)) {
            arc.nextArc = bytesReader.pos;
            if (!arc.flag(2)) {
                if (arc.bytesPerArc == 0) {
                    this.seekToNextNode(bytesReader);
                } else {
                    bytesReader.pos = arc.posArcsStart - arc.bytesPerArc * arc.numArcs;
                }
            }
            arc.target = bytesReader.pos;
        } else {
            arc.target = bytesReader.readInt();
            arc.nextArc = bytesReader.pos;
        }
        return arc;
    }

    public Arc<T> findTargetArc(int n, Arc<T> arc, Arc<T> arc2) throws IOException {
        assert (this.cachedRootArcs != null);
        if (arc.target == this.startNode && n != -1 && n < this.cachedRootArcs.length) {
            Arc<T> arc3 = this.cachedRootArcs[n];
            if (arc3 == null) {
                return arc3;
            }
            arc2.copyFrom(arc3);
            return arc2;
        }
        if (n == -1) {
            if (arc.isFinal()) {
                arc2.output = arc.nextFinalOutput;
                arc2.label = -1;
                return arc2;
            }
            return null;
        }
        if (!this.targetHasArcs(arc)) {
            return null;
        }
        BytesReader bytesReader = this.getBytesReader(arc.target);
        if ((bytesReader.readByte() & 0x40) != 0) {
            arc2.numArcs = bytesReader.readVInt();
            arc2.bytesPerArc = bytesReader.readInt();
            arc2.posArcsStart = bytesReader.pos;
            int n2 = 0;
            int n3 = arc2.numArcs - 1;
            while (n2 <= n3) {
                int n4 = n2 + n3 >>> 1;
                bytesReader.pos = arc2.posArcsStart - arc2.bytesPerArc * n4 - 1;
                int n5 = this.readLabel(bytesReader);
                int n6 = n5 - n;
                if (n6 < 0) {
                    n2 = n4 + 1;
                    continue;
                }
                if (n6 > 0) {
                    n3 = n4 - 1;
                    continue;
                }
                arc2.arcIdx = n4 - 1;
                return this.readNextRealArc(arc2, bytesReader);
            }
            return null;
        }
        this.readFirstTargetArc(arc, arc2);
        while (arc2.label != n) {
            if (arc2.label > n) {
                return null;
            }
            if (arc2.isLast()) {
                return null;
            }
            this.readNextArc(arc2);
        }
        return arc2;
    }

    private void seekToNextNode(BytesReader bytesReader) throws IOException {
        byte by;
        do {
            by = bytesReader.readByte();
            this.readLabel(bytesReader);
            if (FST.flag(by, 16)) {
                this.outputs.read(bytesReader);
            }
            if (FST.flag(by, 32)) {
                this.outputs.read(bytesReader);
            }
            if (FST.flag(by, 8) || FST.flag(by, 4)) continue;
            bytesReader.readInt();
        } while (!FST.flag(by, 2));
    }

    public int getNodeCount() {
        return 1 + this.nodeCount;
    }

    public int getArcCount() {
        return this.arcCount;
    }

    public int getArcWithOutputCount() {
        return this.arcWithOutputCount;
    }

    private boolean shouldExpand(Builder.UnCompiledNode<T> unCompiledNode) {
        return unCompiledNode.depth <= 3 && unCompiledNode.numArcs >= 5 || unCompiledNode.numArcs >= 10;
    }

    final BytesReader getBytesReader(int n) {
        return new BytesReader(n);
    }

    static /* synthetic */ byte[] access$002(FST fST, byte[] byArray) {
        fST.bytes = byArray;
        return byArray;
    }

    final class BytesReader
    extends DataInput {
        int pos;

        public BytesReader(int n) {
            this.pos = n;
        }

        @Override
        public byte readByte() {
            return FST.this.bytes[this.pos--];
        }

        @Override
        public void readBytes(byte[] byArray, int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                byArray[n + i] = FST.this.bytes[this.pos--];
            }
        }
    }

    class BytesWriter
    extends DataOutput {
        int posWrite = 1;

        @Override
        public void writeByte(byte by) {
            if (FST.this.bytes.length == this.posWrite) {
                FST.access$002(FST.this, ArrayUtil.grow(FST.this.bytes));
            }
            assert (this.posWrite < FST.this.bytes.length) : "posWrite=" + this.posWrite + " bytes.length=" + FST.access$000(FST.this).length;
            ((FST)FST.this).bytes[this.posWrite++] = by;
        }

        @Override
        public void writeBytes(byte[] byArray, int n, int n2) {
            int n3 = this.posWrite + n2;
            FST.access$002(FST.this, ArrayUtil.grow(FST.this.bytes, n3));
            System.arraycopy(byArray, n, FST.this.bytes, this.posWrite, n2);
            this.posWrite += n2;
        }
    }

    public static final class Arc<T> {
        public int label;
        public T output;
        int target;
        byte flags;
        public T nextFinalOutput;
        int nextArc;
        int posArcsStart;
        int bytesPerArc;
        int arcIdx;
        int numArcs;

        public Arc<T> copyFrom(Arc<T> arc) {
            this.label = arc.label;
            this.target = arc.target;
            this.flags = arc.flags;
            this.output = arc.output;
            this.nextFinalOutput = arc.nextFinalOutput;
            this.nextArc = arc.nextArc;
            if (arc.bytesPerArc != 0) {
                this.bytesPerArc = arc.bytesPerArc;
                this.posArcsStart = arc.posArcsStart;
                this.arcIdx = arc.arcIdx;
                this.numArcs = arc.numArcs;
            } else {
                this.bytesPerArc = 0;
            }
            return this;
        }

        boolean flag(int n) {
            return FST.flag(this.flags, n);
        }

        public boolean isLast() {
            return this.flag(2);
        }

        public boolean isFinal() {
            return this.flag(1);
        }
    }

    public static enum INPUT_TYPE {
        BYTE1,
        BYTE2,
        BYTE4;

    }
}

