/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.FST;

abstract class FSTEnum<T> {
    protected final FST<T> fst;
    protected FST.Arc<T>[] arcs = new FST.Arc[10];
    protected T[] output = new Object[10];
    protected final T NO_OUTPUT;
    protected final FST.Arc<T> scratchArc = new FST.Arc();
    protected int upto;
    protected int targetLength;

    protected FSTEnum(FST<T> fST) {
        this.fst = fST;
        this.NO_OUTPUT = fST.outputs.getNoOutput();
        fST.getFirstArc(this.getArc(0));
        this.output[0] = this.NO_OUTPUT;
    }

    protected abstract int getTargetLabel();

    protected abstract int getCurrentLabel();

    protected abstract void setCurrentLabel(int var1);

    protected abstract void grow();

    protected final void rewindPrefix() throws IOException {
        int n;
        if (this.upto == 0) {
            this.upto = 1;
            this.fst.readFirstTargetArc(this.getArc(0), this.getArc(1));
            return;
        }
        int n2 = this.upto;
        this.upto = 1;
        while (this.upto < n2 && this.upto <= this.targetLength + 1 && (n = this.getCurrentLabel() - this.getTargetLabel()) >= 0) {
            if (n > 0) {
                FST.Arc<T> arc = this.getArc(this.upto);
                this.fst.readFirstTargetArc(this.getArc(this.upto - 1), arc);
                break;
            }
            ++this.upto;
        }
    }

    protected void doNext() throws IOException {
        if (this.upto == 0) {
            this.upto = 1;
            this.fst.readFirstTargetArc(this.getArc(0), this.getArc(1));
        } else {
            while (this.arcs[this.upto].isLast()) {
                --this.upto;
                if (this.upto != 0) continue;
                return;
            }
            this.fst.readNextArc(this.arcs[this.upto]);
        }
        this.pushFirst();
    }

    protected void doSeekCeil() throws IOException {
        this.rewindPrefix();
        FST.Arc<T> arc = this.getArc(this.upto);
        int n = this.getTargetLabel();
        while (true) {
            FST.Arc<T> arc2;
            if (arc.bytesPerArc != 0 && arc.label != -1) {
                arc2 = this.fst.getBytesReader(0);
                int n2 = arc.arcIdx;
                int n3 = arc.numArcs - 1;
                int n4 = 0;
                boolean bl = false;
                while (n2 <= n3) {
                    n4 = n2 + n3 >>> 1;
                    ((FST.BytesReader)((Object)arc2)).pos = arc.posArcsStart - arc.bytesPerArc * n4 - 1;
                    int n5 = this.fst.readLabel((DataInput)((Object)arc2));
                    int n6 = n5 - n;
                    if (n6 < 0) {
                        n2 = n4 + 1;
                        continue;
                    }
                    if (n6 > 0) {
                        n3 = n4 - 1;
                        continue;
                    }
                    bl = true;
                    break;
                }
                if (bl) {
                    arc.arcIdx = n4 - 1;
                    this.fst.readNextRealArc(arc, (FST.BytesReader)((Object)arc2));
                    assert (arc.arcIdx == n4);
                    assert (arc.label == n) : "arc.label=" + arc.label + " vs targetLabel=" + n + " mid=" + n4;
                    this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output);
                    if (n == -1) {
                        return;
                    }
                    this.setCurrentLabel(arc.label);
                    this.incr();
                    arc = this.fst.readFirstTargetArc(arc, this.getArc(this.upto));
                    n = this.getTargetLabel();
                    continue;
                }
                if (n2 == arc.numArcs) {
                    arc.arcIdx = arc.numArcs - 2;
                    this.fst.readNextRealArc(arc, (FST.BytesReader)((Object)arc2));
                    assert (arc.isLast());
                    --this.upto;
                    while (true) {
                        if (this.upto == 0) {
                            return;
                        }
                        FST.Arc<T> arc3 = this.getArc(this.upto);
                        if (!arc3.isLast()) {
                            this.fst.readNextArc(arc3);
                            this.pushFirst();
                            return;
                        }
                        --this.upto;
                    }
                }
                arc.arcIdx = (n2 > n3 ? n2 : n3) - 1;
                this.fst.readNextRealArc(arc, (FST.BytesReader)((Object)arc2));
                assert (arc.label > n);
                this.pushFirst();
                return;
            }
            if (arc.label == n) {
                this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output);
                if (n == -1) {
                    return;
                }
                this.setCurrentLabel(arc.label);
                this.incr();
                arc = this.fst.readFirstTargetArc(arc, this.getArc(this.upto));
                n = this.getTargetLabel();
                continue;
            }
            if (arc.label > n) {
                this.pushFirst();
                return;
            }
            if (arc.isLast()) {
                --this.upto;
                while (true) {
                    if (this.upto == 0) {
                        return;
                    }
                    arc2 = this.getArc(this.upto);
                    if (!arc2.isLast()) {
                        this.fst.readNextArc(arc2);
                        this.pushFirst();
                        return;
                    }
                    --this.upto;
                }
            }
            this.fst.readNextArc(arc);
        }
    }

    protected void doSeekFloor() throws IOException {
        this.rewindPrefix();
        FST.Arc<T> arc = this.getArc(this.upto);
        int n = this.getTargetLabel();
        while (true) {
            if (arc.bytesPerArc != 0 && arc.label != -1) {
                FST.BytesReader bytesReader = this.fst.getBytesReader(0);
                int n2 = arc.arcIdx;
                int n3 = arc.numArcs - 1;
                int n4 = 0;
                boolean bl = false;
                while (n2 <= n3) {
                    n4 = n2 + n3 >>> 1;
                    bytesReader.pos = arc.posArcsStart - arc.bytesPerArc * n4 - 1;
                    int n5 = this.fst.readLabel(bytesReader);
                    int n6 = n5 - n;
                    if (n6 < 0) {
                        n2 = n4 + 1;
                        continue;
                    }
                    if (n6 > 0) {
                        n3 = n4 - 1;
                        continue;
                    }
                    bl = true;
                    break;
                }
                if (bl) {
                    arc.arcIdx = n4 - 1;
                    this.fst.readNextRealArc(arc, bytesReader);
                    assert (arc.arcIdx == n4);
                    assert (arc.label == n) : "arc.label=" + arc.label + " vs targetLabel=" + n + " mid=" + n4;
                    this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output);
                    if (n == -1) {
                        return;
                    }
                    this.setCurrentLabel(arc.label);
                    this.incr();
                    arc = this.fst.readFirstTargetArc(arc, this.getArc(this.upto));
                    n = this.getTargetLabel();
                    continue;
                }
                if (n3 == -1) {
                    while (true) {
                        this.fst.readFirstTargetArc(this.getArc(this.upto - 1), arc);
                        if (arc.label < n) {
                            while (!arc.isLast() && this.fst.readNextArcLabel(arc) < n) {
                                this.fst.readNextArc(arc);
                            }
                            this.pushLast();
                            return;
                        }
                        --this.upto;
                        if (this.upto == 0) {
                            return;
                        }
                        n = this.getTargetLabel();
                        arc = this.getArc(this.upto);
                    }
                }
                arc.arcIdx = (n2 > n3 ? n3 : n2) - 1;
                this.fst.readNextRealArc(arc, bytesReader);
                assert (arc.isLast() || this.fst.readNextArcLabel(arc) > n);
                assert (arc.label < n);
                this.pushLast();
                return;
            }
            if (arc.label == n) {
                this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output);
                if (n == -1) {
                    return;
                }
                this.setCurrentLabel(arc.label);
                this.incr();
                arc = this.fst.readFirstTargetArc(arc, this.getArc(this.upto));
                n = this.getTargetLabel();
                continue;
            }
            if (arc.label > n) {
                while (true) {
                    this.fst.readFirstTargetArc(this.getArc(this.upto - 1), arc);
                    if (arc.label < n) {
                        while (!arc.isLast() && this.fst.readNextArcLabel(arc) < n) {
                            this.fst.readNextArc(arc);
                        }
                        this.pushLast();
                        return;
                    }
                    --this.upto;
                    if (this.upto == 0) {
                        return;
                    }
                    n = this.getTargetLabel();
                    arc = this.getArc(this.upto);
                }
            }
            if (arc.isLast()) break;
            if (this.fst.readNextArcLabel(arc) > n) {
                this.pushLast();
                return;
            }
            this.fst.readNextArc(arc);
        }
        this.pushLast();
    }

    private void incr() {
        Object[] objectArray;
        ++this.upto;
        this.grow();
        if (this.arcs.length <= this.upto) {
            objectArray = new FST.Arc[ArrayUtil.oversize(1 + this.upto, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.arcs, 0, objectArray, 0, this.arcs.length);
            this.arcs = objectArray;
        }
        if (this.output.length <= this.upto) {
            objectArray = new Object[ArrayUtil.oversize(1 + this.upto, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.output, 0, objectArray, 0, this.output.length);
            this.output = objectArray;
        }
    }

    private void pushFirst() throws IOException {
        FST.Arc<T> arc = this.arcs[this.upto];
        assert (arc != null);
        while (true) {
            this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output);
            if (arc.label == -1) break;
            this.setCurrentLabel(arc.label);
            this.incr();
            FST.Arc<T> arc2 = this.getArc(this.upto);
            this.fst.readFirstTargetArc(arc, arc2);
            arc = arc2;
        }
    }

    private void pushLast() throws IOException {
        FST.Arc<T> arc = this.arcs[this.upto];
        assert (arc != null);
        while (true) {
            this.setCurrentLabel(arc.label);
            this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output);
            if (arc.label == -1) break;
            this.incr();
            arc = this.fst.readLastTargetArc(arc, this.getArc(this.upto));
        }
    }

    private FST.Arc<T> getArc(int n) {
        if (this.arcs[n] == null) {
            this.arcs[n] = new FST.Arc();
        }
        return this.arcs[n];
    }
}

