/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;

final class NodeHash<T> {
    private int[] table;
    private int count;
    private int mask = 15;
    private final FST<T> fst;
    private final FST.Arc<T> scratchArc = new FST.Arc();

    public NodeHash(FST<T> fST) {
        this.table = new int[16];
        this.fst = fST;
    }

    private boolean nodesEqual(Builder.UnCompiledNode<T> unCompiledNode, int n) throws IOException {
        FST.BytesReader bytesReader = this.fst.getBytesReader(0);
        this.fst.readFirstRealArc(n, this.scratchArc);
        if (this.scratchArc.bytesPerArc != 0 && unCompiledNode.numArcs != this.scratchArc.numArcs) {
            return false;
        }
        for (int i = 0; i < unCompiledNode.numArcs; ++i) {
            Builder.Arc arc = unCompiledNode.arcs[i];
            if (arc.label != this.scratchArc.label || !arc.output.equals(this.scratchArc.output) || ((Builder.CompiledNode)arc.target).address != this.scratchArc.target || !arc.nextFinalOutput.equals(this.scratchArc.nextFinalOutput) || arc.isFinal != this.scratchArc.isFinal()) {
                return false;
            }
            if (this.scratchArc.isLast()) {
                return i == unCompiledNode.numArcs - 1;
            }
            this.fst.readNextRealArc(this.scratchArc, bytesReader);
        }
        return false;
    }

    private int hash(Builder.UnCompiledNode<T> unCompiledNode) {
        int n = 0;
        for (int i = 0; i < unCompiledNode.numArcs; ++i) {
            Builder.Arc arc = unCompiledNode.arcs[i];
            n = 31 * n + arc.label;
            n = 31 * n + ((Builder.CompiledNode)arc.target).address;
            n = 31 * n + arc.output.hashCode();
            n = 31 * n + arc.nextFinalOutput.hashCode();
            if (!arc.isFinal) continue;
            n += 17;
        }
        return n & Integer.MAX_VALUE;
    }

    private int hash(int n) throws IOException {
        FST.BytesReader bytesReader = this.fst.getBytesReader(0);
        int n2 = 0;
        this.fst.readFirstRealArc(n, this.scratchArc);
        while (true) {
            n2 = 31 * n2 + this.scratchArc.label;
            n2 = 31 * n2 + this.scratchArc.target;
            n2 = 31 * n2 + this.scratchArc.output.hashCode();
            n2 = 31 * n2 + this.scratchArc.nextFinalOutput.hashCode();
            if (this.scratchArc.isFinal()) {
                n2 += 17;
            }
            if (this.scratchArc.isLast()) break;
            this.fst.readNextRealArc(this.scratchArc, bytesReader);
        }
        return n2 & Integer.MAX_VALUE;
    }

    public int add(Builder.UnCompiledNode<T> unCompiledNode) throws IOException {
        int n = this.hash(unCompiledNode);
        int n2 = n & this.mask;
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = this.table[n2]) == 0) {
                int n5 = this.fst.addNode(unCompiledNode);
                assert (this.hash(n5) == n) : "frozenHash=" + this.hash(n5) + " vs h=" + n;
                ++this.count;
                this.table[n2] = n5;
                if (this.table.length < 2 * this.count) {
                    this.rehash();
                }
                return n5;
            }
            if (this.nodesEqual(unCompiledNode, n4)) {
                return n4;
            }
            n2 = n2 + ++n3 & this.mask;
        }
    }

    private void addNew(int n) throws IOException {
        int n2 = this.hash(n) & this.mask;
        int n3 = 0;
        while (true) {
            if (this.table[n2] == 0) break;
            n2 = n2 + ++n3 & this.mask;
        }
        this.table[n2] = n;
    }

    private void rehash() throws IOException {
        int[] nArray = this.table;
        this.table = new int[2 * this.table.length];
        this.mask = this.table.length - 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n == 0) continue;
            this.addNew(n);
        }
    }

    public int count() {
        return this.count;
    }
}

