/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.fst.Outputs;

public final class PositiveIntOutputs
extends Outputs<Long> {
    private static final Long NO_OUTPUT = new Long(0L);
    private final boolean doShare;
    private static final PositiveIntOutputs singletonShare = new PositiveIntOutputs(true);
    private static final PositiveIntOutputs singletonNoShare = new PositiveIntOutputs(false);

    private PositiveIntOutputs(boolean bl) {
        this.doShare = bl;
    }

    public static PositiveIntOutputs getSingleton(boolean bl) {
        return bl ? singletonShare : singletonNoShare;
    }

    public Long get(long l) {
        if (l == 0L) {
            return NO_OUTPUT;
        }
        return l;
    }

    @Override
    public Long common(Long l, Long l2) {
        assert (this.valid(l));
        assert (this.valid(l2));
        if (l == NO_OUTPUT || l2 == NO_OUTPUT) {
            return NO_OUTPUT;
        }
        if (this.doShare) {
            assert (l > 0L);
            assert (l2 > 0L);
            return Math.min(l, l2);
        }
        if (l.equals(l2)) {
            return l;
        }
        return NO_OUTPUT;
    }

    @Override
    public Long subtract(Long l, Long l2) {
        assert (this.valid(l));
        assert (this.valid(l2));
        assert (l >= l2);
        if (l2 == NO_OUTPUT) {
            return l;
        }
        if (l.equals(l2)) {
            return NO_OUTPUT;
        }
        return l - l2;
    }

    @Override
    public Long add(Long l, Long l2) {
        assert (this.valid(l));
        assert (this.valid(l2));
        if (l == NO_OUTPUT) {
            return l2;
        }
        if (l2 == NO_OUTPUT) {
            return l;
        }
        return l + l2;
    }

    @Override
    public void write(Long l, DataOutput dataOutput) throws IOException {
        assert (this.valid(l));
        dataOutput.writeVLong(l);
    }

    @Override
    public Long read(DataInput dataInput) throws IOException {
        long l = dataInput.readVLong();
        if (l == 0L) {
            return NO_OUTPUT;
        }
        return l;
    }

    private boolean valid(Long l) {
        assert (l != null);
        assert (l instanceof Long);
        assert (l == NO_OUTPUT || l > 0L);
        return true;
    }

    @Override
    public Long getNoOutput() {
        return NO_OUTPUT;
    }

    @Override
    public String outputToString(Long l) {
        return l.toString();
    }
}

