/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

class Packed32
extends PackedInts.ReaderImpl
implements PackedInts.Mutable {
    static final int BLOCK_SIZE = 32;
    static final int BLOCK_BITS = 5;
    static final int MOD_MASK = 31;
    private static final int ENTRY_SIZE = 33;
    private static final int FAC_BITPOS = 3;
    private static final int[][] SHIFTS;
    private static final int[][] MASKS;
    private static final int[][] WRITE_MASKS;
    private int[] blocks;
    private int maxPos;
    private int[] shifts;
    private int[] readMasks;
    private int[] writeMasks;

    public Packed32(int n, int n2) {
        this(new int[(int)((long)n * (long)n2 / 32L + 2L)], n, n2);
    }

    public Packed32(DataInput dataInput, int n, int n2) throws IOException {
        super(n, n2);
        int n3 = Packed32.size(n2, n);
        this.blocks = new int[n3 + 1];
        for (int i = 0; i < n3; ++i) {
            this.blocks[i] = dataInput.readInt();
        }
        if (n3 % 2 == 1) {
            dataInput.readInt();
        }
        this.updateCached();
    }

    private static int size(int n, int n2) {
        long l = (long)n2 * (long)n;
        return (int)(l / 32L + (long)(l % 32L == 0L ? 0 : 1));
    }

    public Packed32(int[] nArray, int n, int n2) {
        super(n, n2);
        if (n2 > 31) {
            throw new IllegalArgumentException(String.format("This array only supports values of 31 bits or less. The required number of bits was %d. The Packed64 implementation allows values with more than 31 bits", n2));
        }
        this.blocks = nArray;
        this.updateCached();
    }

    private void updateCached() {
        this.readMasks = MASKS[this.bitsPerValue];
        this.maxPos = (int)((long)this.blocks.length * 32L / (long)this.bitsPerValue - 2L);
        this.shifts = SHIFTS[this.bitsPerValue];
        this.writeMasks = WRITE_MASKS[this.bitsPerValue];
    }

    @Override
    public long get(int n) {
        long l = (long)n * (long)this.bitsPerValue;
        int n2 = (int)(l >>> 5);
        int n3 = (int)(l & 0x1FL);
        int n4 = n3 * 3;
        return this.blocks[n2] << this.shifts[n4] >>> this.shifts[n4 + 1] | this.blocks[n2 + 1] >>> this.shifts[n4 + 2] & this.readMasks[n3];
    }

    @Override
    public void set(int n, long l) {
        int n2 = (int)l;
        long l2 = (long)n * (long)this.bitsPerValue;
        int n3 = (int)(l2 >>> 5);
        int n4 = (int)(l2 & 0x1FL);
        int n5 = n4 * 3;
        this.blocks[n3] = this.blocks[n3] & this.writeMasks[n5] | n2 << this.shifts[n5 + 1] >>> this.shifts[n5];
        this.blocks[n3 + 1] = this.blocks[n3 + 1] & this.writeMasks[n5 + 1] | n2 << this.shifts[n5 + 2] & this.writeMasks[n5 + 2];
    }

    @Override
    public void clear() {
        Arrays.fill(this.blocks, 0);
    }

    public String toString() {
        return "Packed32(bitsPerValue=" + this.bitsPerValue + ", maxPos=" + this.maxPos + ", elements.length=" + this.blocks.length + ")";
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.blocks.length * 4;
    }

    static {
        int n;
        int[] nArray;
        int n2;
        int n3;
        SHIFTS = new int[33][99];
        MASKS = new int[33][33];
        for (n3 = 1; n3 <= 32; ++n3) {
            for (n2 = 0; n2 < 32; ++n2) {
                nArray = SHIFTS[n3];
                int n4 = n2 * 3;
                nArray[n4] = n2;
                nArray[n4 + 1] = 32 - n3;
                if (n2 <= 32 - n3) {
                    nArray[n4 + 2] = 0;
                    Packed32.MASKS[n3][n2] = 0;
                    continue;
                }
                n = n3 - (32 - n2);
                nArray[n4 + 2] = 32 - n;
                Packed32.MASKS[n3][n2] = ~(-1 << n);
            }
        }
        WRITE_MASKS = new int[33][99];
        for (n3 = 1; n3 <= 32; ++n3) {
            n2 = ~(-1 << n3);
            nArray = SHIFTS[n3];
            int[] nArray2 = WRITE_MASKS[n3];
            for (n = 0; n < 32; ++n) {
                int n5 = n * 3;
                nArray2[n5] = ~(n2 << nArray[n5 + 1] >>> nArray[n5]);
                if (n <= 32 - n3) {
                    nArray2[n5 + 1] = -1;
                    nArray2[n5 + 2] = 0;
                    continue;
                }
                nArray2[n5 + 1] = ~(n2 << nArray[n5 + 2]);
                nArray2[n5 + 2] = nArray[n5 + 2] == 0 ? 0 : -1;
            }
        }
    }
}

