/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.packed.PackedInts;

class PackedWriter
extends PackedInts.Writer {
    private long pending;
    private int pendingBitPos = 64;
    private final long[] masks;
    private int written = 0;

    public PackedWriter(DataOutput dataOutput, int n, int n2) throws IOException {
        super(dataOutput, n, n2);
        this.masks = new long[n2 - 1];
        long l = 1L;
        for (int i = 0; i < n2 - 1; ++i) {
            this.masks[i] = (l *= 2L) - 1L;
        }
    }

    @Override
    public void add(long l) throws IOException {
        assert (l <= PackedInts.maxValue(this.bitsPerValue)) : "v=" + l + " maxValue=" + PackedInts.maxValue(this.bitsPerValue);
        assert (l >= 0L);
        if (this.pendingBitPos >= this.bitsPerValue) {
            this.pending |= l << this.pendingBitPos - this.bitsPerValue;
            if (this.pendingBitPos == this.bitsPerValue) {
                this.out.writeLong(this.pending);
                this.pending = 0L;
                this.pendingBitPos = 64;
            } else {
                this.pendingBitPos -= this.bitsPerValue;
            }
        } else {
            this.pending |= l >> this.bitsPerValue - this.pendingBitPos & this.masks[this.pendingBitPos - 1];
            this.out.writeLong(this.pending);
            this.pendingBitPos = 64 - this.bitsPerValue + this.pendingBitPos;
            this.pending = l << this.pendingBitPos;
        }
        ++this.written;
    }

    @Override
    public void finish() throws IOException {
        while (this.written < this.valueCount) {
            this.add(0L);
        }
        if (this.pendingBitPos != 64) {
            this.out.writeLong(this.pending);
        }
    }

    public String toString() {
        return "PackedWriter(written " + this.written + "/" + this.valueCount + " with " + this.bitsPerValue + " bits/value)";
    }
}

